/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.mapping.filter;

import grails.util.Metadata;
import grails.web.UrlConverter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.cfg.GrailsConfig;
import org.codehaus.groovy.grails.compiler.GrailsProjectWatcher;
import org.codehaus.groovy.grails.exceptions.DefaultStackTraceFilterer;
import org.codehaus.groovy.grails.exceptions.StackTraceFilterer;
import org.codehaus.groovy.grails.web.mapping.RegexUrlMapping;
import org.codehaus.groovy.grails.web.mapping.UrlMapping;
import org.codehaus.groovy.grails.web.mapping.UrlMappingInfo;
import org.codehaus.groovy.grails.web.mapping.UrlMappingsHolder;
import org.codehaus.groovy.grails.web.mapping.exceptions.UrlMappingException;
import org.codehaus.groovy.grails.web.mime.MimeType;
import org.codehaus.groovy.grails.web.pages.exceptions.GroovyPagesException;
import org.codehaus.groovy.grails.web.servlet.WrappedResponseHolder;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.util.WebUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.util.UrlPathHelper;

public class UrlMappingsFilter
extends OncePerRequestFilter {
    public static final boolean WAR_DEPLOYED = Metadata.getCurrent().isWarDeployed();
    private UrlPathHelper urlHelper = new UrlPathHelper();
    private static final Log LOG = LogFactory.getLog(UrlMappingsFilter.class);
    private static final String GSP_SUFFIX = ".gsp";
    private static final String JSP_SUFFIX = ".jsp";
    private HandlerInterceptor[] handlerInterceptors = new HandlerInterceptor[0];
    private GrailsApplication application;
    private GrailsConfig grailsConfig;
    private ViewResolver viewResolver;
    private MimeType[] mimeTypes;
    private StackTraceFilterer filterer;
    private UrlConverter urlConverter;

    protected void initFilterBean() throws ServletException {
        super.initFilterBean();
        this.urlHelper.setUrlDecode(false);
        ServletContext servletContext = this.getServletContext();
        WebApplicationContext applicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        this.handlerInterceptors = WebUtils.lookupHandlerInterceptors((ServletContext)servletContext);
        this.application = WebUtils.lookupApplication((ServletContext)servletContext);
        this.viewResolver = WebUtils.lookupViewResolver((ServletContext)servletContext);
        ApplicationContext mainContext = this.application.getMainContext();
        this.urlConverter = (UrlConverter)mainContext.getBean("grailsUrlConverter", UrlConverter.class);
        if (this.application != null) {
            this.grailsConfig = new GrailsConfig(this.application);
        }
        if (applicationContext.containsBean("mimeTypes")) {
            this.mimeTypes = (MimeType[])applicationContext.getBean("mimeTypes", MimeType[].class);
        }
        this.createStackTraceFilterer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String format;
        UrlMappingsHolder holder = WebUtils.lookupUrlMappings((ServletContext)this.getServletContext());
        String uri = this.urlHelper.getPathWithinApplication(request);
        if (!"/".equals(uri) && this.noControllers() && this.noRegexMappings(holder)) {
            this.processFilterChain(request, response, filterChain);
            return;
        }
        if (UrlMappingsFilter.isUriExcluded(holder, uri)) {
            this.processFilterChain(request, response, filterChain);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Executing URL mapping filter...");
            LOG.debug((Object)holder);
        }
        if (this.areFileExtensionsEnabled() && (format = WebUtils.getFormatFromURI((String)uri, (MimeType[])this.mimeTypes)) != null) {
            MimeType[] configuredMimes;
            for (MimeType configuredMime : configuredMimes = this.mimeTypes != null ? this.mimeTypes : MimeType.getConfiguredMimeTypes()) {
                if (!configuredMime.getExtension().equals(format)) continue;
                request.setAttribute("org.codehaus.groovy.grails.RESPONSE_FORMAT", (Object)format);
                uri = uri.substring(0, uri.length() - format.length() - 1);
                break;
            }
        }
        GrailsWebRequest webRequest = (GrailsWebRequest)request.getAttribute("org.codehaus.groovy.grails.WEB_REQUEST");
        UrlMappingInfo[] urlInfos = holder.matchAll(uri);
        WrappedResponseHolder.setWrappedResponse((HttpServletResponse)response);
        boolean dispatched = false;
        try {
            Map backupParameters;
            try {
                backupParameters = new HashMap(webRequest.getParams());
            }
            catch (Exception e) {
                LOG.error((Object)("Error creating params object: " + e.getMessage()), (Throwable)e);
                backupParameters = Collections.EMPTY_MAP;
            }
            for (UrlMappingInfo info : urlInfos) {
                String viewName;
                block24: {
                    if (info == null) continue;
                    webRequest.getParams().clear();
                    webRequest.getParams().putAll(backupParameters);
                    try {
                        info.configure(webRequest);
                        String action = info.getActionName() == null ? "" : info.getActionName();
                        viewName = info.getViewName();
                        if (viewName != null || info.getURI() != null) break block24;
                        String controllerName = info.getControllerName();
                        String pluginName = info.getPluginName();
                        String featureUri = '/' + this.urlConverter.toUrlElement(controllerName) + '/' + this.urlConverter.toUrlElement(action);
                        Object featureId = null;
                        if (pluginName != null) {
                            HashMap<String, String> featureIdMap = new HashMap<String, String>();
                            featureIdMap.put("uri", featureUri);
                            featureIdMap.put("pluginName", pluginName);
                            featureId = featureIdMap;
                        } else {
                            featureId = featureUri;
                        }
                        GrailsClass controller = this.application.getArtefactForFeature("Controller", featureId);
                        if (controller == null) continue;
                        webRequest.setAttribute("org.codehaus.groovy.grails.CONTROLLER_NAME_ATTRIBUTE", (Object)controller.getLogicalPropertyName(), 0);
                        webRequest.setAttribute("org.codehaus.groovy.grails.GRAILS_CONTROLLER_CLASS", (Object)controller, 0);
                    }
                    catch (Exception e) {
                        if (e instanceof MultipartException) {
                            this.reapplySitemesh(request);
                            throw (MultipartException)e;
                        }
                        LOG.error((Object)("Error when matching URL mapping [" + info + "]:" + e.getMessage()), (Throwable)e);
                        continue;
                    }
                }
                dispatched = true;
                if (!WAR_DEPLOYED) {
                    this.checkDevelopmentReloadingState(request);
                }
                request = this.checkMultipart(request);
                if (viewName == null || viewName.endsWith(GSP_SUFFIX) || viewName.endsWith(JSP_SUFFIX)) {
                    if (info.isParsingRequest()) {
                        webRequest.informParameterCreationListeners();
                    }
                    String forwardUrl = WebUtils.forwardRequestForUrlMappingInfo((HttpServletRequest)request, (HttpServletResponse)response, (UrlMappingInfo)info);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Matched URI [" + uri + "] to URL mapping [" + info + "], forwarding to [" + forwardUrl + "] with response [" + response.getClass() + "]"));
                    }
                } else if (!this.renderViewForUrlMappingInfo(request, response, info, viewName)) {
                    dispatched = false;
                }
                break;
            }
        }
        finally {
            WrappedResponseHolder.setWrappedResponse(null);
        }
        if (!dispatched) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No match found, processing remaining filter chain.");
            }
            this.processFilterChain(request, response, filterChain);
        }
    }

    public static boolean isUriExcluded(UrlMappingsHolder holder, String uri) {
        boolean isExcluded = false;
        List excludePatterns = holder.getExcludePatterns();
        if (excludePatterns != null && excludePatterns.size() > 0) {
            for (String excludePattern : excludePatterns) {
                int wildcardLen = 0;
                if (excludePattern.endsWith("**")) {
                    wildcardLen = 2;
                } else if (excludePattern.endsWith("*")) {
                    wildcardLen = 1;
                }
                if (wildcardLen > 0) {
                    excludePattern = excludePattern.substring(0, excludePattern.length() - wildcardLen);
                }
                if ((wildcardLen != 0 || !uri.equals(excludePattern)) && (wildcardLen <= 0 || !uri.startsWith(excludePattern))) continue;
                isExcluded = true;
                break;
            }
        }
        return isExcluded;
    }

    private boolean areFileExtensionsEnabled() {
        Boolean value;
        if (this.grailsConfig != null && (value = (Boolean)this.grailsConfig.get("grails.mime.file.extensions", Boolean.class)) != null) {
            return value;
        }
        return true;
    }

    private boolean noRegexMappings(UrlMappingsHolder holder) {
        for (UrlMapping mapping : holder.getUrlMappings()) {
            if (!(mapping instanceof RegexUrlMapping)) continue;
            return false;
        }
        return true;
    }

    private boolean noControllers() {
        GrailsClass[] controllers = this.application.getArtefacts("Controller");
        return controllers == null || controllers.length == 0;
    }

    private void checkDevelopmentReloadingState(HttpServletRequest request) {
        while (GrailsProjectWatcher.isReloadInProgress()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        if (request.getAttribute("exception") != null) {
            return;
        }
        MultipleCompilationErrorsException compilationError = GrailsProjectWatcher.getCurrentCompilationError();
        if (compilationError != null) {
            throw compilationError;
        }
        Throwable currentReloadError = GrailsProjectWatcher.getCurrentReloadError();
        if (currentReloadError != null) {
            throw new RuntimeException(currentReloadError);
        }
    }

    protected HttpServletRequest checkMultipart(HttpServletRequest request) throws MultipartException {
        HttpServletRequest resolvedRequest = (HttpServletRequest)request.getAttribute(MultipartHttpServletRequest.class.getName());
        if (resolvedRequest != null) {
            return resolvedRequest;
        }
        return request;
    }

    private boolean renderViewForUrlMappingInfo(HttpServletRequest request, HttpServletResponse response, UrlMappingInfo info, String viewName) {
        if (this.viewResolver != null) {
            try {
                for (HandlerInterceptor handlerInterceptor : this.handlerInterceptors) {
                    if (handlerInterceptor.preHandle(request, response, (Object)this)) continue;
                    return false;
                }
                ModelAndView modelAndView = new ModelAndView(viewName);
                for (HandlerInterceptor handlerInterceptor : this.handlerInterceptors) {
                    handlerInterceptor.postHandle(request, response, (Object)this, modelAndView);
                }
                View v = WebUtils.resolveView((HttpServletRequest)request, (UrlMappingInfo)info, (String)modelAndView.getViewName(), (ViewResolver)this.viewResolver);
                v.render(modelAndView.getModel(), request, response);
                for (HandlerInterceptor handlerInterceptor : this.handlerInterceptors) {
                    handlerInterceptor.afterCompletion(request, response, (Object)this, null);
                }
            }
            catch (Throwable e) {
                this.reapplySitemesh(request);
                for (HandlerInterceptor handlerInterceptor : this.handlerInterceptors) {
                    try {
                        handlerInterceptor.afterCompletion(request, response, (Object)this, e instanceof Exception ? (Exception)e : new GroovyPagesException(e.getMessage(), e));
                    }
                    catch (Exception e1) {
                        UrlMappingException ume = new UrlMappingException("Error executing filter after view error: " + e1.getMessage() + ". Original error: " + e.getMessage(), (Throwable)e1);
                        this.filterAndThrow(ume);
                    }
                }
                UrlMappingException ume = new UrlMappingException("Error mapping onto view [" + viewName + "]: " + e.getMessage(), e);
                this.filterAndThrow(ume);
            }
        }
        return true;
    }

    private void filterAndThrow(UrlMappingException ume) {
        this.filterer.filter((Throwable)ume, true);
        throw ume;
    }

    private void reapplySitemesh(HttpServletRequest request) {
        request.removeAttribute("com.opensymphony.sitemesh.APPLIED_ONCE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFilterChain(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            WrappedResponseHolder.setWrappedResponse((HttpServletResponse)response);
            if (filterChain != null) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
        finally {
            WrappedResponseHolder.setWrappedResponse(null);
        }
    }

    protected void createStackTraceFilterer() {
        try {
            this.filterer = (StackTraceFilterer)GrailsClassUtils.instantiateFromFlatConfig((Map)this.application.getFlatConfig(), (String)"grails.logging.stackTraceFiltererClass", (String)DefaultStackTraceFilterer.class.getName());
        }
        catch (Throwable t) {
            this.logger.error((Object)("Problem instantiating StackTracePrinter class, using default: " + t.getMessage()));
            this.filterer = new DefaultStackTraceFilterer();
        }
    }
}

