/*
 * Decompiled with CFR 0.152.
 */
package grails.validation;

import grails.validation.ASTValidateableHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.grails.compiler.injection.ASTValidationErrorsHelper;
import org.codehaus.groovy.grails.compiler.injection.GrailsArtefactClassInjector;
import org.codehaus.groovy.grails.web.context.ServletContextHolder;
import org.codehaus.groovy.grails.web.plugins.support.ValidationSupport;
import org.codehaus.groovy.syntax.Token;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DefaultASTValidateableHelper
implements ASTValidateableHelper {
    private static final String CONSTRAINED_PROPERTIES_PROPERTY_NAME = "$constraints";
    private static final String VALIDATE_METHOD_NAME = "validate";
    private static final VariableExpression THIS_EXPRESSION = new VariableExpression("this");

    public void injectValidateableCode(ClassNode classNode) {
        ASTValidationErrorsHelper errorsHelper = new ASTValidationErrorsHelper();
        errorsHelper.injectErrorsCode(classNode);
        this.addConstraintsField(classNode);
        this.addStaticInitializer(classNode);
        this.addGetConstraintsMethod(classNode);
        this.addValidateMethod(classNode);
    }

    protected void addConstraintsField(ClassNode classNode) {
        FieldNode field = classNode.getField(CONSTRAINED_PROPERTIES_PROPERTY_NAME);
        if (field == null || !field.getDeclaringClass().equals((Object)classNode)) {
            classNode.addField(CONSTRAINED_PROPERTIES_PROPERTY_NAME, 10, new ClassNode(Map.class), (Expression)new ConstantExpression(null));
        }
    }

    private void addStaticInitializer(ClassNode classNode) {
        BinaryExpression nullOutConstrainedPropertiesExpression = new BinaryExpression((Expression)new VariableExpression(CONSTRAINED_PROPERTIES_PROPERTY_NAME), Token.newSymbol((int)100, (int)0, (int)0), (Expression)new ConstantExpression(null));
        ArrayList<ExpressionStatement> statements = new ArrayList<ExpressionStatement>();
        statements.add(new ExpressionStatement((Expression)nullOutConstrainedPropertiesExpression));
        classNode.addStaticInitializerStatements(statements, true);
    }

    protected void addGetConstraintsMethod(ClassNode classNode) {
        String getConstraintsMethodName = "getConstraints";
        MethodNode getConstraintsMethod = classNode.getMethod("getConstraints", GrailsArtefactClassInjector.ZERO_PARAMETERS);
        if (getConstraintsMethod == null || !getConstraintsMethod.getDeclaringClass().equals((Object)classNode)) {
            BooleanExpression isConstraintsPropertyNull = new BooleanExpression((Expression)new BinaryExpression((Expression)new VariableExpression(CONSTRAINED_PROPERTIES_PROPERTY_NAME), Token.newSymbol((int)123, (int)0, (int)0), (Expression)new ConstantExpression(null)));
            String servletContextHolderVariableName = "$sch";
            String applicationContextVariableName = "$ctx";
            String constraintsEvaluatorVariableName = "$evaluator";
            String evaluateMethodName = "evaluate";
            BlockStatement ifConstraintsPropertyIsNullBlockStatement = new BlockStatement();
            DeclarationExpression declareServletContextExpression = new DeclarationExpression(new VariableExpression("$sch", ClassHelper.OBJECT_TYPE), Token.newSymbol((int)100, (int)0, (int)0), (Expression)new StaticMethodCallExpression(new ClassNode(ServletContextHolder.class), "getServletContext", (Expression)new ArgumentListExpression()));
            DeclarationExpression declareApplicationContextExpression = new DeclarationExpression(new VariableExpression("$ctx", ClassHelper.OBJECT_TYPE), Token.newSymbol((int)100, (int)0, (int)0), (Expression)new StaticMethodCallExpression(new ClassNode(WebApplicationContextUtils.class), "getWebApplicationContext", (Expression)new ArgumentListExpression((Expression)new VariableExpression("$sch"))));
            DeclarationExpression declareConstraintsEvaluatorExpression = new DeclarationExpression(new VariableExpression("$evaluator", ClassHelper.OBJECT_TYPE), Token.newSymbol((int)100, (int)0, (int)0), (Expression)new MethodCallExpression((Expression)new VariableExpression("$ctx"), "getBean", (Expression)new ArgumentListExpression((Expression)new ConstantExpression((Object)"orgGrailsBeansConstraintsEvaluator"))));
            BinaryExpression initializeConstraintsFieldExpression = new BinaryExpression((Expression)new VariableExpression(CONSTRAINED_PROPERTIES_PROPERTY_NAME), Token.newSymbol((int)100, (int)0, (int)0), (Expression)new MethodCallExpression((Expression)new VariableExpression("$evaluator"), "evaluate", (Expression)new ArgumentListExpression((Expression)THIS_EXPRESSION)));
            IfStatement ifConstraintsPropertyIsNullStatement = new IfStatement(isConstraintsPropertyNull, (Statement)ifConstraintsPropertyIsNullBlockStatement, (Statement)new ExpressionStatement((Expression)new EmptyExpression()));
            ifConstraintsPropertyIsNullBlockStatement.addStatement((Statement)new ExpressionStatement((Expression)declareServletContextExpression));
            ifConstraintsPropertyIsNullBlockStatement.addStatement((Statement)new ExpressionStatement((Expression)declareApplicationContextExpression));
            ifConstraintsPropertyIsNullBlockStatement.addStatement((Statement)new ExpressionStatement((Expression)declareConstraintsEvaluatorExpression));
            ifConstraintsPropertyIsNullBlockStatement.addStatement((Statement)new ExpressionStatement((Expression)initializeConstraintsFieldExpression));
            BlockStatement methodBlockStatement = new BlockStatement();
            methodBlockStatement.addStatement((Statement)ifConstraintsPropertyIsNullStatement);
            ReturnStatement returnStatement = new ReturnStatement((Expression)new VariableExpression(CONSTRAINED_PROPERTIES_PROPERTY_NAME));
            methodBlockStatement.addStatement((Statement)returnStatement);
            MethodNode methodNode = new MethodNode("getConstraints", 9, new ClassNode(Map.class), GrailsArtefactClassInjector.ZERO_PARAMETERS, null, (Statement)methodBlockStatement);
            if (classNode.redirect() == null) {
                classNode.addMethod(methodNode);
            } else {
                classNode.redirect().addMethod(methodNode);
            }
        }
    }

    protected void addValidateMethod(ClassNode classNode) {
        MethodNode noArgValidateMethod;
        String fieldsToValidateParameterName = "$fieldsToValidate";
        MethodNode listArgValidateMethod = classNode.getMethod(VALIDATE_METHOD_NAME, new Parameter[]{new Parameter(new ClassNode(List.class), fieldsToValidateParameterName)});
        if (listArgValidateMethod == null) {
            BlockStatement validateMethodCode = new BlockStatement();
            ArgumentListExpression validateInstanceArguments = new ArgumentListExpression();
            validateInstanceArguments.addExpression((Expression)THIS_EXPRESSION);
            validateInstanceArguments.addExpression((Expression)new VariableExpression(fieldsToValidateParameterName));
            ClassNode validationSupportClassNode = new ClassNode(ValidationSupport.class);
            StaticMethodCallExpression invokeValidateInstanceExpression = new StaticMethodCallExpression(validationSupportClassNode, "validateInstance", (Expression)validateInstanceArguments);
            validateMethodCode.addStatement((Statement)new ExpressionStatement((Expression)invokeValidateInstanceExpression));
            Parameter fieldsToValidateParameter = new Parameter(new ClassNode(List.class), fieldsToValidateParameterName);
            classNode.addMethod(new MethodNode(VALIDATE_METHOD_NAME, 1, ClassHelper.boolean_TYPE, new Parameter[]{fieldsToValidateParameter}, GrailsArtefactClassInjector.EMPTY_CLASS_ARRAY, (Statement)validateMethodCode));
        }
        if ((noArgValidateMethod = classNode.getMethod(VALIDATE_METHOD_NAME, GrailsArtefactClassInjector.ZERO_PARAMETERS)) == null) {
            BlockStatement validateMethodCode = new BlockStatement();
            ArgumentListExpression validateInstanceArguments = new ArgumentListExpression();
            validateInstanceArguments.addExpression((Expression)new CastExpression(new ClassNode(List.class), (Expression)new ConstantExpression(null)));
            MethodCallExpression callListArgValidateMethod = new MethodCallExpression((Expression)THIS_EXPRESSION, VALIDATE_METHOD_NAME, (Expression)validateInstanceArguments);
            validateMethodCode.addStatement((Statement)new ReturnStatement((Expression)callListArgValidateMethod));
            classNode.addMethod(new MethodNode(VALIDATE_METHOD_NAME, 1, ClassHelper.boolean_TYPE, GrailsArtefactClassInjector.ZERO_PARAMETERS, GrailsArtefactClassInjector.EMPTY_CLASS_ARRAY, (Statement)validateMethodCode));
        }
    }
}

