/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded.ri;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.springsource.loaded.CurrentLiveVersion;
import org.springsource.loaded.FieldMember;
import org.springsource.loaded.ReloadableType;
import org.springsource.loaded.TypeRegistry;
import org.springsource.loaded.Utils;
import org.springsource.loaded.jvm.JVM;
import org.springsource.loaded.ri.ReflectiveInterceptor;
import sl.org.objectweb.asm.Type;

public class FieldLookup {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class FieldProvider {
        protected FieldProvider() {
        }

        abstract List<FieldRef> getFields();

        public abstract boolean isInterface();

        public abstract FieldProvider[] getInterfaces();

        public abstract FieldProvider getSuper();

        public static FieldProvider create(ReloadableType rtype) {
            return new ReloadableTypeFieldProvider(rtype);
        }

        public static FieldProvider create(TypeRegistry typeRegistry, String slashyName) {
            if (typeRegistry.isReloadableTypeName(slashyName)) {
                return FieldProvider.create(typeRegistry.getReloadableType(slashyName));
            }
            try {
                return FieldProvider.create(Utils.toClass(Type.getObjectType(slashyName), typeRegistry.getClassLoader()));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        public static FieldProvider create(Class<?> clazz) {
            return new JavaClassFieldProvider(clazz);
        }
    }

    static abstract class FieldRef {
        FieldRef() {
        }

        public abstract Field getField();

        public abstract String getName();

        public abstract boolean isPublic();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JavaClassFieldProvider
    extends FieldProvider {
        private Class<?> clazz;

        public JavaClassFieldProvider(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        List<FieldRef> getFields() {
            Field[] fields = this.clazz.getDeclaredFields();
            ArrayList<FieldRef> refs = new ArrayList<FieldRef>();
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                refs.add(new JavaFieldRef(f));
                ++n2;
            }
            return refs;
        }

        @Override
        public boolean isInterface() {
            return this.clazz.isInterface();
        }

        @Override
        public FieldProvider[] getInterfaces() {
            Class<?>[] itfs = this.clazz.getInterfaces();
            FieldProvider[] provs = new FieldProvider[itfs.length];
            int i = 0;
            while (i < itfs.length) {
                provs[i] = FieldProvider.create(itfs[i]);
                ++i;
            }
            return provs;
        }

        @Override
        public FieldProvider getSuper() {
            Class<?> supr = this.clazz.getSuperclass();
            if (supr != null) {
                FieldProvider.create(supr);
            }
            return null;
        }
    }

    private static class JavaFieldRef
    extends FieldRef {
        private Field f;

        public JavaFieldRef(Field f) {
            this.f = f;
        }

        public Field getField() {
            return this.f;
        }

        public String getName() {
            return this.f.getName();
        }

        public boolean isPublic() {
            return Modifier.isPublic(this.f.getModifiers());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReloadableTypeFieldProvider
    extends FieldProvider {
        private ReloadableType rtype;

        public ReloadableTypeFieldProvider(ReloadableType rtype) {
            this.rtype = rtype;
        }

        @Override
        List<FieldRef> getFields() {
            FieldMember[] fields = this.rtype.getLatestTypeDescriptor().getFields();
            ArrayList<FieldRef> refs = new ArrayList<FieldRef>(fields.length);
            FieldMember[] fieldMemberArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                FieldMember f = fieldMemberArray[n2];
                refs.add(this.fieldRef(this.rtype, f));
                ++n2;
            }
            return refs;
        }

        private FieldRef fieldRef(ReloadableType rtype, FieldMember f) {
            CurrentLiveVersion clv = rtype.getLiveVersion();
            if (clv == null) {
                try {
                    Field jf = rtype.getClazz().getDeclaredField(f.getName());
                    ReflectiveInterceptor.fixModifier(rtype.getLatestTypeDescriptor(), jf);
                    return new JavaFieldRef(jf);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return new ReloadedTypeFieldRef(rtype, f);
        }

        @Override
        public boolean isInterface() {
            return this.rtype.getLatestTypeDescriptor().isInterface();
        }

        @Override
        public FieldProvider[] getInterfaces() {
            String[] superItfs = this.rtype.getLatestTypeDescriptor().getSuperinterfacesName();
            FieldProvider[] superProvs = new FieldProvider[superItfs.length];
            int i = 0;
            while (i < superItfs.length) {
                superProvs[i] = FieldProvider.create(this.rtype.typeRegistry, superItfs[i]);
                ++i;
            }
            return superProvs;
        }

        @Override
        public FieldProvider getSuper() {
            String supr = this.rtype.getLatestTypeDescriptor().getSupertypeName();
            if (supr != null) {
                return FieldProvider.create(this.rtype.typeRegistry, supr);
            }
            return null;
        }
    }

    public static class ReloadedTypeFieldRef
    extends FieldRef {
        private ReloadableType rtype;
        private FieldMember f;

        public ReloadedTypeFieldRef(ReloadableType rtype, FieldMember f) {
            this.rtype = rtype;
            this.f = f;
        }

        public Field getField() {
            Class<?> type;
            Class<?> declaring = Utils.toClass(this.rtype);
            try {
                type = Utils.toClass(Type.getType(this.f.getDescriptor()), this.rtype.typeRegistry.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            return JVM.newField(declaring, type, this.f.getModifiers(), this.f.getName(), this.f.getGenericSignature());
        }

        public String getName() {
            return this.f.getName();
        }

        public boolean isPublic() {
            return this.f.isPublic();
        }
    }
}

