/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.io.support;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;

public class IOUtils {
    public static final int BUFFER_SIZE = 4096;

    public static Object[] addAll(Object[] array1, Object[] array2) {
        Object[] joinedArray = (Object[])Array.newInstance(array1.getClass().getComponentType(), array1.length + array2.length);
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        try {
            System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        }
        catch (ArrayStoreException ase) {
            Class<?> type1 = array1.getClass().getComponentType();
            Class<?> type2 = array2.getClass().getComponentType();
            if (!type1.isAssignableFrom(type2)) {
                throw new IllegalArgumentException("Cannot store " + type2.getName() + " in an array of " + type1.getName());
            }
            throw ase;
        }
        return joinedArray;
    }

    public static int copy(File in, File out) throws IOException {
        assert (in != null) : "No input File specified";
        assert (out != null) : "No output File specified";
        return IOUtils.copy(new BufferedInputStream(new FileInputStream(in)), (OutputStream)new BufferedOutputStream(new FileOutputStream(out)));
    }

    public static void copy(byte[] in, File out) throws IOException {
        assert (in != null) : "No input byte array specified";
        assert (out != null) : "No output File specified";
        ByteArrayInputStream inStream = new ByteArrayInputStream(in);
        BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(out));
        IOUtils.copy(inStream, (OutputStream)outStream);
    }

    public static byte[] copyToByteArray(File in) throws IOException {
        assert (in != null) : "No input File specified";
        return IOUtils.copyToByteArray(new BufferedInputStream(new FileInputStream(in)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream in, OutputStream out) throws IOException {
        assert (in != null) : "No input stream specified";
        assert (out != null) : "No output stream specified";
        try {
            int byteCount = 0;
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            int n = byteCount;
            return n;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {}
            try {
                out.close();
            }
            catch (IOException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(byte[] in, OutputStream out) throws IOException {
        assert (in != null) : "No input byte array specified";
        assert (out != null) : "No output stream specified";
        try {
            out.write(in);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] copyToByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        IOUtils.copy(in, (OutputStream)out);
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(Reader in, Writer out) throws IOException {
        assert (in != null) : "No input Reader specified";
        assert (out != null) : "No output Writer specified";
        try {
            int byteCount = 0;
            char[] buffer = new char[4096];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            int n = byteCount;
            return n;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {}
            try {
                out.close();
            }
            catch (IOException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String in, Writer out) throws IOException {
        assert (in != null) : "No input String specified";
        assert (out != null) : "No output Writer specified";
        try {
            out.write(in);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String copyToString(Reader in) throws IOException {
        StringWriter out = new StringWriter();
        IOUtils.copy(in, (Writer)out);
        return out.toString();
    }
}

