/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.resolve;

import groovy.util.XmlSlurper;
import groovy.util.slurpersupport.GPathResult;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.URLResolver;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.plugins.resolver.util.ResourceMDParser;
import org.apache.ivy.util.url.IvyAuthenticator;
import org.codehaus.groovy.grails.resolve.GrailsRepository;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class GrailsRepoResolver
extends URLResolver {
    protected URL repositoryRoot;
    private Map<File, GPathResult> parsedXmlCache = new ConcurrentHashMap<File, GPathResult>();

    public GrailsRepoResolver(String name, URL repositoryRoot) {
        this.repositoryRoot = repositoryRoot;
        this.setName(name);
        this.setRepository((Repository)new GrailsRepository());
    }

    public URL getRepositoryRoot() {
        return this.repositoryRoot;
    }

    protected ResolvedResource findResourceUsingPattern(ModuleRevisionId mrid, String pattern, Artifact artifact, ResourceMDParser rmdparser, Date date) {
        this.installIvyAuth();
        pattern = this.transformGrailsRepositoryPattern(mrid, pattern);
        return super.findResourceUsingPattern(mrid, pattern, artifact, rmdparser, date);
    }

    private void installIvyAuth() {
        IvyAuthenticator.install();
    }

    public String transformGrailsRepositoryPattern(ModuleRevisionId mrid, String pattern) {
        String revision = mrid.getRevision();
        String versionTag = revision.equals("latest.integration") || revision.equals("latest") || revision.equals("latest.release") ? "LATEST_RELEASE" : "RELEASE_[revision]";
        return pattern.replace("RELEASE_*", versionTag);
    }

    public GPathResult getPluginList(File localFile) {
        GPathResult parsedXml = this.parsedXmlCache.get(localFile);
        if (parsedXml == null) {
            this.installIvyAuth();
            try {
                Repository repo = this.getRepository();
                List list = repo.list(this.repositoryRoot.toString());
                for (Object entry : list) {
                    String url = entry.toString();
                    if (!url.contains(".plugin-meta")) continue;
                    List metaList = repo.list(url);
                    for (Object current : metaList) {
                        url = current.toString();
                        if (!url.contains("plugins-list.xml")) continue;
                        Resource remoteFile = repo.getResource(url);
                        if (localFile.lastModified() < remoteFile.getLastModified()) {
                            repo.get(url, localFile);
                        }
                        XmlSlurper xmlSlurper = new XmlSlurper();
                        xmlSlurper.setErrorHandler(new ErrorHandler(){

                            public void warning(SAXParseException e) throws SAXException {
                            }

                            public void error(SAXParseException e) throws SAXException {
                            }

                            public void fatalError(SAXParseException e) throws SAXException {
                            }
                        });
                        parsedXml = xmlSlurper.parse(localFile);
                        this.parsedXmlCache.put(localFile, parsedXml);
                    }
                }
            }
            catch (IOException e) {
                return null;
            }
            catch (SAXException e) {
                return null;
            }
            catch (ParserConfigurationException e) {
                return null;
            }
        }
        return parsedXml;
    }
}

