/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.validation;

import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;

public class ValidationException
extends DataIntegrityViolationException {
    private static final long serialVersionUID = 1L;
    private String fullMessage;

    public ValidationException(String msg, Errors errors) {
        super(msg);
        this.fullMessage = ValidationException.formatErrors(errors, msg);
    }

    public String getMessage() {
        return this.fullMessage;
    }

    public static String formatErrors(Errors errors, String msg) {
        String ls = System.getProperty("line.separator");
        StringBuilder b = new StringBuilder();
        if (msg != null) {
            b.append(msg).append(" : ").append(ls);
        }
        for (ObjectError error : errors.getAllErrors()) {
            b.append(ls).append(" - ").append(error).append(ls);
        }
        return b.toString();
    }
}

