/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.FlushModeType;
import org.codehaus.groovy.grails.domain.GrailsDomainClassMappingContext;
import org.codehaus.groovy.grails.orm.hibernate.GrailsHibernateTemplate;
import org.codehaus.groovy.grails.orm.hibernate.HibernateDatastore;
import org.codehaus.groovy.grails.orm.hibernate.query.HibernateQuery;
import org.grails.datastore.mapping.core.AbstractAttributeStoringSession;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.engine.Persister;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.api.QueryableCriteria;
import org.grails.datastore.mapping.query.jpa.JpaQueryBuilder;
import org.grails.datastore.mapping.query.jpa.JpaQueryInfo;
import org.grails.datastore.mapping.transactions.Transaction;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateSession
extends AbstractAttributeStoringSession {
    private GrailsHibernateTemplate hibernateTemplate;
    private HibernateDatastore datastore;
    private boolean connected = true;

    public HibernateSession(HibernateDatastore hibernateDatastore, SessionFactory sessionFactory) {
        this.datastore = hibernateDatastore;
        this.hibernateTemplate = this.datastore.getMappingContext() instanceof GrailsDomainClassMappingContext ? new GrailsHibernateTemplate(sessionFactory, ((GrailsDomainClassMappingContext)this.datastore.getMappingContext()).getGrailsApplication()) : new GrailsHibernateTemplate(sessionFactory);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void disconnect() {
        this.connected = false;
    }

    public Transaction beginTransaction() {
        throw new UnsupportedOperationException("Use HibernatePlatformTransactionManager instead");
    }

    public MappingContext getMappingContext() {
        return this.getDatastore().getMappingContext();
    }

    public Serializable persist(Object o) {
        return this.hibernateTemplate.save(o);
    }

    public void refresh(Object o) {
        this.hibernateTemplate.refresh(o);
    }

    public void attach(Object o) {
        this.hibernateTemplate.lock(o, LockMode.NONE);
    }

    public void flush() {
        this.hibernateTemplate.flush();
    }

    public void clear() {
        this.hibernateTemplate.clear();
    }

    public void clear(Object o) {
        this.hibernateTemplate.evict(o);
    }

    public boolean contains(Object o) {
        return this.hibernateTemplate.contains(o);
    }

    public void setFlushMode(FlushModeType flushMode) {
        if (flushMode == FlushModeType.AUTO) {
            this.hibernateTemplate.setFlushMode(1);
        } else if (flushMode == FlushModeType.COMMIT) {
            this.hibernateTemplate.setFlushMode(3);
        }
    }

    public FlushModeType getFlushMode() {
        switch (this.hibernateTemplate.getFlushMode()) {
            case 1: {
                return FlushModeType.AUTO;
            }
            case 3: {
                return FlushModeType.COMMIT;
            }
            case 4: {
                return FlushModeType.AUTO;
            }
        }
        return FlushModeType.AUTO;
    }

    public void lock(Object o) {
        this.hibernateTemplate.lock(o, LockMode.PESSIMISTIC_WRITE);
    }

    public void unlock(Object o) {
    }

    public List<Serializable> persist(Iterable objects) {
        ArrayList<Serializable> identifiers = new ArrayList<Serializable>();
        for (Object object : objects) {
            identifiers.add(this.hibernateTemplate.save(object));
        }
        return identifiers;
    }

    public <T> T retrieve(Class<T> type, Serializable key) {
        return (T)this.hibernateTemplate.get(type, key);
    }

    public <T> T proxy(Class<T> type, Serializable key) {
        return (T)this.hibernateTemplate.load(type, key);
    }

    public <T> T lock(Class<T> type, Serializable key) {
        return (T)this.hibernateTemplate.get(type, key, LockMode.PESSIMISTIC_WRITE);
    }

    public void delete(Iterable objects) {
        Collection list = this.getIterableAsCollection(objects);
        this.hibernateTemplate.deleteAll(list);
    }

    Collection getIterableAsCollection(Iterable objects) {
        ArrayList list;
        if (objects instanceof Collection) {
            list = (ArrayList)objects;
        } else {
            list = new ArrayList();
            for (Object object : objects) {
                list.add(object);
            }
        }
        return list;
    }

    public void delete(Object obj) {
        this.hibernateTemplate.delete(obj);
    }

    public int deleteAll(final QueryableCriteria criteria) {
        return (Integer)this.hibernateTemplate.execute((HibernateCallback)new HibernateCallback<Integer>(){

            public Integer doInHibernate(Session session) throws HibernateException, SQLException {
                JpaQueryBuilder builder = new JpaQueryBuilder(criteria);
                builder.setHibernateCompatible(true);
                JpaQueryInfo jpaQueryInfo = builder.buildDelete();
                org.hibernate.Query query = session.createQuery(jpaQueryInfo.getQuery());
                HibernateSession.this.hibernateTemplate.applySettings(query);
                List parameters = jpaQueryInfo.getParameters();
                if (parameters != null) {
                    int count = parameters.size();
                    for (int i = 0; i < count; ++i) {
                        query.setParameter(i, parameters.get(i));
                    }
                }
                return query.executeUpdate();
            }
        });
    }

    public int updateAll(final QueryableCriteria criteria, final Map<String, Object> properties) {
        return (Integer)this.hibernateTemplate.execute((HibernateCallback)new HibernateCallback<Integer>(){

            public Integer doInHibernate(Session session) throws HibernateException, SQLException {
                JpaQueryBuilder builder = new JpaQueryBuilder(criteria);
                builder.setHibernateCompatible(true);
                JpaQueryInfo jpaQueryInfo = builder.buildUpdate(properties);
                org.hibernate.Query query = session.createQuery(jpaQueryInfo.getQuery());
                HibernateSession.this.hibernateTemplate.applySettings(query);
                List parameters = jpaQueryInfo.getParameters();
                if (parameters != null) {
                    int count = parameters.size();
                    for (int i = 0; i < count; ++i) {
                        query.setParameter(i, parameters.get(i));
                    }
                }
                return query.executeUpdate();
            }
        });
    }

    public List retrieveAll(final Class type, final Iterable keys) {
        final PersistentEntity persistentEntity = this.getMappingContext().getPersistentEntity(type.getName());
        return (List)this.hibernateTemplate.execute((HibernateCallback)new HibernateCallback<List>(){

            public List doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria criteria = session.createCriteria(type);
                HibernateSession.this.hibernateTemplate.applySettings(criteria);
                return criteria.add(Restrictions.in((String)persistentEntity.getIdentity().getName(), (Collection)HibernateSession.this.getIterableAsCollection(keys))).list();
            }
        });
    }

    public List retrieveAll(Class type, Serializable ... keys) {
        return this.retrieveAll(type, Arrays.asList(keys));
    }

    public Query createQuery(Class type) {
        PersistentEntity persistentEntity = this.getMappingContext().getPersistentEntity(type.getName());
        Criteria criteria = this.hibernateTemplate.getSessionFactory().getCurrentSession().createCriteria(type);
        this.hibernateTemplate.applySettings(criteria);
        return new HibernateQuery(criteria, this, persistentEntity);
    }

    public HibernateTemplate getNativeInterface() {
        return this.hibernateTemplate;
    }

    public Persister getPersister(Object o) {
        return null;
    }

    public Transaction getTransaction() {
        throw new UnsupportedOperationException("Use HibernatePlatformTransactionManager instead");
    }

    public Datastore getDatastore() {
        return this.datastore;
    }

    public boolean isDirty(Object o) {
        return true;
    }
}

