/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler.web;

import groovy.lang.Closure;
import java.net.URL;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.grails.compiler.injection.AstTransformer;
import org.codehaus.groovy.grails.compiler.injection.GrailsArtefactClassInjector;
import org.codehaus.groovy.grails.plugins.web.api.ControllersMimeTypesApi;

@AstTransformer
public class MimeTypesTransformer
implements GrailsArtefactClassInjector {
    public static Pattern CONTROLLER_PATTERN = Pattern.compile(".+/grails-app/controllers/(.+)Controller\\.groovy");
    public static final String FIELD_MIME_TYPES_API = "mimeTypesApi";
    public static final Parameter[] CLOSURE_PARAMETER = new Parameter[]{new Parameter(new ClassNode(Closure.class), "callable")};
    public static final String WITH_FORMAT_METHOD = "withFormat";

    public void performInjection(SourceUnit source, GeneratorContext context, ClassNode classNode) {
        FieldNode field = classNode.getField(FIELD_MIME_TYPES_API);
        if (field == null) {
            ClassNode mimeTypesApiClass = new ClassNode(ControllersMimeTypesApi.class);
            field = new FieldNode(FIELD_MIME_TYPES_API, 10, mimeTypesApiClass, classNode, (Expression)new ConstructorCallExpression(mimeTypesApiClass, (Expression)GrailsArtefactClassInjector.ZERO_ARGS));
            classNode.addField(field);
            BlockStatement methodBody = new BlockStatement();
            ArgumentListExpression args = new ArgumentListExpression();
            args.addExpression((Expression)new VariableExpression("this")).addExpression((Expression)new VariableExpression("callable"));
            methodBody.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new VariableExpression(FIELD_MIME_TYPES_API), WITH_FORMAT_METHOD, (Expression)args)));
            classNode.addMethod(new MethodNode(WITH_FORMAT_METHOD, 1, new ClassNode(Object.class), CLOSURE_PARAMETER, null, (Statement)methodBody));
        }
    }

    public void performInjection(SourceUnit source, ClassNode classNode) {
        this.performInjection(source, null, classNode);
    }

    public boolean shouldInject(URL url) {
        return url != null && CONTROLLER_PATTERN.matcher(url.getFile()).find();
    }

    public String[] getArtefactTypes() {
        return new String[]{"Controller"};
    }
}

