/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.json;

import java.io.IOException;
import java.io.Writer;
import java.util.Stack;
import org.codehaus.groovy.grails.web.json.JSONException;
import org.codehaus.groovy.grails.web.json.JSONObject;

public class JSONWriter {
    protected boolean comma = false;
    protected Mode mode;
    private Stack<Mode> stack = new Stack();
    protected Writer writer;

    public JSONWriter(Writer w) {
        this.mode = Mode.INIT;
        this.writer = w;
    }

    protected JSONWriter append(String s) {
        if (s == null) {
            throw new JSONException("Null pointer");
        }
        if (this.mode == Mode.OBJECT || this.mode == Mode.ARRAY) {
            try {
                if (this.comma && this.mode == Mode.ARRAY) {
                    this.comma();
                }
                this.writer.write(s);
            }
            catch (IOException e) {
                throw new JSONException(e);
            }
            if (this.mode == Mode.OBJECT) {
                this.mode = Mode.KEY;
            }
            this.comma = true;
            return this;
        }
        throw new JSONException("Value out of sequence: expected mode to be OBJECT or ARRAY when writing '" + s + "' but was " + (Object)((Object)this.mode));
    }

    protected void comma() {
        try {
            this.writer.write(44);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    public JSONWriter array() {
        if (this.mode == Mode.INIT || this.mode == Mode.OBJECT || this.mode == Mode.ARRAY) {
            this.push(Mode.ARRAY);
            this.append("[");
            this.comma = false;
            return this;
        }
        throw new JSONException("Misplaced array: expected mode of INIT, OBJECT or ARRAY but was " + (Object)((Object)this.mode));
    }

    protected JSONWriter end(Mode m, char c) {
        if (this.mode != m) {
            throw new JSONException(m == Mode.OBJECT ? "Misplaced endObject." : "Misplaced endArray.");
        }
        this.pop(m);
        try {
            this.writer.write(c);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        this.comma = true;
        return this;
    }

    public JSONWriter endArray() {
        return this.end(Mode.ARRAY, ']');
    }

    public JSONWriter endObject() {
        return this.end(Mode.KEY, '}');
    }

    public JSONWriter key(String s) {
        if (s == null) {
            throw new JSONException("Null key.");
        }
        if (this.mode == Mode.KEY) {
            try {
                if (this.comma) {
                    this.comma();
                }
                this.writer.write(JSONObject.quote(s));
                this.writer.write(58);
                this.comma = false;
                this.mode = Mode.OBJECT;
                return this;
            }
            catch (IOException e) {
                throw new JSONException(e);
            }
        }
        throw new JSONException("Misplaced key: expected mode of KEY but was " + (Object)((Object)this.mode));
    }

    public JSONWriter object() {
        if (this.mode == Mode.INIT) {
            this.mode = Mode.OBJECT;
        }
        if (this.mode == Mode.OBJECT || this.mode == Mode.ARRAY) {
            this.append("{");
            this.push(Mode.KEY);
            this.comma = false;
            return this;
        }
        throw new JSONException("Misplaced object: expected mode of INIT, OBJECT or ARRAY but was " + (Object)((Object)this.mode));
    }

    protected void pop(Mode c) {
        if (this.stack.size() == 0 || this.stack.pop() != c) {
            throw new JSONException("Nesting error.");
        }
        this.mode = this.stack.size() > 0 ? this.stack.peek() : Mode.DONE;
    }

    protected void push(Mode c) {
        this.stack.push(c);
        this.mode = c;
    }

    public JSONWriter value(boolean b) {
        return this.append(b ? "true" : "false");
    }

    public JSONWriter value(double d) {
        return this.value((Object)d);
    }

    public JSONWriter value(long l) {
        return this.append(Long.toString(l));
    }

    public JSONWriter value(Object o) {
        return this.append(JSONObject.valueToString(o));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Mode {
        INIT,
        OBJECT,
        ARRAY,
        KEY,
        DONE;

    }
}

