/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import grails.util.Environment;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Writable;
import groovy.util.slurpersupport.GPathResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.DefaultGrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.spring.GrailsRuntimeConfigurator;
import org.codehaus.groovy.grails.exceptions.DefaultStackTraceFilterer;
import org.codehaus.groovy.grails.exceptions.StackTraceFilterer;
import org.codehaus.groovy.grails.support.MockApplicationContext;
import org.codehaus.groovy.grails.support.MockResourceLoader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.mock.web.MockServletContext;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrailsUtil {
    private static final Log LOG;
    private static final String GRAILS_IMPLEMENTATION_TITLE = "Grails";
    private static final String GRAILS_VERSION;
    private static final StackTraceFilterer stackFilterer;
    private static final boolean LOG_DEPRECATED;

    public static ApplicationContext bootstrapGrailsFromClassPath() {
        LOG.info((Object)"Loading Grails environment");
        ClassPathXmlApplicationContext parent = new ClassPathXmlApplicationContext("applicationContext.xml");
        DefaultGrailsApplication application = (DefaultGrailsApplication)parent.getBean("grailsApplication", DefaultGrailsApplication.class);
        return GrailsUtil.createGrailsApplicationContext((ApplicationContext)parent, application);
    }

    private static ApplicationContext createGrailsApplicationContext(ApplicationContext parent, GrailsApplication application) {
        GrailsRuntimeConfigurator config = new GrailsRuntimeConfigurator(application, parent);
        MockServletContext servletContext = new MockServletContext((ResourceLoader)new MockResourceLoader());
        ConfigurableApplicationContext appCtx = (ConfigurableApplicationContext)config.configure((ServletContext)servletContext);
        servletContext.setAttribute("org.codehaus.groovy.grails.APPLICATION_CONTEXT", (Object)appCtx);
        Assert.notNull((Object)appCtx);
        return appCtx;
    }

    public static ApplicationContext bootstrapGrailsFromApplication(GrailsApplication application) {
        MockApplicationContext parent = new MockApplicationContext();
        parent.registerMockBean("grailsApplication", application);
        return GrailsUtil.createGrailsApplicationContext((ApplicationContext)parent, application);
    }

    public static ApplicationContext bootstrapGrailsFromParentContext(ApplicationContext parent) {
        DefaultGrailsApplication application = (DefaultGrailsApplication)parent.getBean("grailsApplication", DefaultGrailsApplication.class);
        return GrailsUtil.createGrailsApplicationContext(parent, application);
    }

    @Deprecated
    public static String getEnvironment() {
        return Environment.getCurrent().getName();
    }

    public static boolean isDevelopmentEnv() {
        return Environment.getCurrent().equals((Object)Environment.DEVELOPMENT);
    }

    public static String getGrailsVersion() {
        return GRAILS_VERSION;
    }

    private static boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static void deprecated(Class<?> clazz, String methodOrPropName) {
        GrailsUtil.deprecated(clazz, methodOrPropName, GrailsUtil.getGrailsVersion());
    }

    public static void deprecated(Class<?> clazz, String methodOrPropName, String version) {
        if (LOG_DEPRECATED) {
            GrailsUtil.deprecated("Property or method [" + methodOrPropName + "] of class [" + clazz.getName() + "] is deprecated in [" + version + "] and will be removed in future releases");
        }
    }

    public static void deprecated(String message) {
        if (LOG_DEPRECATED && LOG.isWarnEnabled()) {
            LOG.warn((Object)("[DEPRECATED] " + message));
        }
    }

    public static void warn(String message) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("[WARNING] " + message));
        }
    }

    @Deprecated
    public static Throwable sanitize(Throwable t) {
        return stackFilterer.filter(t);
    }

    public static void printSanitizedStackTrace(Throwable t, PrintWriter p) {
        GrailsUtil.printSanitizedStackTrace(t, p, stackFilterer);
    }

    public static void printSanitizedStackTrace(Throwable t, PrintWriter p, StackTraceFilterer stackTraceFilterer) {
        StackTraceElement[] trace;
        t = stackTraceFilterer.filter(t);
        for (StackTraceElement stackTraceElement : trace = t.getStackTrace()) {
            p.println("at " + stackTraceElement.getClassName() + "(" + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber() + ")");
        }
    }

    public static void printSanitizedStackTrace(Throwable t) {
        GrailsUtil.printSanitizedStackTrace(t, new PrintWriter(System.err));
    }

    public static Throwable extractRootCause(Throwable t) {
        Throwable result = t;
        while (result.getCause() != null) {
            result = result.getCause();
        }
        return result;
    }

    public static Throwable sanitizeRootCause(Throwable t) {
        return stackFilterer.filter(GrailsUtil.extractRootCause(t));
    }

    public static Throwable deepSanitize(Throwable t) {
        return stackFilterer.filter(t, true);
    }

    @Deprecated
    public static void writeSlurperResult(GPathResult result, Writer output) throws IOException {
        Binding b = new Binding();
        b.setVariable("node", (Object)result);
        Writable w = (Writable)new GroovyShell(b).evaluate("new groovy.xml.StreamingMarkupBuilder().bind { mkp.declareNamespace(\"\":  \"http://java.sun.com/xml/ns/j2ee\"); mkp.yield node}");
        w.writeTo(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String version;
        LOG = LogFactory.getLog(GrailsUtil.class);
        stackFilterer = new DefaultStackTraceFilterer();
        LOG_DEPRECATED = Boolean.valueOf(System.getProperty("grails.log.deprecated", String.valueOf(Environment.isDevelopmentMode())));
        Package p = GrailsUtil.class.getPackage();
        String string = version = p != null ? p.getImplementationVersion() : null;
        if (version == null || GrailsUtil.isBlank(version)) {
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            try {
                Resource[] manifests = resolver.getResources("classpath*:META-INF/MANIFEST.MF");
                Manifest grailsManifest = null;
                for (int i = 0; i < manifests.length; ++i) {
                    Resource r = manifests[i];
                    InputStream inputStream = null;
                    Manifest mf = null;
                    try {
                        inputStream = r.getInputStream();
                        mf = new Manifest(inputStream);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)inputStream);
                    }
                    String implTitle = mf.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                    if (GrailsUtil.isBlank(implTitle) || !implTitle.equals(GRAILS_IMPLEMENTATION_TITLE)) continue;
                    grailsManifest = mf;
                    break;
                }
                if (grailsManifest != null) {
                    version = grailsManifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                }
                if (GrailsUtil.isBlank(version)) {
                    LOG.error((Object)"Unable to read Grails version from MANIFEST.MF. Are you sure the grails-core jar is on the classpath? ");
                    version = "Unknown";
                }
            }
            catch (Exception e) {
                version = "Unknown";
                LOG.error((Object)("Unable to read Grails version from MANIFEST.MF. Are you sure it the grails-core jar is on the classpath? " + e.getMessage()), (Throwable)e);
            }
        }
        GRAILS_VERSION = version;
    }
}

