/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import grails.persistence.Entity;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import java.util.Map;
import org.codehaus.groovy.grails.commons.ArtefactHandlerAdapter;
import org.codehaus.groovy.grails.commons.ArtefactInfo;
import org.codehaus.groovy.grails.commons.DefaultGrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainConfigurationUtil;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAware;
import org.codehaus.groovy.grails.validation.ConstraintEvalUtils;

public class DomainClassArtefactHandler
extends ArtefactHandlerAdapter
implements GrailsApplicationAware {
    public static final String TYPE = "Domain";
    private Map<String, Object> defaultConstraints;

    public DomainClassArtefactHandler() {
        super(TYPE, GrailsDomainClass.class, DefaultGrailsDomainClass.class, null, true);
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        if (grailsApplication != null) {
            this.defaultConstraints = ConstraintEvalUtils.getDefaultConstraints(grailsApplication.getConfig());
        }
    }

    public GrailsClass newArtefactClass(Class artefactClass) {
        return new DefaultGrailsDomainClass(artefactClass, this.defaultConstraints);
    }

    public void initialize(ArtefactInfo artefacts) {
        this.log.debug((Object)"Configuring domain class relationships");
        GrailsDomainConfigurationUtil.configureDomainClassRelationships(artefacts.getGrailsClasses(), artefacts.getGrailsClassesByName());
    }

    public boolean isArtefactClass(Class clazz) {
        return DomainClassArtefactHandler.isDomainClass(clazz);
    }

    public static boolean isDomainClass(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (Closure.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (GrailsClassUtils.isJdk5Enum(clazz)) {
            return false;
        }
        if (clazz.getAnnotation(Entity.class) != null) {
            return true;
        }
        for (Class testClass = clazz; testClass != null && !testClass.equals(GroovyObject.class) && !testClass.equals(Object.class); testClass = testClass.getSuperclass()) {
            try {
                testClass.getDeclaredField("id");
                testClass.getDeclaredField("version");
                return true;
            }
            catch (SecurityException e) {
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return false;
    }
}

