/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins;

import groovy.util.slurpersupport.GPathResult;
import groovy.util.slurpersupport.Node;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.plugins.BinaryGrailsPluginDescriptor;
import org.codehaus.groovy.grails.plugins.DefaultGrailsPlugin;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryGrailsPlugin
extends DefaultGrailsPlugin {
    public static final String BASE_MESSAGES_PROPERTIES = "grails-app/i18n/messages";
    public static final String VIEWS_PROPERTIES = "views.properties";
    private BinaryGrailsPluginDescriptor descriptor;
    private Class[] providedArtefacts = new Class[0];
    private Map<String, Class> precompiledViewMap = new HashMap<String, Class>();

    public BinaryGrailsPlugin(Class<?> pluginClass, BinaryGrailsPluginDescriptor descriptor, GrailsApplication application) {
        super(pluginClass, application);
        this.descriptor = descriptor;
        if (descriptor != null) {
            this.initializeProvidedArtefacts(descriptor.getParsedXml());
            this.initializeViewMap(descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeViewMap(BinaryGrailsPluginDescriptor descriptor) {
        Resource viewsPropertiesResource;
        Resource descriptorResource = descriptor.getResource();
        try {
            viewsPropertiesResource = descriptorResource.createRelative(VIEWS_PROPERTIES);
        }
        catch (IOException e) {
            return;
        }
        if (viewsPropertiesResource == null || !viewsPropertiesResource.exists()) {
            return;
        }
        Properties viewsProperties = new Properties();
        InputStream input = null;
        try {
            input = viewsPropertiesResource.getInputStream();
            viewsProperties.load(input);
            for (Object view : viewsProperties.keySet()) {
                String viewName = view.toString();
                String viewClassName = viewsProperties.getProperty(viewName);
                try {
                    Class<?> viewClass = this.application.getClassLoader().loadClass(viewClassName);
                    this.precompiledViewMap.put(viewName, viewClass);
                }
                catch (ClassNotFoundException e) {
                    LOG.error((Object)("View not found loading precompiled view from binary plugin [" + this + "]: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Error loading views for binary plugin [" + this + "]: " + e.getMessage()), (Throwable)e);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {}
        }
    }

    protected void initializeProvidedArtefacts(GPathResult descriptor) {
        GPathResult allResources;
        GPathResult resources;
        ArrayList artefacts = new ArrayList();
        if (descriptor != null && !(resources = (GPathResult)descriptor.getProperty("resources")).isEmpty() && !(allResources = (GPathResult)resources.getProperty("resource")).isEmpty()) {
            ClassLoader classLoader = this.application.getClassLoader();
            Iterator i = allResources.nodeIterator();
            while (i.hasNext()) {
                String className = ((Node)i.next()).text();
                try {
                    artefacts.add(classLoader.loadClass(className));
                }
                catch (ClassNotFoundException e) {
                    LOG.error((Object)("Class not found loading plugin resource [" + className + "]. Resource skipped."), (Throwable)e);
                }
            }
        }
        artefacts.addAll(Arrays.asList(super.getProvidedArtefacts()));
        this.providedArtefacts = artefacts.toArray(new Class[artefacts.size()]);
    }

    @Override
    public Class<?>[] getProvidedArtefacts() {
        return this.providedArtefacts;
    }

    public BinaryGrailsPluginDescriptor getBinaryDescriptor() {
        return this.descriptor;
    }

    public Resource getResource(String path) {
        Resource descriptorResource = this.descriptor.getResource();
        try {
            Resource resource = descriptorResource.createRelative("static" + path);
            if (resource.exists()) {
                return resource;
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    public Properties getProperties(Locale locale) {
        Resource i18nDir;
        Resource descriptorResource = this.descriptor.getResource();
        try {
            i18nDir = descriptorResource.createRelative("grails-app/i18n");
        }
        catch (IOException e) {
            return null;
        }
        if (i18nDir == null) {
            return null;
        }
        Properties properties = new Properties();
        String defaultName = BASE_MESSAGES_PROPERTIES;
        this.attemptLoadProperties(descriptorResource, properties, BASE_MESSAGES_PROPERTIES);
        for (String filename : this.calculateFilenamesForLocale(BASE_MESSAGES_PROPERTIES, locale)) {
            this.attemptLoadProperties(descriptorResource, properties, filename);
        }
        return properties;
    }

    private void attemptLoadProperties(Resource descriptorResource, Properties properties, String defaultName) {
        try {
            Resource baseMessagesProperties = descriptorResource.createRelative(defaultName + ".properties");
            if (baseMessagesProperties != null && baseMessagesProperties.exists()) {
                properties.load(baseMessagesProperties.getInputStream());
            }
        }
        catch (IOException e) {
            LOG.debug((Object)("Failed to load plugin [" + this + "] properties for name [" + defaultName + "]: " + e.getMessage()), (Throwable)e);
        }
    }

    protected List<String> calculateFilenamesForLocale(String basename, Locale locale) {
        ArrayList<String> result = new ArrayList<String>(3);
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        StringBuilder temp = new StringBuilder(basename);
        temp.append('_');
        if (language.length() > 0) {
            temp.append(language);
            result.add(0, temp.toString());
        }
        temp.append('_');
        if (country.length() > 0) {
            temp.append(country);
            result.add(0, temp.toString());
        }
        if (variant.length() > 0 && (language.length() > 0 || country.length() > 0)) {
            temp.append('_').append(variant);
            result.add(0, temp.toString());
        }
        return result;
    }

    public Class resolveView(String viewName) {
        String extraPath = "/plugins/" + this.getName() + '-' + this.getVersion() + '/';
        viewName = viewName.replace(extraPath, "/");
        return this.precompiledViewMap.get(viewName);
    }
}

