/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.visitor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.logging.LogFactory;
import liquibase.precondition.core.ErrorPrecondition;
import liquibase.precondition.core.FailedPrecondition;
import liquibase.precondition.core.PreconditionContainer;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatingVisitor
implements ChangeSetVisitor {
    private List<ChangeSet> invalidMD5Sums = new ArrayList<ChangeSet>();
    private List<FailedPrecondition> failedPreconditions = new ArrayList<FailedPrecondition>();
    private List<ErrorPrecondition> errorPreconditions = new ArrayList<ErrorPrecondition>();
    private Set<ChangeSet> duplicateChangeSets = new HashSet<ChangeSet>();
    private List<SetupException> setupExceptions = new ArrayList<SetupException>();
    private List<Throwable> changeValidationExceptions = new ArrayList<Throwable>();
    private ValidationErrors validationErrors = new ValidationErrors();
    private Warnings warnings = new Warnings();
    private Set<String> seenChangeSets = new HashSet<String>();
    private List<RanChangeSet> ranChangeSets;
    private Database database;

    public ValidatingVisitor(List<RanChangeSet> ranChangeSets) {
        this.ranChangeSets = ranChangeSets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(Database database, DatabaseChangeLog changeLog) {
        this.database = database;
        PreconditionContainer preconditions = changeLog.getPreconditions();
        try {
            if (preconditions == null) {
                return;
            }
            preconditions.check(database, changeLog, null);
        }
        catch (PreconditionFailedException e) {
            LogFactory.getLogger().debug("Precondition Failed: " + e.getMessage(), e);
            this.failedPreconditions.addAll(e.getFailedPreconditions());
        }
        catch (PreconditionErrorException e) {
            LogFactory.getLogger().debug("Precondition Error: " + e.getMessage(), e);
            this.errorPreconditions.addAll(e.getErrorPreconditions());
        }
        finally {
            try {
                database.rollback();
            }
            catch (DatabaseException e) {
                LogFactory.getLogger().warning("Error rolling back after precondition check", e);
            }
        }
    }

    @Override
    public ChangeSetVisitor.Direction getDirection() {
        return ChangeSetVisitor.Direction.FORWARD;
    }

    @Override
    public void visit(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database) {
        for (Change change : changeSet.getChanges()) {
            try {
                change.init();
            }
            catch (SetupException se) {
                this.setupExceptions.add(se);
            }
            this.warnings.addAll(change.warn(database));
            try {
                ValidationErrors foundErrors = change.validate(database);
                if (foundErrors == null || !foundErrors.hasErrors()) continue;
                if (changeSet.getOnValidationFail().equals((Object)ChangeSet.ValidationFailOption.MARK_RAN)) {
                    LogFactory.getLogger().info("Skipping changeSet " + changeSet + " due to validation error(s): " + StringUtils.join(foundErrors.getErrorMessages(), ", "));
                    changeSet.setValidationFailed(true);
                    continue;
                }
                this.validationErrors.addAll(foundErrors, changeSet);
            }
            catch (Throwable e) {
                this.changeValidationExceptions.add(e);
            }
        }
        for (RanChangeSet ranChangeSet : this.ranChangeSets) {
            if (!ranChangeSet.getId().equalsIgnoreCase(changeSet.getId()) || !ranChangeSet.getAuthor().equalsIgnoreCase(changeSet.getAuthor()) || !ranChangeSet.getChangeLog().equalsIgnoreCase(changeSet.getFilePath()) || changeSet.isCheckSumValid(ranChangeSet.getLastCheckSum()) || changeSet.shouldRunOnChange()) continue;
            this.invalidMD5Sums.add(changeSet);
        }
        String changeSetString = changeSet.toString(false);
        if (this.seenChangeSets.contains(changeSetString)) {
            this.duplicateChangeSets.add(changeSet);
        } else {
            this.seenChangeSets.add(changeSetString);
        }
    }

    public List<ChangeSet> getInvalidMD5Sums() {
        return this.invalidMD5Sums;
    }

    public List<FailedPrecondition> getFailedPreconditions() {
        return this.failedPreconditions;
    }

    public List<ErrorPrecondition> getErrorPreconditions() {
        return this.errorPreconditions;
    }

    public Set<ChangeSet> getDuplicateChangeSets() {
        return this.duplicateChangeSets;
    }

    public List<SetupException> getSetupExceptions() {
        return this.setupExceptions;
    }

    public List<Throwable> getChangeValidationExceptions() {
        return this.changeValidationExceptions;
    }

    public ValidationErrors getValidationErrors() {
        return this.validationErrors;
    }

    public Warnings getWarnings() {
        return this.warnings;
    }

    public boolean validationPassed() {
        return this.invalidMD5Sums.size() == 0 && this.failedPreconditions.size() == 0 && this.errorPreconditions.size() == 0 && this.duplicateChangeSets.size() == 0 && this.changeValidationExceptions.size() == 0 && this.setupExceptions.size() == 0 && !this.validationErrors.hasErrors();
    }

    public Database getDatabase() {
        return this.database;
    }
}

