/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import java.util.HashSet;
import java.util.Set;
import liquibase.database.AbstractDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxDBDatabase
extends AbstractDatabase {
    public static final String PRODUCT_NAME = "SAP DB";
    protected Set<String> systemTablesAndViews = new HashSet<String>();

    public MaxDBDatabase() {
        this.systemTablesAndViews.add("---");
        this.systemTablesAndViews.add("ACTIVECONFIGURATION");
        this.systemTablesAndViews.add("BACKUPTHREADS");
        this.systemTablesAndViews.add("CACHESTATISTICS");
        this.systemTablesAndViews.add("CATALOGCACHESTATISTICS");
        this.systemTablesAndViews.add("COMMANDCACHESTATISTICS");
        this.systemTablesAndViews.add("COMMANDCACHESTATISTICSRESET");
        this.systemTablesAndViews.add("COMMANDSTATISTICS");
        this.systemTablesAndViews.add("COMMANDSTATISTICSRESET");
        this.systemTablesAndViews.add("CONSISTENTVIEWS");
        this.systemTablesAndViews.add("DATACACHE");
        this.systemTablesAndViews.add("DATASTATISTICS");
        this.systemTablesAndViews.add("DATASTATISTICSRESET");
        this.systemTablesAndViews.add("DATAVOLUMES");
        this.systemTablesAndViews.add("DATASTATISTICSRESET");
        this.systemTablesAndViews.add("FILEDIRECTORIES");
        this.systemTablesAndViews.add("FILES");
        this.systemTablesAndViews.add("HOTSTANDBYCOMPONENT");
        this.systemTablesAndViews.add("HOTSTANDBYGROUP");
        this.systemTablesAndViews.add("INSTANCE");
        this.systemTablesAndViews.add("IOBUFFERCACHES");
        this.systemTablesAndViews.add("IOTHREADSTATISTICS");
        this.systemTablesAndViews.add("IOTHREADSTATISTICSRESET");
        this.systemTablesAndViews.add("INDEXSIZE");
        this.systemTablesAndViews.add("INDEXSTORAGEDETAILS");
        this.systemTablesAndViews.add("LOGINFORMATION");
        this.systemTablesAndViews.add("LOGQUEUESTATISTICS");
        this.systemTablesAndViews.add("LOGQUEUESTATISTICSRESET");
        this.systemTablesAndViews.add("LOGSTATISTICS");
        this.systemTablesAndViews.add("LOGSTATISTICSRESET");
        this.systemTablesAndViews.add("LOGVOLUMES");
        this.systemTablesAndViews.add("MACHINECONFIGURATION");
        this.systemTablesAndViews.add("MACHINEUTILIZATION");
        this.systemTablesAndViews.add("MEMORYALLOCATORSTATISTICS");
        this.systemTablesAndViews.add("OPTIMIZERINFORMATION");
        this.systemTablesAndViews.add("READERWRITERLOCKINFORMATION");
        this.systemTablesAndViews.add("READERWRITERLOCKSTATISTICS");
        this.systemTablesAndViews.add("READERWRITERLOCKSTATISTICSRESET");
        this.systemTablesAndViews.add("READERWRITERLOCKWAITINGTASKS");
        this.systemTablesAndViews.add("REGIONINFORMATION");
        this.systemTablesAndViews.add("REGIONSTATISTICS");
        this.systemTablesAndViews.add("REGIONSTATISTICSRESET");
        this.systemTablesAndViews.add("RESTARTINFORMATION");
        this.systemTablesAndViews.add("SCHEMASIZE");
        this.systemTablesAndViews.add("SERVERTASKS");
        this.systemTablesAndViews.add("SESSIONS");
        this.systemTablesAndViews.add("SNAPSHOTS");
        this.systemTablesAndViews.add("SPINLOCKPOOLSTATISTICS");
        this.systemTablesAndViews.add("SPINLOCKPOOLSTATISTICSRESET");
        this.systemTablesAndViews.add("SPINLOCKSTATISTICS");
        this.systemTablesAndViews.add("SPINLOCKSTATISTICSRESET");
        this.systemTablesAndViews.add("TABLESIZE");
        this.systemTablesAndViews.add("TABLESTORAGEDETAILS");
        this.systemTablesAndViews.add("TASKGROUPSTATISTICS");
        this.systemTablesAndViews.add("TASKGROUPSTATISTICSRESET");
        this.systemTablesAndViews.add("TASKLOADBALANCINGINFORMATION");
        this.systemTablesAndViews.add("TASKLOADBALANCINGTASKGROUPSTATES");
        this.systemTablesAndViews.add("TASKLOADBALANCINGTASKMOVES");
        this.systemTablesAndViews.add("TRANSACTIONHISTORY");
        this.systemTablesAndViews.add("TRANSACTIONS");
        this.systemTablesAndViews.add("UNLOADEDSTATEMENTS");
        this.systemTablesAndViews.add("VERSION");
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public Set<String> getSystemTablesAndViews() {
        return this.systemTablesAndViews;
    }

    @Override
    public String getTypeName() {
        return "maxdb";
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return PRODUCT_NAME.equalsIgnoreCase(conn.getDatabaseProductName());
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:sapdb")) {
            return "com.sap.dbtech.jdbc.DriverSapDB";
        }
        return null;
    }

    @Override
    public String getCurrentDateTimeFunction() {
        if (this.currentDateTimeFunction != null) {
            return this.currentDateTimeFunction;
        }
        return "TIMESTAMP";
    }

    @Override
    protected String getDefaultDatabaseSchemaName() throws DatabaseException {
        return super.getDefaultDatabaseSchemaName().toUpperCase();
    }

    @Override
    public boolean isSystemTable(String catalogName, String schemaName, String tableName) {
        if (super.isSystemTable(catalogName, schemaName, tableName)) {
            return true;
        }
        if ("DOMAIN".equalsIgnoreCase(schemaName)) {
            return true;
        }
        if ("SYSINFO".equalsIgnoreCase(schemaName)) {
            return true;
        }
        if ("SYSLOADER".equalsIgnoreCase(schemaName)) {
            return true;
        }
        return "SYSDBA".equalsIgnoreCase(schemaName);
    }

    @Override
    public boolean isSystemView(String catalogName, String schemaName, String tableName) {
        if (super.isSystemView(catalogName, schemaName, tableName)) {
            return true;
        }
        if ("DOMAIN".equalsIgnoreCase(schemaName)) {
            return true;
        }
        if ("SYSINFO".equalsIgnoreCase(schemaName)) {
            return true;
        }
        if ("SYSLOADER".equalsIgnoreCase(schemaName)) {
            return true;
        }
        return "SYSDBA".equalsIgnoreCase(schemaName);
    }

    @Override
    public boolean supportsTablespaces() {
        return false;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return false;
    }
}

