/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import java.util.ArrayList;
import java.util.List;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Table;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueConstraint
implements DatabaseObject,
Comparable<UniqueConstraint> {
    private String name;
    private Table table;
    private List<String> columns = new ArrayList<String>();
    private boolean deferrable;
    private boolean initiallyDeferred;
    private boolean disabled;
    private String tablespace;

    @Override
    public DatabaseObject[] getContainingObjects() {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (String column : this.columns) {
            columns.add(new Column().setName(column).setTable(this.table));
        }
        return columns.toArray(new DatabaseObject[columns.size()]);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String constraintName) {
        this.name = constraintName;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public boolean isDeferrable() {
        return this.deferrable;
    }

    public void setDeferrable(boolean deferrable) {
        this.deferrable = deferrable;
    }

    public boolean isInitiallyDeferred() {
        return this.initiallyDeferred;
    }

    public void setInitiallyDeferred(boolean initiallyDeferred) {
        this.initiallyDeferred = initiallyDeferred;
    }

    public String getColumnNames() {
        return StringUtils.join(this.columns, ", ");
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(String tablespace) {
        this.tablespace = tablespace;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) return false;
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (null == this.getColumnNames()) {
            return false;
        }
        UniqueConstraint that = (UniqueConstraint)o;
        boolean result = false;
        if (this.getColumnNames() != null) {
            if (!this.getColumnNames().equalsIgnoreCase(that.getColumnNames())) {
                return false;
            }
        } else if (that.getColumnNames() != null) return false;
        if (this.isDeferrable() != that.isDeferrable()) return false;
        if (this.isInitiallyDeferred() != that.isInitiallyDeferred()) return false;
        if (this.isDisabled() != that.isDisabled()) return false;
        boolean bl = true;
        result = bl;
        if (!result) return result;
        if (null == this.getTable()) {
            if (null != that.getTable()) return false;
            return true;
        }
        if (null != that.getTable()) return this.getTable().getName().equals(that.getTable().getName());
        return false;
    }

    @Override
    public int compareTo(UniqueConstraint o) {
        String thatTableName;
        String thisTableName = null == this.getTable() ? "" : this.getTable().getName();
        int returnValue = thisTableName.compareTo(thatTableName = null == o.getTable() ? "" : o.getTable().getName());
        if (returnValue == 0) {
            returnValue = this.getName().compareTo(o.getName());
        }
        if (returnValue == 0) {
            returnValue = this.getColumnNames().compareTo(o.getColumnNames());
        }
        return returnValue;
    }

    public int hashCode() {
        int result = 0;
        if (this.table != null) {
            result = this.table.hashCode();
        }
        if (this.name != null) {
            result = 31 * result + this.name.toUpperCase().hashCode();
        }
        if (this.getColumnNames() != null) {
            result = 31 * result + this.getColumnNames().hashCode();
        }
        return result;
    }

    public String toString() {
        return this.getName() + " on " + this.getTable().getName() + "(" + this.getColumnNames() + ")";
    }
}

