/*
 * Decompiled with CFR 0.152.
 */
package liquibase.exception;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationErrors {
    protected List<String> errorMessages = new ArrayList<String>();

    public boolean hasErrors() {
        return this.errorMessages.size() > 0;
    }

    public void checkRequiredField(String requiredFieldName, Object value) {
        if (value == null) {
            this.addError(requiredFieldName + " is required");
        } else if (value instanceof Collection && ((Collection)value).size() == 0) {
            this.addError(requiredFieldName + " is empty");
        } else if (value instanceof Object[] && ((Object[])value).length == 0) {
            this.addError(requiredFieldName + " is empty");
        }
    }

    public void checkDisallowedField(String disallowedFieldName, Object value, Database database, Class<? extends Database> ... disallowedDatabases) {
        boolean isDisallowed = false;
        if (disallowedDatabases == null || disallowedDatabases.length == 0) {
            isDisallowed = true;
        } else {
            for (Class<? extends Database> databaseClass : disallowedDatabases) {
                if (!databaseClass.isAssignableFrom(database.getClass())) continue;
                isDisallowed = true;
            }
        }
        if (isDisallowed && value != null) {
            this.addError(disallowedFieldName + " is not allowed on " + database.getTypeName());
        }
    }

    public void addError(String message) {
        this.errorMessages.add(message);
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public void addAll(ValidationErrors validationErrors) {
        this.errorMessages.addAll(validationErrors.getErrorMessages());
    }

    public void addAll(ValidationErrors validationErrors, ChangeSet changeSet) {
        for (String message : validationErrors.getErrorMessages()) {
            this.errorMessages.add(message + ", " + changeSet);
        }
    }
}

