/*
 * Decompiled with CFR 0.152.
 */
package liquibase.serializer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.servicelocator.ServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeLogSerializerFactory {
    private static ChangeLogSerializerFactory instance;
    private Map<String, ChangeLogSerializer> serializers = new HashMap<String, ChangeLogSerializer>();

    public static void reset() {
        instance = new ChangeLogSerializerFactory();
    }

    public static ChangeLogSerializerFactory getInstance() {
        if (instance == null) {
            instance = new ChangeLogSerializerFactory();
        }
        return instance;
    }

    private ChangeLogSerializerFactory() {
        try {
            Class[] classes;
            for (Class clazz : classes = ServiceLocator.getInstance().findClasses(ChangeLogSerializer.class)) {
                this.register((ChangeLogSerializer)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public Map<String, ChangeLogSerializer> getSerializers() {
        return this.serializers;
    }

    public ChangeLogSerializer getSerializer(String fileNameOrExtension) {
        ChangeLogSerializer changeLogSerializer = this.serializers.get(fileNameOrExtension = fileNameOrExtension.replaceAll(".*\\.", ""));
        if (changeLogSerializer == null) {
            throw new RuntimeException("No serializer associated with the filename or extension '" + fileNameOrExtension + "'");
        }
        return changeLogSerializer;
    }

    public void register(ChangeLogSerializer changeLogSerializer) {
        for (String extension : changeLogSerializer.getValidFileExtensions()) {
            this.serializers.put(extension, changeLogSerializer);
        }
    }

    public void unregister(ChangeLogSerializer changeLogSerializer) {
        ArrayList<Map.Entry<String, ChangeLogSerializer>> entrysToRemove = new ArrayList<Map.Entry<String, ChangeLogSerializer>>();
        for (Map.Entry<String, ChangeLogSerializer> entry : this.serializers.entrySet()) {
            if (!entry.getValue().equals(changeLogSerializer)) continue;
            entrysToRemove.add(entry);
        }
        for (Map.Entry<String, ChangeLogSerializer> entry : entrysToRemove) {
            this.serializers.remove(entry.getKey());
        }
    }
}

