/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.database.Database;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.DatabaseException;
import liquibase.servicelocator.ServiceLocator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.DatabaseSnapshotGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseSnapshotGeneratorFactory {
    private static DatabaseSnapshotGeneratorFactory instance;
    private List<DatabaseSnapshotGenerator> registry = new ArrayList<DatabaseSnapshotGenerator>();

    private DatabaseSnapshotGeneratorFactory() {
        try {
            Class[] classes;
            for (Class clazz : classes = ServiceLocator.getInstance().findClasses(DatabaseSnapshotGenerator.class)) {
                this.register((DatabaseSnapshotGenerator)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static DatabaseSnapshotGeneratorFactory getInstance() {
        if (instance == null) {
            instance = new DatabaseSnapshotGeneratorFactory();
        }
        return instance;
    }

    public DatabaseSnapshotGenerator getGenerator(Database database) {
        return (DatabaseSnapshotGenerator)this.getGenerators(database).iterator().next();
    }

    public SortedSet<DatabaseSnapshotGenerator> getGenerators(final Database database) {
        TreeSet<DatabaseSnapshotGenerator> generators = new TreeSet<DatabaseSnapshotGenerator>(new Comparator<DatabaseSnapshotGenerator>(){

            @Override
            public int compare(DatabaseSnapshotGenerator o1, DatabaseSnapshotGenerator o2) {
                return -1 * Integer.valueOf(o1.getPriority(database)).compareTo(o2.getPriority(database));
            }
        });
        for (DatabaseSnapshotGenerator generator : this.registry) {
            if (!generator.supports(database)) continue;
            generators.add(generator);
        }
        return generators;
    }

    public DatabaseSnapshot createSnapshot(Database database, String schema, Set<DiffStatusListener> listeners) throws DatabaseException {
        return this.getGenerator(database).createSnapshot(database, schema, listeners);
    }

    public List<DatabaseSnapshotGenerator> getRegistry() {
        return this.registry;
    }

    public void register(DatabaseSnapshotGenerator snapshotGenerator) {
        this.registry.add(0, snapshotGenerator);
    }

    public static void resetAll() {
        instance = null;
    }
}

