/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.converters;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.convert.converters.InvalidFormatException;
import org.springframework.binding.convert.converters.StringToObject;
import org.springframework.binding.format.DefaultNumberFormatFactory;
import org.springframework.binding.format.NumberFormatFactory;
import org.springframework.util.NumberUtils;

public class FormattedStringToNumber
extends StringToObject {
    private static Log logger;
    private NumberFormatFactory numberFormatFactory;
    private boolean lenient;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.binding.convert.converters.FormattedStringToNumber");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
    }

    public FormattedStringToNumber() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(clazz);
        this.numberFormatFactory = new DefaultNumberFormatFactory();
    }

    public FormattedStringToNumber(Class numberClass) {
        super(numberClass);
        this.numberFormatFactory = new DefaultNumberFormatFactory();
    }

    public void setNumberFormatFactory(NumberFormatFactory numberFormatFactory) {
        this.numberFormatFactory = numberFormatFactory;
    }

    public boolean getLenient() {
        return this.lenient;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    protected Object toObject(String string, Class targetClass) throws Exception {
        ParsePosition parsePosition = new ParsePosition(0);
        NumberFormat format = this.numberFormatFactory.getNumberFormat();
        Number number = format.parse(string, parsePosition);
        if (number == null) {
            throw new InvalidFormatException(string, this.getPattern(format));
        }
        if (!this.lenient && string.length() != parsePosition.getIndex()) {
            throw new InvalidFormatException(string, this.getPattern(format));
        }
        return this.convertToNumberClass(number, targetClass);
    }

    protected String toString(Object object) throws Exception {
        Number number = (Number)object;
        return this.numberFormatFactory.getNumberFormat().format(number);
    }

    protected Number convertToNumberClass(Number number, Class numberClass) throws IllegalArgumentException {
        return NumberUtils.convertNumberToTargetClass((Number)number, (Class)numberClass);
    }

    private String getPattern(NumberFormat format) {
        if (format instanceof DecimalFormat) {
            return ((DecimalFormat)format).toPattern();
        }
        logger.warn((Object)"Pattern string cannot be determined because NumberFormat is not a DecimalFormat");
        return "defaultNumberFormatInstance";
    }
}

