package org.springframework.uaa.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import org.springframework.uaa.client.internal.JdkUrlTransmissionServiceImpl;

/**
 * Facilitates anonymous uploads and downloads of binary resources.
 * 
 * @author Ben Alex
 * @author Christian Dupuis
 * @since 1.0.1
 * @see JdkUrlTransmissionServiceImpl
 * @see ProxyService
 */
public interface TransmissionService {
	
	/**
	 * Downloads the given {@link URL} resource.
	 * 
	 * @param url the {@link URL} to download
	 * @return stream to access the resource
	 */
	public InputStream download(URL url) throws IOException;
	
	
	/**
	 * Upload the given {@link InputStream} to destination specific to implementation.
	 * 
	 * @param inputStream to upload (cannot be null)
	 * @throws IOException if there is an I/O error
	 * @return <code>true</code> indicating successful upload
	 */
	public boolean upload(InputStream inputStream) throws IOException;

}
