/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 *
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 *
 * Portions Copyright Apache Software Foundation.
 */


package javax.servlet.jsp.tagext;


/**
 * A validation message from either TagLibraryValidator or TagExtraInfo.
 * <p>
 * As of JSP 2.0, a JSP container must support a jsp:id attribute
 * to provide higher quality validation errors.
 * The container will track the JSP pages
 * as passed to the container, and will assign to each element
 * a unique "id", which is passed as the value of the jsp:id
 * attribute.  Each XML element in the XML view available will
 * be extended with this attribute.  The TagLibraryValidator
 * can then use the attribute in one or more ValidationMessage
 * objects.  The container then, in turn, can use these
 * values to provide more precise information on the location
 * of an error.
 *  
 * <p>
 * The actual prefix of the <code>id</code> attribute may or may not be 
 * <code>jsp</code> but it will always map to the namespace
 * <code>http://java.sun.com/JSP/Page</code>.  A TagLibraryValidator
 * implementation must rely on the uri, not the prefix, of the <code>id</code>
 * attribute.
 */

public class ValidationMessage {

    /**
     * Create a ValidationMessage.  The message String should be
     * non-null.  The value of id may be null, if the message
     * is not specific to any XML element, or if no jsp:id
     * attributes were passed on.  If non-null, the value of
     * id must be the value of a jsp:id attribute for the PageData
     * passed into the validate() method.
     *
     * @param id Either null, or the value of a jsp:id attribute.
     * @param message A localized validation message.
     */
    public ValidationMessage(String id, String message) {
	this.id = id;
	this.message = message;
    }


    /**
     * Get the jsp:id.
     * Null means that there is no information available.
     *
     * @return The jsp:id information.
     */
    public String getId() {
	return id;
    }

    /**
     * Get the localized validation message.
     *
     * @return A validation message
     */
    public String getMessage(){
	return message;
    }

    // Private data
    private String id;
    private String message;
}
