/*
 * Copyright 2011 SpringSource
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.codehaus.groovy.grails.plugins

import groovy.xml.dom.DOMCategory

/**
 * Enables async processing on all filters in the chain
 *
 * @author Graeme Rocher
 * @since 2.0
 */
class Servlet3AsyncWebXmlProcessor {
    void process(xml) {
        use(DOMCategory) {
            def filters = xml.'filter'

            for (filter in filters) {
                if (filter.'async-supported'.length == 0) {
                    filter.'filter-class' + {
                        'async-supported'(true)
                    }
                }
            }
        }
    }
}
