/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.AbstractMessageSource;
import io.micronaut.context.MessageSource;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.StringUtils;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public class StaticMessageSource
extends AbstractMessageSource {
    private final Map<AbstractMessageSource.MessageKey, String> messageMap = new ConcurrentHashMap<AbstractMessageSource.MessageKey, String>(40);

    @Nonnull
    public StaticMessageSource addMessage(@Nonnull String code, @Nonnull String message) {
        if (StringUtils.isNotEmpty((CharSequence)code) && StringUtils.isNotEmpty((CharSequence)message)) {
            this.messageMap.put(new AbstractMessageSource.MessageKey(Locale.getDefault(), code), message);
        }
        return this;
    }

    @Nonnull
    public StaticMessageSource addMessage(@Nonnull Locale locale, @Nonnull String code, @Nonnull String message) {
        ArgumentUtils.requireNonNull((String)"locale", (Object)locale);
        if (StringUtils.isNotEmpty((CharSequence)code) && StringUtils.isNotEmpty((CharSequence)message)) {
            this.messageMap.put(new AbstractMessageSource.MessageKey(locale, code), message);
        }
        return this;
    }

    @Override
    @Nonnull
    public Optional<String> getMessage(@Nonnull String code, @Nonnull MessageSource.MessageContext context) {
        ArgumentUtils.requireNonNull((String)"code", (Object)code);
        ArgumentUtils.requireNonNull((String)"context", (Object)context);
        String msg = this.messageMap.get(new AbstractMessageSource.MessageKey(context.getLocale(), code));
        if (msg != null) {
            return Optional.of(msg);
        }
        return Optional.ofNullable(this.messageMap.get(new AbstractMessageSource.MessageKey(Locale.getDefault(), code)));
    }
}

