/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.annotation;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.lang.Script;
import groovy.transform.Generated;
import groovy.transform.Internal;
import io.micronaut.ast.groovy.utils.AstGenericUtils;
import io.micronaut.ast.groovy.utils.AstMessageUtils;
import io.micronaut.ast.groovy.utils.ExtendedParameter;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.service.ServiceDefinition;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import io.micronaut.inject.annotation.AnnotatedElementValidator;
import io.micronaut.inject.visitor.VisitorContext;
import java.beans.Transient;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class GroovyAnnotationMetadataBuilder
extends AbstractAnnotationMetadataBuilder<AnnotatedNode, AnnotationNode>
implements GroovyObject {
    public static Map<String, Map<? extends AnnotatedNode, Expression>> ANNOTATION_DEFAULTS;
    public static final ClassNode ANN_OVERRIDE;
    public static final String VALIDATOR_KEY = "io.micronaut.VALIDATOR";
    private final SourceUnit sourceUnit;
    private final AnnotatedElementValidator elementValidator;
    private final CompilationUnit compilationUnit;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public GroovyAnnotationMetadataBuilder(SourceUnit sourceUnit, CompilationUnit compilationUnit) {
        SourceUnit sourceUnit2;
        CompilationUnit compilationUnit2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.compilationUnit = compilationUnit2 = compilationUnit;
        this.sourceUnit = sourceUnit2 = sourceUnit;
        SourceUnit sourceUnit3 = sourceUnit;
        ModuleNode ast = sourceUnit3 != null ? sourceUnit3.getAST() : null;
        if (ast != null) {
            Object validator = ast.getNodeMetaData((Object)VALIDATOR_KEY);
            if (validator instanceof AnnotatedElementValidator) {
                AnnotatedElementValidator annotatedElementValidator;
                this.elementValidator = annotatedElementValidator = (AnnotatedElementValidator)ScriptBytecodeAdapter.castToType((Object)validator, AnnotatedElementValidator.class);
            } else {
                AnnotatedElementValidator annotatedElementValidator;
                SoftServiceLoader validators = SoftServiceLoader.load(AnnotatedElementValidator.class);
                Iterator i = validators.iterator();
                AnnotatedElementValidator elementValidator = null;
                while (i.hasNext()) {
                    ServiceDefinition v = (ServiceDefinition)ScriptBytecodeAdapter.castToType(i.next(), ServiceDefinition.class);
                    if (!v.isPresent()) continue;
                    Object object = v.load();
                    elementValidator = (AnnotatedElementValidator)ScriptBytecodeAdapter.castToType((Object)object, AnnotatedElementValidator.class);
                    break;
                }
                this.elementValidator = annotatedElementValidator = elementValidator;
                ast.putNodeMetaData((Object)VALIDATOR_KEY, elementValidator);
            }
        } else {
            Object var16_16 = null;
            this.elementValidator = (AnnotatedElementValidator)ScriptBytecodeAdapter.castToType(var16_16, AnnotatedElementValidator.class);
        }
    }

    protected boolean isValidationRequired(AnnotatedNode member) {
        if (member != null) {
            List annotations = member.getAnnotations();
            if (DefaultTypeTransformation.booleanUnbox((Object)annotations)) {
                public final class _isValidationRequired_closure1
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _isValidationRequired_closure1(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ((AnnotationNode)it).getClassNode().getName().startsWith("javax.validation");
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _isValidationRequired_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return DefaultGroovyMethods.any((Iterable)annotations, (Closure)new _isValidationRequired_closure1((Object)this, (Object)this));
            }
        }
        return false;
    }

    protected AnnotatedNode getAnnotationMember(AnnotatedNode originatingElement, CharSequence member) {
        if (originatingElement instanceof ClassNode) {
            List methods = ((ClassNode)ScriptBytecodeAdapter.castToType((Object)originatingElement, ClassNode.class)).getMethods(member.toString());
            if (DefaultTypeTransformation.booleanUnbox((Object)methods)) {
                return (AnnotatedNode)ScriptBytecodeAdapter.castToType(methods.iterator().next(), AnnotatedNode.class);
            }
        }
        return (AnnotatedNode)ScriptBytecodeAdapter.castToType(null, AnnotatedNode.class);
    }

    protected RetentionPolicy getRetentionPolicy(@NonNull AnnotatedNode annotation) {
        List annotations = annotation.getAnnotations();
        Object ann2 = null;
        for (Object ann2 : annotations) {
            if (!ScriptBytecodeAdapter.compareEqual((Object)((AnnotationNode)ann2).getClassNode().getName(), (Object)Retention.class.getName())) continue;
            Iterator i = ((AnnotationNode)ann2).getMembers().values().iterator();
            if (!i.hasNext()) continue;
            Expression expr = (Expression)ScriptBytecodeAdapter.castToType(i.next(), Expression.class);
            if (!(expr instanceof PropertyExpression)) continue;
            PropertyExpression pe = (PropertyExpression)ScriptBytecodeAdapter.castToType((Object)expr, PropertyExpression.class);
            RetentionPolicy retentionPolicy = RetentionPolicy.valueOf(pe.getPropertyAsString());
            try {
                return retentionPolicy;
            }
            catch (Exception e) {
                RetentionPolicy retentionPolicy2 = RetentionPolicy.RUNTIME;
                return retentionPolicy2;
            }
        }
        return RetentionPolicy.RUNTIME;
    }

    protected AnnotatedElementValidator getElementValidator() {
        return this.elementValidator;
    }

    protected void addError(@NonNull AnnotatedNode originatingElement, @NonNull String error) {
        AstMessageUtils.error(this.sourceUnit, (ASTNode)originatingElement, error);
    }

    protected void addWarning(@NonNull AnnotatedNode originatingElement, @NonNull String warning) {
        AstMessageUtils.warning(this.sourceUnit, (ASTNode)originatingElement, warning);
    }

    protected boolean isMethodOrClassElement(AnnotatedNode element) {
        return element instanceof ClassNode || element instanceof MethodNode;
    }

    protected String getDeclaringType(@NonNull AnnotatedNode element) {
        if (element instanceof ClassNode) {
            return ((ClassNode)ScriptBytecodeAdapter.castToType((Object)element, ClassNode.class)).getName();
        }
        ClassNode classNode = element.getDeclaringClass();
        return classNode != null ? classNode.getName() : null;
    }

    protected boolean hasAnnotation(AnnotatedNode element, Class<? extends Annotation> annotation) {
        return !element.getAnnotations(ClassHelper.makeCached(annotation)).isEmpty();
    }

    protected boolean hasAnnotation(AnnotatedNode element, String annotation) {
        AnnotationNode ann = null;
        Iterator iterator = element.getAnnotations().iterator();
        while (iterator.hasNext()) {
            ann = (AnnotationNode)ScriptBytecodeAdapter.castToType(iterator.next(), AnnotationNode.class);
            if (!ScriptBytecodeAdapter.compareEqual((Object)ann.getClassNode().getName(), (Object)annotation)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasAnnotations(AnnotatedNode element) {
        return CollectionUtils.isNotEmpty((Collection)element.getAnnotations());
    }

    protected VisitorContext createVisitorContext() {
        return new GroovyVisitorContext(this.sourceUnit, this.compilationUnit);
    }

    protected AnnotatedNode getTypeForAnnotation(AnnotationNode annotationMirror) {
        return annotationMirror.getClassNode();
    }

    protected String getRepeatableName(AnnotationNode annotationMirror) {
        return this.getRepeatableNameForType((AnnotatedNode)annotationMirror.getClassNode());
    }

    protected String getRepeatableNameForType(AnnotatedNode annotationType) {
        List annotationNodes = annotationType.getAnnotations(ClassHelper.makeCached(Repeatable.class));
        if (DefaultTypeTransformation.booleanUnbox((Object)annotationNodes)) {
            Expression expression = ((AnnotationNode)annotationNodes.get(0)).getMember("value");
            if (expression instanceof ClassExpression) {
                return ((ClassExpression)ScriptBytecodeAdapter.castToType((Object)expression, ClassExpression.class)).getType().getName();
            }
        }
        return ShortTypeHandling.castToString(null);
    }

    protected Optional<AnnotatedNode> getAnnotationMirror(String annotationName) {
        Reference annotationName2 = new Reference((Object)annotationName);
        public final class _getAnnotationMirror_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getAnnotationMirror_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Class cls) {
                return ClassHelper.make((Class)cls);
            }

            public Object call(Class cls) {
                return this.doCall(cls);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAnnotationMirror_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public final class _getAnnotationMirror_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference annotationName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getAnnotationMirror_closure3(Object _outerInstance, Object _thisObject, Reference annotationName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.annotationName = reference = annotationName;
            }

            public Object doCall() {
                return ClassHelper.make((String)ShortTypeHandling.castToString((Object)this.annotationName.get()));
            }

            @Generated
            public String getAnnotationName() {
                return ShortTypeHandling.castToString((Object)this.annotationName.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAnnotationMirror_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ClassNode cn = (ClassNode)ScriptBytecodeAdapter.castToType(ClassUtils.forName((String)((String)annotationName2.get()), (ClassLoader)GroovyAnnotationMetadataBuilder.class.getClassLoader()).map((Function)ScriptBytecodeAdapter.castToType((Object)((Object)new _getAnnotationMirror_closure2((Object)this, (Object)this)), Function.class)).orElseGet((Supplier)ScriptBytecodeAdapter.castToType((Object)((Object)new _getAnnotationMirror_closure3((Object)this, (Object)this, annotationName2)), Supplier.class)), ClassNode.class);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)cn.getName(), (Object)ClassHelper.OBJECT)) {
            return Optional.of((AnnotatedNode)cn);
        }
        return Optional.empty();
    }

    protected String getAnnotationTypeName(AnnotationNode annotationMirror) {
        return annotationMirror.getClassNode().getName();
    }

    protected String getElementName(AnnotatedNode element) {
        if (element instanceof ClassNode) {
            return ((ClassNode)ScriptBytecodeAdapter.castToType((Object)element, ClassNode.class)).getName();
        }
        if (element instanceof MethodNode) {
            return ((MethodNode)ScriptBytecodeAdapter.castToType((Object)element, MethodNode.class)).getName();
        }
        if (element instanceof FieldNode) {
            return ((FieldNode)ScriptBytecodeAdapter.castToType((Object)element, FieldNode.class)).getName();
        }
        if (element instanceof PropertyNode) {
            return ((PropertyNode)ScriptBytecodeAdapter.castToType((Object)element, PropertyNode.class)).getName();
        }
        if (element instanceof PackageNode) {
            return ((PackageNode)ScriptBytecodeAdapter.castToType((Object)element, PackageNode.class)).getName();
        }
        throw (Throwable)new IllegalArgumentException(StringGroovyMethods.plus((String)"Cannot establish name for node type: ", (CharSequence)element.getClass().getName()));
    }

    protected List<? extends AnnotationNode> getAnnotationsForType(AnnotatedNode element) {
        List annotations = element.getAnnotations();
        ArrayList<AnnotationNode> expanded = new ArrayList<AnnotationNode>(annotations.size());
        AnnotationNode node = null;
        Iterator iterator = annotations.iterator();
        while (iterator.hasNext()) {
            node = (AnnotationNode)ScriptBytecodeAdapter.castToType(iterator.next(), AnnotationNode.class);
            Expression value = node.getMember("value");
            boolean repeatable = false;
            if (value != null && value instanceof ListExpression) {
                Expression expression = null;
                Iterator iterator2 = ((ListExpression)ScriptBytecodeAdapter.castToType((Object)value, ListExpression.class)).getExpressions().iterator();
                while (iterator2.hasNext()) {
                    boolean bl;
                    expression = (Expression)ScriptBytecodeAdapter.castToType(iterator2.next(), Expression.class);
                    if (!(expression instanceof AnnotationConstantExpression)) continue;
                    String name = this.getRepeatableNameForType((AnnotatedNode)expression.getType());
                    if (!(name != null && ScriptBytecodeAdapter.compareEqual((Object)name, (Object)node.getClassNode().getName()))) continue;
                    repeatable = bl = true;
                    expanded.add((AnnotationNode)ScriptBytecodeAdapter.castToType((Object)((ConstantExpression)ScriptBytecodeAdapter.castToType((Object)expression, ConstantExpression.class)).getValue(), AnnotationNode.class));
                }
            }
            if (!(!repeatable || node.getMembers().size() > 1)) continue;
            expanded.add(node);
        }
        return expanded;
    }

    protected List<AnnotatedNode> buildHierarchy(AnnotatedNode element, boolean inheritTypeAnnotations, boolean declaredOnly) {
        if (declaredOnly) {
            return Collections.singletonList(element);
        }
        if (element instanceof ClassNode) {
            ArrayList<AnnotatedNode> hierarchy = new ArrayList<AnnotatedNode>();
            ClassNode cn = (ClassNode)ScriptBytecodeAdapter.castToType((Object)element, ClassNode.class);
            hierarchy.add((AnnotatedNode)cn);
            this.populateTypeHierarchy(cn, hierarchy);
            return DefaultGroovyMethods.reverse(hierarchy);
        }
        if (element instanceof MethodNode) {
            List<AnnotatedNode> list;
            List<AnnotatedNode> list2;
            MethodNode mn = (MethodNode)ScriptBytecodeAdapter.castToType((Object)element, MethodNode.class);
            List<AnnotatedNode> hierarchy = null;
            hierarchy = inheritTypeAnnotations ? (list2 = this.buildHierarchy((AnnotatedNode)mn.getDeclaringClass(), false, declaredOnly)) : (list = ScriptBytecodeAdapter.createList((Object[])new Object[0]));
            if (!mn.getAnnotations(ANN_OVERRIDE).isEmpty()) {
                hierarchy.addAll(this.findOverriddenMethods(mn));
            }
            hierarchy.add((AnnotatedNode)mn);
            return hierarchy;
        }
        if (element instanceof ExtendedParameter) {
            ExtendedParameter p = (ExtendedParameter)((Object)ScriptBytecodeAdapter.castToType((Object)element, ExtendedParameter.class));
            List hierarchy = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            MethodNode methodNode = p.getMethodNode();
            if (!methodNode.getAnnotations(ANN_OVERRIDE).isEmpty()) {
                int variableIdx = Arrays.asList((Object[])ScriptBytecodeAdapter.castToType((Object)methodNode.getParameters(), Object[].class)).indexOf(p.getParameter());
                MethodNode overridden = null;
                Iterator<MethodNode> iterator = this.findOverriddenMethods(methodNode).iterator();
                while (iterator.hasNext()) {
                    overridden = (MethodNode)ScriptBytecodeAdapter.castToType((Object)iterator.next(), MethodNode.class);
                    hierarchy.add(new ExtendedParameter(overridden, (Parameter)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])overridden.getParameters(), (int)variableIdx), Parameter.class)));
                }
            }
            hierarchy.add(p);
            return hierarchy;
        }
        if (element == null) {
            return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        }
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{element});
    }

    protected void readAnnotationRawValues(AnnotatedNode originatingElement, String annotationName, AnnotatedNode member, String memberName, Object annotationValue, Map<CharSequence, Object> annotationValues) {
        if (!annotationValues.containsKey(memberName)) {
            Object v = this.readAnnotationValue(originatingElement, member, memberName, annotationValue);
            if (v != null) {
                this.validateAnnotationValue(originatingElement, annotationName, member, memberName, v);
                annotationValues.put(memberName, v);
            }
        }
    }

    protected Map<? extends AnnotatedNode, ?> readAnnotationDefaultValues(String annotationName, AnnotatedNode annotationType) {
        Map<String, Map<? extends AnnotatedNode, Expression>> defaults = ANNOTATION_DEFAULTS;
        if (annotationType instanceof ClassNode) {
            ClassNode classNode = (ClassNode)ScriptBytecodeAdapter.castToType((Object)annotationType, ClassNode.class);
            if (!defaults.containsKey(annotationName)) {
                ArrayList methods = new ArrayList(classNode.getMethods());
                LinkedHashMap<MethodNode, Object> defaultValues = new LinkedHashMap<MethodNode, Object>();
                if (classNode.isResolved()) {
                    Class resolved = classNode.getTypeClass();
                    MethodNode method = null;
                    Iterator iterator = methods.iterator();
                    while (iterator.hasNext()) {
                        method = (MethodNode)ScriptBytecodeAdapter.castToType(iterator.next(), MethodNode.class);
                        try {
                            Object defaultValue = resolved.getDeclaredMethod(method.getName(), new Class[0]).getDefaultValue();
                            if (!(defaultValue != null)) continue;
                            if (defaultValue instanceof Class) {
                                defaultValues.put(method, new ClassExpression(ClassHelper.makeCached((Class)ShortTypeHandling.castToClass((Object)defaultValue))));
                                continue;
                            }
                            if (defaultValue instanceof String) {
                                if (!StringUtils.isNotEmpty((CharSequence)ShortTypeHandling.castToString((Object)defaultValue))) continue;
                                defaultValues.put(method, new ConstantExpression(defaultValue));
                                continue;
                            }
                            defaultValues.put(method, new ConstantExpression(defaultValue));
                        }
                        catch (NoSuchMethodError e) {
                        }
                    }
                } else {
                    MethodNode method = null;
                    Iterator iterator = methods.iterator();
                    while (iterator.hasNext()) {
                        method = (MethodNode)ScriptBytecodeAdapter.castToType(iterator.next(), MethodNode.class);
                        Statement stmt = method.getCode();
                        Expression expression = null;
                        if (stmt instanceof ReturnStatement) {
                            Expression expression2;
                            expression = expression2 = ((ReturnStatement)ScriptBytecodeAdapter.castToType((Object)stmt, ReturnStatement.class)).getExpression();
                        } else if (stmt instanceof ExpressionStatement) {
                            Expression expression3;
                            expression = expression3 = ((ExpressionStatement)ScriptBytecodeAdapter.castToType((Object)stmt, ExpressionStatement.class)).getExpression();
                        }
                        if (!(expression instanceof ConstantExpression)) continue;
                        ConstantExpression ce = (ConstantExpression)ScriptBytecodeAdapter.castToType((Object)expression, ConstantExpression.class);
                        Object v = ce.getValue();
                        if (!(v != null)) continue;
                        if (v instanceof String) {
                            if (!StringUtils.isNotEmpty((CharSequence)ShortTypeHandling.castToString((Object)v))) continue;
                            defaultValues.put(method, new ConstantExpression(v));
                            continue;
                        }
                        defaultValues.put(method, (Expression)ScriptBytecodeAdapter.castToType((Object)expression, Expression.class));
                    }
                }
                defaults.put(annotationName, defaultValues);
            }
        }
        Map<? extends AnnotatedNode, Expression> map = defaults.get(annotationName);
        Map map2 = (Map)ScriptBytecodeAdapter.castToType(map, Map.class);
        return DefaultTypeTransformation.booleanUnbox(map) ? map2 : Collections.emptyMap();
    }

    protected boolean isInheritedAnnotation(@NonNull AnnotationNode annotationMirror) {
        AnnotationNode annotationNode = annotationMirror;
        ClassNode classNode = annotationNode != null ? annotationNode.getClassNode() : null;
        List list = classNode != null ? classNode.getAnnotations() : null;
        public final class _isInheritedAnnotation_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isInheritedAnnotation_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                Object object = it;
                ClassNode classNode = object != null ? ((AnnotationNode)object).getClassNode() : null;
                return ScriptBytecodeAdapter.compareEqual((Object)(classNode != null ? classNode.getName() : null), (Object)Inherited.class.getName());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isInheritedAnnotation_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultTypeTransformation.booleanUnbox(list != null ? Boolean.valueOf(DefaultGroovyMethods.any((Iterable)list, (Closure)new _isInheritedAnnotation_closure4((Object)this, (Object)this))) : null);
    }

    protected boolean isInheritedAnnotationType(@NonNull AnnotatedNode annotationType) {
        AnnotatedNode annotatedNode = annotationType;
        List list = annotatedNode != null ? annotatedNode.getAnnotations() : null;
        public final class _isInheritedAnnotationType_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isInheritedAnnotationType_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                Object object = it;
                ClassNode classNode = object != null ? ((AnnotationNode)object).getClassNode() : null;
                return ScriptBytecodeAdapter.compareEqual((Object)(classNode != null ? classNode.getName() : null), (Object)Inherited.class.getName());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isInheritedAnnotationType_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultTypeTransformation.booleanUnbox(list != null ? Boolean.valueOf(DefaultGroovyMethods.any((Iterable)list, (Closure)new _isInheritedAnnotationType_closure5((Object)this, (Object)this))) : null);
    }

    protected Map<? extends AnnotatedNode, ?> readAnnotationDefaultValues(AnnotationNode annotationMirror) {
        ClassNode classNode = annotationMirror.getClassNode();
        String annotationName = classNode.getName();
        return this.readAnnotationDefaultValues(annotationName, (AnnotatedNode)classNode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object readAnnotationValue(AnnotatedNode originatingElement, AnnotatedNode member, String memberName, Object annotationValue) {
        if (annotationValue instanceof ConstantExpression) {
            if (!(annotationValue instanceof AnnotationConstantExpression)) return ((ConstantExpression)ScriptBytecodeAdapter.castToType((Object)annotationValue, ConstantExpression.class)).getValue();
            AnnotationConstantExpression ann = (AnnotationConstantExpression)ScriptBytecodeAdapter.castToType((Object)annotationValue, AnnotationConstantExpression.class);
            AnnotationNode value = (AnnotationNode)ScriptBytecodeAdapter.castToType((Object)ann.getValue(), AnnotationNode.class);
            if (!(member instanceof MethodNode && ((MethodNode)ScriptBytecodeAdapter.castToType((Object)member, MethodNode.class)).getReturnType().isArray())) return this.readNestedAnnotationValue(originatingElement, value);
            return new AnnotationValue[]{this.readNestedAnnotationValue(originatingElement, value)};
        }
        if (annotationValue instanceof PropertyExpression) {
            PropertyExpression pe = (PropertyExpression)ScriptBytecodeAdapter.castToType((Object)annotationValue, PropertyExpression.class);
            if (!(pe.getObjectExpression() instanceof ClassExpression)) return null;
            ClassExpression ce = (ClassExpression)ScriptBytecodeAdapter.castToType((Object)pe.getObjectExpression(), ClassExpression.class);
            ClassNode propertyType = ce.getType();
            if (propertyType.isEnum()) {
                return pe.getPropertyAsString();
            }
            if (!propertyType.isResolved()) return null;
            Class typeClass = propertyType.getTypeClass();
            Object value = DefaultGroovyMethods.getAt((Object)typeClass, (String)pe.getPropertyAsString());
            if (value == null) return null;
            boolean bl = true;
            if (!bl) return null;
            Object object = value;
            try {
                return object;
            }
            catch (Exception e) {
                return null;
            }
        } else {
            if (annotationValue instanceof ClassExpression) {
                return new AnnotationClassValue(((ClassExpression)ScriptBytecodeAdapter.castToType((Object)annotationValue, ClassExpression.class)).getType().getName());
            }
            if (annotationValue instanceof ListExpression) {
                ListExpression le = (ListExpression)ScriptBytecodeAdapter.castToType((Object)annotationValue, ListExpression.class);
                List converted = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                Class arrayType = Object.class;
                Object exp = null;
                Iterator iterator = le.getExpressions().iterator();
                while (iterator.hasNext()) {
                    String string;
                    String string2;
                    exp = iterator.next();
                    if (exp instanceof PropertyExpression) {
                        PropertyExpression propertyExpression = (PropertyExpression)ScriptBytecodeAdapter.castToType(exp, PropertyExpression.class);
                        Expression valueExpression = propertyExpression.getProperty();
                        Expression objectExpression = propertyExpression.getObjectExpression();
                        if (valueExpression instanceof ConstantExpression && objectExpression instanceof ClassExpression) {
                            Object value = ((ConstantExpression)ScriptBytecodeAdapter.castToType((Object)valueExpression, ConstantExpression.class)).getValue();
                            if (value != null) {
                                if (value instanceof CharSequence) {
                                    String string3 = DefaultGroovyMethods.toString((Object)value);
                                    value = string3;
                                }
                                ClassNode enumType = ((ClassExpression)ScriptBytecodeAdapter.castToType((Object)objectExpression, ClassExpression.class)).getType();
                                if (enumType.isResolved()) {
                                    Class clazz;
                                    arrayType = clazz = enumType.getTypeClass();
                                } else {
                                    Class<String> clazz = String.class;
                                    arrayType = clazz;
                                }
                                converted.add(value);
                            }
                        }
                    }
                    if (exp instanceof AnnotationConstantExpression) {
                        Class<AnnotationValue> clazz = AnnotationValue.class;
                        arrayType = clazz;
                        AnnotationConstantExpression ann = (AnnotationConstantExpression)ScriptBytecodeAdapter.castToType(exp, AnnotationConstantExpression.class);
                        AnnotationNode value = (AnnotationNode)ScriptBytecodeAdapter.castToType((Object)ann.getValue(), AnnotationNode.class);
                        converted.add(this.readNestedAnnotationValue(originatingElement, value));
                        continue;
                    }
                    if (exp instanceof ConstantExpression) {
                        Object value = ((ConstantExpression)ScriptBytecodeAdapter.castToType(exp, ConstantExpression.class)).getValue();
                        if (!(value != null)) continue;
                        if (value instanceof CharSequence) {
                            String string4 = DefaultGroovyMethods.toString((Object)value);
                            value = string4;
                        }
                        Class<?> clazz = value.getClass();
                        arrayType = clazz;
                        converted.add(value);
                        continue;
                    }
                    if (!(exp instanceof ClassExpression)) continue;
                    Class<AnnotationClassValue> clazz = AnnotationClassValue.class;
                    arrayType = clazz;
                    ClassExpression classExp = (ClassExpression)ScriptBytecodeAdapter.castToType(exp, ClassExpression.class);
                    String typeName = null;
                    typeName = classExp.getType().isArray() ? (string2 = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"[L", (CharSequence)classExp.getType().getComponentType().getName()), (CharSequence)";")) : (string = classExp.getType().getName());
                    converted.add(new AnnotationClassValue(typeName));
                }
                return ConversionService.SHARED.convert((Object)converted, Array.newInstance(arrayType, 0).getClass()).orElse(null);
            }
            if (annotationValue instanceof VariableExpression) {
                VariableExpression ve = (VariableExpression)ScriptBytecodeAdapter.castToType((Object)annotationValue, VariableExpression.class);
                Variable variable = ve.getAccessedVariable();
                if (variable == null) return null;
                boolean bl = true;
                if (!bl) return null;
                if (!variable.hasInitialExpression()) return null;
                boolean bl2 = true;
                if (!bl2) return null;
                return this.readAnnotationValue(originatingElement, member, memberName, (Object)variable.getInitialExpression());
            }
            if (annotationValue == null) return null;
            boolean bl = true;
            if (!bl) return null;
            if (!ClassUtils.isJavaLangType(annotationValue.getClass())) return null;
            return annotationValue;
        }
    }

    protected Map<? extends AnnotatedNode, ?> readAnnotationRawValues(AnnotationNode annotationMirror) {
        Map members = annotationMirror.getMembers();
        LinkedHashMap values = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
        ClassNode annotationClassNode = annotationMirror.getClassNode();
        Object m = null;
        Iterator iterator = DefaultGroovyMethods.iterator((Object)members);
        while (iterator.hasNext()) {
            m = iterator.next();
            values.put(DefaultGroovyMethods.getAt((List)annotationClassNode.getMethods(ShortTypeHandling.castToString(((Map.Entry)m).getKey())), (int)0), ((Map.Entry)m).getValue());
        }
        return values;
    }

    protected OptionalValues<?> getAnnotationValues(AnnotatedNode originatingElement, AnnotatedNode member, Class<?> annotationType) {
        if (member != null) {
            List anns = member.getAnnotations(ClassHelper.make(annotationType));
            if (!anns.isEmpty()) {
                AnnotationNode ann = (AnnotationNode)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((List)anns, (int)0), AnnotationNode.class);
                LinkedHashMap<CharSequence, Object> converted = new LinkedHashMap<CharSequence, Object>();
                Object annMember = null;
                Iterator iterator = DefaultGroovyMethods.iterator((Object)ann.getMembers());
                while (iterator.hasNext()) {
                    annMember = iterator.next();
                    this.readAnnotationRawValues(originatingElement, annotationType.getName(), member, ShortTypeHandling.castToString(((Map.Entry)annMember).getKey()), ((Map.Entry)annMember).getValue(), converted);
                }
                return OptionalValues.of(Object.class, converted);
            }
        }
        return OptionalValues.empty();
    }

    protected String getAnnotationMemberName(AnnotatedNode member) {
        return ((MethodNode)ScriptBytecodeAdapter.castToType((Object)member, MethodNode.class)).getName();
    }

    private void populateTypeHierarchy(ClassNode classNode, List<AnnotatedNode> hierarchy) {
        while (classNode != null) {
            ClassNode classNode2;
            ClassNode[] interfaces = classNode.getInterfaces();
            ClassNode anInterface2 = null;
            ClassNode[] classNodeArray = interfaces;
            if (interfaces != null) {
                for (ClassNode anInterface2 : classNodeArray) {
                    if (!(!hierarchy.contains(anInterface2) && ScriptBytecodeAdapter.compareNotEqual((Object)anInterface2.getName(), (Object)GroovyObject.class.getName()))) continue;
                    hierarchy.add((AnnotatedNode)anInterface2);
                    this.populateTypeHierarchy(anInterface2, hierarchy);
                }
            }
            classNode = classNode2 = classNode.getSuperClass();
            if (!(classNode != null) || ScriptBytecodeAdapter.compareEqual((Object)classNode, (Object)ClassHelper.OBJECT_TYPE) || ScriptBytecodeAdapter.compareEqual((Object)classNode.getName(), (Object)Script.class.getName()) || ScriptBytecodeAdapter.compareEqual((Object)classNode.getName(), (Object)GroovyObjectSupport.class.getName())) break;
            hierarchy.add((AnnotatedNode)classNode);
        }
    }

    private List<MethodNode> findOverriddenMethods(MethodNode methodNode) {
        List overriddenMethods = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        ClassNode classNode = methodNode.getDeclaringClass();
        String methodName = methodNode.getName();
        Map<String, Map<String, ClassNode>> genericsInfo = AstGenericUtils.buildAllGenericElementInfo(classNode, this.createVisitorContext());
        block0: while (classNode != null && ScriptBytecodeAdapter.compareNotEqual((Object)classNode.getName(), (Object)Object.class.getName())) {
            ClassNode classNode2;
            Object i2 = null;
            for (Object i2 : classNode.getAllInterfaces()) {
                MethodNode parent = null;
                Iterator iterator = ((ClassNode)i2).getMethods(methodName).iterator();
                while (iterator.hasNext()) {
                    parent = (MethodNode)ScriptBytecodeAdapter.castToType(iterator.next(), MethodNode.class);
                    if (!this.methodOverrides(methodNode, parent, (Map)ScriptBytecodeAdapter.castToType(genericsInfo.get(((ClassNode)i2).getName()), Map.class))) continue;
                    overriddenMethods.add(parent);
                }
            }
            classNode = classNode2 = classNode.getSuperClass();
            if (!(classNode != null && ScriptBytecodeAdapter.compareNotEqual((Object)classNode.getName(), (Object)Object.class.getName()))) continue;
            MethodNode parent = null;
            Iterator iterator = classNode.getMethods(methodName).iterator();
            while (iterator.hasNext()) {
                parent = (MethodNode)ScriptBytecodeAdapter.castToType(iterator.next(), MethodNode.class);
                if (!this.methodOverrides(methodNode, parent, (Map)ScriptBytecodeAdapter.castToType(genericsInfo.get(classNode.getName()), Map.class))) continue;
                if (!parent.isPrivate()) {
                    overriddenMethods.add(parent);
                }
                if (!parent.getAnnotations(ANN_OVERRIDE).isEmpty()) continue;
                break block0;
            }
        }
        return overriddenMethods;
    }

    private boolean methodOverrides(MethodNode child, MethodNode parent, Map<String, ClassNode> genericsSpec) {
        Object[] childParameters = child.getParameters();
        Object[] parentParameters = parent.getParameters();
        if (childParameters.length == parentParameters.length) {
            int i = 0;
            int n = childParameters.length;
            while (i < n) {
                ClassNode aType = ((Parameter)BytecodeInterface8.objectArrayGet((Object[])childParameters, (int)i)).getType();
                ClassNode bType = ((Parameter)BytecodeInterface8.objectArrayGet((Object[])parentParameters, (int)i)).getType();
                if (ScriptBytecodeAdapter.compareNotEqual((Object)aType, (Object)bType)) {
                    if (bType.isGenericsPlaceHolder() && genericsSpec != null) {
                        ClassNode classNode = (ClassNode)ScriptBytecodeAdapter.castToType((Object)genericsSpec.get(bType.getUnresolvedName()), ClassNode.class);
                        if (!DefaultTypeTransformation.booleanUnbox((Object)classNode) || ScriptBytecodeAdapter.compareNotEqual((Object)aType, (Object)classNode)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                int cfr_ignored_0 = i + 1;
            }
            return true;
        }
        return false;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != GroovyAnnotationMetadataBuilder.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        ClassNode classNode;
        LinkedHashMap<String, Map<? extends AnnotatedNode, Expression>> linkedHashMap = new LinkedHashMap<String, Map<? extends AnnotatedNode, Expression>>();
        ANNOTATION_DEFAULTS = linkedHashMap;
        ANN_OVERRIDE = classNode = ClassHelper.make(Override.class);
    }

    @Generated
    public final SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    @Generated
    public final CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }
}

