/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop.writer;

import io.micronaut.aop.HotSwappableInterceptedProxy;
import io.micronaut.aop.Intercepted;
import io.micronaut.aop.InterceptedProxy;
import io.micronaut.aop.Interceptor;
import io.micronaut.aop.Introduced;
import io.micronaut.aop.chain.InterceptorChain;
import io.micronaut.aop.chain.MethodInterceptorChain;
import io.micronaut.asm.ClassVisitor;
import io.micronaut.asm.ClassWriter;
import io.micronaut.asm.Label;
import io.micronaut.asm.MethodVisitor;
import io.micronaut.asm.Type;
import io.micronaut.asm.commons.GeneratorAdapter;
import io.micronaut.asm.commons.Method;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.Toggleable;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.ProxyBeanDefinition;
import io.micronaut.inject.annotation.AnnotationMetadataReference;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.configuration.ConfigurationMetadata;
import io.micronaut.inject.configuration.ConfigurationMetadataBuilder;
import io.micronaut.inject.processing.JavaModelUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.AbstractClassFileWriter;
import io.micronaut.inject.writer.BeanDefinitionWriter;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.inject.writer.ExecutableMethodsDefinitionWriter;
import io.micronaut.inject.writer.OriginatingElements;
import io.micronaut.inject.writer.ProxyingBeanDefinitionVisitor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;

public class AopProxyWriter
extends AbstractClassFileWriter
implements ProxyingBeanDefinitionVisitor,
Toggleable {
    public static final int MAX_LOCALS = 3;
    public static final Method METHOD_GET_PROXY_TARGET = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(ExecutionHandleLocator.class, (String)"getProxyTargetMethod", (Class[])new Class[]{Argument.class, Qualifier.class, String.class, Class[].class}));
    public static final Method METHOD_GET_PROXY_TARGET_BEAN_WITH_CONTEXT = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(DefaultBeanContext.class, (String)"getProxyTargetBean", (Class[])new Class[]{BeanResolutionContext.class, Argument.class, Qualifier.class}));
    public static final Method METHOD_GET_PROXY_TARGET_BEAN = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(BeanLocator.class, (String)"getProxyTargetBean", (Class[])new Class[]{Argument.class, Qualifier.class}));
    public static final Type FIELD_TYPE_INTERCEPTORS = Type.getType(Interceptor[][].class);
    public static final Type TYPE_INTERCEPTOR_CHAIN = Type.getType(InterceptorChain.class);
    public static final Type TYPE_METHOD_INTERCEPTOR_CHAIN = Type.getType(MethodInterceptorChain.class);
    public static final String FIELD_TARGET = "$target";
    public static final String FIELD_BEAN_RESOLUTION_CONTEXT = "$beanResolutionContext";
    public static final String FIELD_READ_WRITE_LOCK = "$target_rwl";
    public static final Type TYPE_READ_WRITE_LOCK = Type.getType(ReentrantReadWriteLock.class);
    public static final String FIELD_READ_LOCK = "$target_rl";
    public static final String FIELD_WRITE_LOCK = "$target_wl";
    public static final Type TYPE_LOCK = Type.getType(Lock.class);
    public static final Type TYPE_BEAN_LOCATOR = Type.getType(BeanLocator.class);
    public static final Type TYPE_DEFAULT_BEAN_CONTEXT = Type.getType(DefaultBeanContext.class);
    private static final Method METHOD_PROXY_TARGET_TYPE = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(ProxyBeanDefinition.class, (String)"getTargetDefinitionType", (Class[])new Class[0]));
    private static final Method METHOD_PROXY_TARGET_CLASS = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(ProxyBeanDefinition.class, (String)"getTargetType", (Class[])new Class[0]));
    private static final java.lang.reflect.Method RESOLVE_INTRODUCTION_INTERCEPTORS_METHOD = ReflectionUtils.getRequiredInternalMethod(InterceptorChain.class, (String)"resolveIntroductionInterceptors", (Class[])new Class[]{BeanContext.class, ExecutableMethod.class, List.class});
    private static final java.lang.reflect.Method RESOLVE_AROUND_INTERCEPTORS_METHOD = ReflectionUtils.getRequiredInternalMethod(InterceptorChain.class, (String)"resolveAroundInterceptors", (Class[])new Class[]{BeanContext.class, ExecutableMethod.class, List.class});
    private static final Constructor CONSTRUCTOR_METHOD_INTERCEPTOR_CHAIN = (Constructor)ReflectionUtils.findConstructor(MethodInterceptorChain.class, (Class[])new Class[]{Interceptor[].class, Object.class, ExecutableMethod.class, Object[].class}).orElseThrow(() -> new IllegalStateException("new MethodInterceptorChain(..) constructor not found. Incompatible version of Micronaut?"));
    private static final Constructor CONSTRUCTOR_METHOD_INTERCEPTOR_CHAIN_NO_PARAMS = (Constructor)ReflectionUtils.findConstructor(MethodInterceptorChain.class, (Class[])new Class[]{Interceptor[].class, Object.class, ExecutableMethod.class}).orElseThrow(() -> new IllegalStateException("new MethodInterceptorChain(..) constructor not found. Incompatible version of Micronaut?"));
    private static final String FIELD_INTERCEPTORS = "$interceptors";
    private static final String FIELD_BEAN_LOCATOR = "$beanLocator";
    private static final String FIELD_BEAN_QUALIFIER = "$beanQualifier";
    private static final String FIELD_PROXY_METHODS = "$proxyMethods";
    private static final Type FIELD_TYPE_PROXY_METHODS = Type.getType(ExecutableMethod[].class);
    private static final Type EXECUTABLE_METHOD_TYPE = Type.getType(ExecutableMethod.class);
    private static final Type INTERCEPTOR_ARRAY_TYPE = Type.getType(Interceptor[].class);
    private final String packageName;
    private final String targetClassShortName;
    private final ClassWriter classWriter;
    private final String targetClassFullName;
    private final String proxyFullName;
    private final BeanDefinitionWriter proxyBeanDefinitionWriter;
    private final String proxyInternalName;
    private final Set<AnnotationValue<?>> interceptorBinding;
    private final Set<ClassElement> interfaceTypes;
    private final Type proxyType;
    private final boolean hotswap;
    private final boolean lazy;
    private final boolean cacheLazyTarget;
    private final boolean isInterface;
    private final BeanDefinitionWriter parentWriter;
    private final boolean isIntroduction;
    private final boolean implementInterface;
    private boolean isProxyTarget;
    private MethodVisitor constructorWriter;
    private final List<MethodRef> proxiedMethods = new ArrayList<MethodRef>();
    private final Set<MethodRef> proxiedMethodsRefSet = new HashSet<MethodRef>();
    private final List<MethodRef> proxyTargetMethods = new ArrayList<MethodRef>();
    private int proxyMethodCount = 0;
    private GeneratorAdapter constructorGenerator;
    private int interceptorArgumentIndex;
    private int beanResolutionContextArgumentIndex = -1;
    private int beanContextArgumentIndex = -1;
    private int qualifierIndex;
    private final List<Runnable> deferredInjectionPoints = new ArrayList<Runnable>();
    private boolean constructorRequiresReflection;
    private MethodElement declaredConstructor;
    private MethodElement newConstructor;
    private ParameterElement interceptorParameter;
    private ParameterElement qualifierParameter;
    private VisitorContext visitorContext;

    public AopProxyWriter(BeanDefinitionWriter parent, OptionalValues<Boolean> settings, ConfigurationMetadataBuilder<?> metadataBuilder, VisitorContext visitorContext, AnnotationValue<?> ... interceptorBinding) {
        super(parent.getOriginatingElements());
        this.isIntroduction = false;
        this.implementInterface = true;
        this.parentWriter = parent;
        this.isProxyTarget = settings.get(Interceptor.PROXY_TARGET).orElse(false) != false || parent.isInterface();
        this.hotswap = this.isProxyTarget && settings.get(Interceptor.HOTSWAP).orElse(false) != false;
        this.lazy = this.isProxyTarget && settings.get(Interceptor.LAZY).orElse(false) != false;
        this.cacheLazyTarget = this.lazy && settings.get(Interceptor.CACHEABLE_LAZY_TARGET).orElse(false) != false;
        this.isInterface = parent.isInterface();
        this.packageName = parent.getPackageName();
        this.targetClassShortName = parent.getBeanSimpleName();
        this.targetClassFullName = this.packageName + '.' + this.targetClassShortName;
        this.classWriter = new ClassWriter(3);
        this.proxyFullName = parent.getBeanDefinitionName() + "$Intercepted";
        this.proxyInternalName = AopProxyWriter.getInternalName((String)this.proxyFullName);
        this.proxyType = AopProxyWriter.getTypeReferenceForName((String)this.proxyFullName, (String[])new String[0]);
        this.interceptorBinding = this.toInterceptorBindingMap(interceptorBinding);
        this.interfaceTypes = Collections.emptySet();
        ClassElement aopElement = ClassElement.of((String)this.proxyFullName, (boolean)this.isInterface, (AnnotationMetadata)parent.getAnnotationMetadata());
        this.proxyBeanDefinitionWriter = new BeanDefinitionWriter(aopElement, (OriginatingElements)parent, metadataBuilder, visitorContext);
        this.startClass((ClassVisitor)this.classWriter, AopProxyWriter.getInternalName((String)this.proxyFullName), AopProxyWriter.getTypeReferenceForName((String)this.targetClassFullName, (String[])new String[0]));
        this.proxyBeanDefinitionWriter.setInterceptedType(this.targetClassFullName);
    }

    public AopProxyWriter(String packageName, String className, boolean isInterface, Element originatingElement, AnnotationMetadata annotationMetadata, ClassElement[] interfaceTypes, VisitorContext visitorContext, ConfigurationMetadataBuilder<?> metadataBuilder, ConfigurationMetadata configurationMetadata, AnnotationValue<?> ... interceptorBinding) {
        this(packageName, className, isInterface, true, originatingElement, annotationMetadata, interfaceTypes, visitorContext, metadataBuilder, configurationMetadata, interceptorBinding);
    }

    public AopProxyWriter(String packageName, String className, boolean isInterface, boolean implementInterface, Element originatingElement, AnnotationMetadata annotationMetadata, ClassElement[] interfaceTypes, VisitorContext visitorContext, ConfigurationMetadataBuilder<?> metadataBuilder, ConfigurationMetadata configurationMetadata, AnnotationValue<?> ... interceptorBinding) {
        super(OriginatingElements.of((Element[])new Element[]{originatingElement}));
        this.isIntroduction = true;
        this.implementInterface = implementInterface;
        if (!implementInterface && ArrayUtils.isEmpty((Object[])interfaceTypes)) {
            throw new IllegalArgumentException("if argument implementInterface is false at least one interface should be provided to the 'interfaceTypes' argument");
        }
        this.packageName = packageName;
        this.isInterface = isInterface;
        this.hotswap = false;
        this.lazy = false;
        this.cacheLazyTarget = false;
        this.targetClassShortName = className;
        this.targetClassFullName = packageName + '.' + this.targetClassShortName;
        this.parentWriter = null;
        this.proxyFullName = this.targetClassFullName + "$Intercepted";
        this.proxyInternalName = AopProxyWriter.getInternalName((String)this.proxyFullName);
        this.proxyType = AopProxyWriter.getTypeReferenceForName((String)this.proxyFullName, (String[])new String[0]);
        this.interceptorBinding = this.toInterceptorBindingMap(interceptorBinding);
        this.interfaceTypes = interfaceTypes != null ? new LinkedHashSet<ClassElement>(Arrays.asList(interfaceTypes)) : Collections.emptySet();
        this.classWriter = new ClassWriter(3);
        if (configurationMetadata != null) {
            String existingPrefix = annotationMetadata.stringValue(ConfigurationReader.class, "prefix").orElse("");
            String computedPrefix = StringUtils.isNotEmpty((CharSequence)existingPrefix) ? existingPrefix + "." + configurationMetadata.getName() : configurationMetadata.getName();
            annotationMetadata = DefaultAnnotationMetadata.mutateMember((AnnotationMetadata)annotationMetadata, (String)ConfigurationReader.class.getName(), (String)"prefix", (Object)computedPrefix);
        }
        ClassElement aopElement = ClassElement.of((String)this.proxyFullName, (boolean)isInterface, (AnnotationMetadata)annotationMetadata);
        this.proxyBeanDefinitionWriter = new BeanDefinitionWriter(aopElement, (OriginatingElements)this, metadataBuilder, visitorContext);
        if (isInterface) {
            if (implementInterface) {
                this.proxyBeanDefinitionWriter.setInterceptedType(this.targetClassFullName);
            }
        } else {
            this.proxyBeanDefinitionWriter.setInterceptedType(this.targetClassFullName);
        }
        this.startClass((ClassVisitor)this.classWriter, this.proxyInternalName, AopProxyWriter.getTypeReferenceForName((String)this.targetClassFullName, (String[])new String[0]));
    }

    public boolean isEnabled() {
        return this.proxyBeanDefinitionWriter.isEnabled();
    }

    public boolean isProxyTarget() {
        return this.isProxyTarget;
    }

    protected void startClass(ClassVisitor classWriter, String className, Type superType) {
        String[] interfaces = this.getImplementedInterfaceInternalNames();
        classWriter.visit(52, 4096, className, null, !this.isInterface ? superType.getInternalName() : null, interfaces);
        classWriter.visitAnnotation(TYPE_GENERATED.getDescriptor(), false);
        classWriter.visitField(18, FIELD_INTERCEPTORS, FIELD_TYPE_INTERCEPTORS.getDescriptor(), null, null);
        classWriter.visitField(18, FIELD_PROXY_METHODS, FIELD_TYPE_PROXY_METHODS.getDescriptor(), null, null);
    }

    private String[] getImplementedInterfaceInternalNames() {
        return (String[])this.interfaceTypes.stream().map(o -> JavaModelUtils.getTypeReference((TypedElement)o).getInternalName()).toArray(String[]::new);
    }

    @Deprecated
    public Element getOriginatingElement() {
        return this.proxyBeanDefinitionWriter.getOriginatingElement();
    }

    public boolean isSingleton() {
        return this.proxyBeanDefinitionWriter.isSingleton();
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public void visitBeanDefinitionInterface(Class<? extends BeanDefinition> interfaceType) {
        this.proxyBeanDefinitionWriter.visitBeanDefinitionInterface(interfaceType);
    }

    public String getBeanTypeName() {
        return this.proxyBeanDefinitionWriter.getBeanTypeName();
    }

    public Type getProvidedType() {
        return this.proxyBeanDefinitionWriter.getProvidedType();
    }

    public void setValidated(boolean validated) {
        this.proxyBeanDefinitionWriter.setValidated(validated);
    }

    public void setInterceptedType(String typeName) {
        this.proxyBeanDefinitionWriter.setInterceptedType(typeName);
    }

    public Optional<Type> getInterceptedType() {
        return this.proxyBeanDefinitionWriter.getInterceptedType();
    }

    public boolean isValidated() {
        return this.proxyBeanDefinitionWriter.isValidated();
    }

    public String getBeanDefinitionName() {
        return this.proxyBeanDefinitionWriter.getBeanDefinitionName();
    }

    public void visitBeanDefinitionConstructor(MethodElement constructor, boolean requiresReflection, VisitorContext visitorContext) {
        this.constructorRequiresReflection = requiresReflection;
        this.declaredConstructor = constructor;
        this.visitorContext = visitorContext;
    }

    public void visitDefaultConstructor(AnnotationMetadata annotationMetadata, VisitorContext visitorContext) {
        this.constructorRequiresReflection = false;
        ClassElement classElement = ClassElement.of((String)this.proxyType.getClassName());
        this.declaredConstructor = MethodElement.of((ClassElement)classElement, (AnnotationMetadata)annotationMetadata, (ClassElement)classElement, (ClassElement)classElement, (String)"<init>", (ParameterElement[])new ParameterElement[0]);
    }

    private void initConstructor(MethodElement constructor) {
        ClassElement interceptorList = ClassElement.of(List.class, (AnnotationMetadata)AnnotationMetadata.EMPTY_METADATA, Collections.singletonMap("E", ClassElement.of(BeanRegistration.class, (AnnotationMetadata)AnnotationMetadata.EMPTY_METADATA, Collections.singletonMap("T", ClassElement.of(Interceptor.class)))));
        this.interceptorParameter = ParameterElement.of((ClassElement)interceptorList, (String)FIELD_INTERCEPTORS);
        this.qualifierParameter = ParameterElement.of(Qualifier.class, (String)"$qualifier");
        ClassElement proxyClass = ClassElement.of((String)this.proxyType.getClassName());
        ParameterElement[] constructorParameters = constructor.getParameters();
        ArrayList<ParameterElement> newConstructorParameters = new ArrayList<ParameterElement>(constructorParameters.length + 4);
        newConstructorParameters.addAll(Arrays.asList(constructorParameters));
        newConstructorParameters.add(ParameterElement.of(BeanResolutionContext.class, (String)FIELD_BEAN_RESOLUTION_CONTEXT));
        newConstructorParameters.add(ParameterElement.of(BeanContext.class, (String)"$beanContext"));
        newConstructorParameters.add(this.qualifierParameter);
        newConstructorParameters.add(this.interceptorParameter);
        this.newConstructor = MethodElement.of((ClassElement)proxyClass, (AnnotationMetadata)constructor.getAnnotationMetadata(), (ClassElement)proxyClass, (ClassElement)proxyClass, (String)"<init>", (ParameterElement[])newConstructorParameters.toArray(new ParameterElement[0]));
        this.beanResolutionContextArgumentIndex = constructorParameters.length;
        this.beanContextArgumentIndex = constructorParameters.length + 1;
        this.qualifierIndex = constructorParameters.length + 2;
        this.interceptorArgumentIndex = constructorParameters.length + 3;
    }

    @NonNull
    public String getBeanDefinitionReferenceClassName() {
        return this.proxyBeanDefinitionWriter.getBeanDefinitionReferenceClassName();
    }

    public void visitIntroductionMethod(TypedElement declaringBean, MethodElement methodElement) {
        this.visitAroundMethod(declaringBean, methodElement);
    }

    public void visitAroundMethod(TypedElement beanType, MethodElement methodElement) {
        ClassElement returnType = methodElement.isSuspend() ? ClassElement.of(Object.class) : methodElement.getReturnType();
        Type returnTypeObject = JavaModelUtils.getTypeReference((TypedElement)returnType);
        boolean isPrimitive = returnType.isPrimitive();
        boolean isVoidReturn = isPrimitive && returnTypeObject.equals((Object)Type.VOID_TYPE);
        Optional overridden = methodElement.getOwningType().getEnclosedElement(ElementQuery.ALL_METHODS.onlyInstance().named(name -> name.equals(methodElement.getName())).filter(el -> el.overrides(methodElement)));
        if (overridden.isPresent()) {
            String overriddenByKey;
            MethodElement overriddenBy = (MethodElement)overridden.get();
            String methodElementKey = methodElement.getName() + Arrays.stream(methodElement.getSuspendParameters()).map(p -> p.getType().getName()).collect(Collectors.joining(","));
            if (!methodElementKey.equals(overriddenByKey = overriddenBy.getName() + Arrays.stream(methodElement.getSuspendParameters()).map(p -> p.getGenericType().getName()).collect(Collectors.joining(",")))) {
                this.buildMethodDelegate(methodElement, overriddenBy, isVoidReturn);
                return;
            }
        }
        String methodName = methodElement.getName();
        List<ParameterElement> argumentTypeList = Arrays.asList(methodElement.getSuspendParameters());
        int argumentCount = argumentTypeList.size();
        Type declaringTypeReference = JavaModelUtils.getTypeReference((TypedElement)beanType);
        MethodRef methodKey = new MethodRef(methodName, argumentTypeList, returnTypeObject);
        if (!this.proxiedMethodsRefSet.contains(methodKey)) {
            String interceptedProxyClassName = null;
            String interceptedProxyBridgeMethodName = null;
            if (!(this.isProxyTarget || methodElement.isAbstract() && !methodElement.isDefault())) {
                interceptedProxyClassName = this.proxyFullName;
                interceptedProxyBridgeMethodName = "$$access$$" + methodName;
                String bridgeDesc = AopProxyWriter.getMethodDescriptor((TypedElement)returnType, argumentTypeList);
                MethodVisitor bridgeWriter = this.classWriter.visitMethod(4096, interceptedProxyBridgeMethodName, bridgeDesc, null, null);
                GeneratorAdapter bridgeGenerator = new GeneratorAdapter(bridgeWriter, 4096, interceptedProxyBridgeMethodName, bridgeDesc);
                bridgeGenerator.loadThis();
                for (int i = 0; i < argumentTypeList.size(); ++i) {
                    bridgeGenerator.loadArg(i);
                }
                String desc = AopProxyWriter.getMethodDescriptor((TypedElement)returnType, argumentTypeList);
                bridgeWriter.visitMethodInsn(183, declaringTypeReference.getInternalName(), methodName, desc, this.isInterface && methodElement.isDefault());
                AopProxyWriter.pushReturnValue((MethodVisitor)bridgeWriter, (TypedElement)returnType);
                bridgeWriter.visitMaxs(13, 1);
                bridgeWriter.visitEnd();
            }
            BeanDefinitionWriter beanDefinitionWriter = this.parentWriter == null ? this.proxyBeanDefinitionWriter : this.parentWriter;
            int methodIndex = beanDefinitionWriter.visitExecutableMethod(beanType, methodElement, interceptedProxyClassName, interceptedProxyBridgeMethodName);
            int index = this.proxyMethodCount++;
            methodKey.methodIndex = methodIndex;
            this.proxiedMethods.add(methodKey);
            this.proxiedMethodsRefSet.add(methodKey);
            this.proxyTargetMethods.add(methodKey);
            this.buildMethodOverride((TypedElement)returnType, methodName, index, argumentTypeList, argumentCount, isVoidReturn);
        }
    }

    private void buildMethodOverride(TypedElement returnType, String methodName, int index, List<ParameterElement> argumentTypeList, int argumentCount, boolean isVoidReturn) {
        String desc = AopProxyWriter.getMethodDescriptor((TypedElement)returnType, argumentTypeList);
        MethodVisitor overridden = this.classWriter.visitMethod(1, methodName, desc, null, null);
        GeneratorAdapter overriddenMethodGenerator = new GeneratorAdapter(overridden, 1, methodName, desc);
        overriddenMethodGenerator.loadThis();
        overriddenMethodGenerator.getField(this.proxyType, FIELD_PROXY_METHODS, FIELD_TYPE_PROXY_METHODS);
        overriddenMethodGenerator.push(index);
        overriddenMethodGenerator.visitInsn(50);
        int methodProxyVar = overriddenMethodGenerator.newLocal(EXECUTABLE_METHOD_TYPE);
        overriddenMethodGenerator.storeLocal(methodProxyVar);
        overriddenMethodGenerator.loadThis();
        overriddenMethodGenerator.getField(this.proxyType, FIELD_INTERCEPTORS, FIELD_TYPE_INTERCEPTORS);
        overriddenMethodGenerator.push(index);
        overriddenMethodGenerator.visitInsn(50);
        int interceptorsLocalVar = overriddenMethodGenerator.newLocal(INTERCEPTOR_ARRAY_TYPE);
        overriddenMethodGenerator.storeLocal(interceptorsLocalVar);
        overriddenMethodGenerator.newInstance(TYPE_METHOD_INTERCEPTOR_CHAIN);
        overriddenMethodGenerator.dup();
        overriddenMethodGenerator.loadLocal(interceptorsLocalVar);
        overriddenMethodGenerator.loadThis();
        if (this.isProxyTarget) {
            if (this.hotswap || this.lazy) {
                overriddenMethodGenerator.invokeInterface(Type.getType(InterceptedProxy.class), Method.getMethod((String)"java.lang.Object interceptedTarget()"));
            } else {
                overriddenMethodGenerator.getField(this.proxyType, FIELD_TARGET, AopProxyWriter.getTypeReferenceForName((String)this.targetClassFullName, (String[])new String[0]));
            }
        }
        overriddenMethodGenerator.loadLocal(methodProxyVar);
        if (argumentCount > 0) {
            overriddenMethodGenerator.push(argumentCount);
            overriddenMethodGenerator.newArray(Type.getType(Object.class));
            for (int i = 0; i < argumentCount; ++i) {
                overriddenMethodGenerator.dup();
                ParameterElement argType = argumentTypeList.get(i);
                overriddenMethodGenerator.push(i);
                overriddenMethodGenerator.loadArg(i);
                AopProxyWriter.pushBoxPrimitiveIfNecessary((TypedElement)argType, (MethodVisitor)overriddenMethodGenerator);
                overriddenMethodGenerator.visitInsn(83);
            }
            overriddenMethodGenerator.invokeConstructor(TYPE_METHOD_INTERCEPTOR_CHAIN, Method.getMethod((Constructor)CONSTRUCTOR_METHOD_INTERCEPTOR_CHAIN));
        } else {
            overriddenMethodGenerator.invokeConstructor(TYPE_METHOD_INTERCEPTOR_CHAIN, Method.getMethod((Constructor)CONSTRUCTOR_METHOD_INTERCEPTOR_CHAIN_NO_PARAMS));
        }
        int chainVar = overriddenMethodGenerator.newLocal(TYPE_METHOD_INTERCEPTOR_CHAIN);
        overriddenMethodGenerator.storeLocal(chainVar);
        overriddenMethodGenerator.loadLocal(chainVar);
        overriddenMethodGenerator.visitMethodInsn(182, TYPE_INTERCEPTOR_CHAIN.getInternalName(), "proceed", AopProxyWriter.getMethodDescriptor((String)Object.class.getName(), (String[])new String[0]), false);
        if (isVoidReturn) {
            this.returnVoid(overriddenMethodGenerator);
        } else {
            AopProxyWriter.pushCastToType((MethodVisitor)overriddenMethodGenerator, (TypedElement)returnType);
            AopProxyWriter.pushReturnValue((MethodVisitor)overriddenMethodGenerator, (TypedElement)returnType);
        }
        overriddenMethodGenerator.visitMaxs(13, chainVar);
        overriddenMethodGenerator.visitEnd();
    }

    private void buildMethodDelegate(MethodElement methodElement, MethodElement overriddenBy, boolean isVoidReturn) {
        String desc = AopProxyWriter.getMethodDescriptor((TypedElement)methodElement.getReturnType().getType(), Arrays.asList(methodElement.getSuspendParameters()));
        MethodVisitor overridden = this.classWriter.visitMethod(1, methodElement.getName(), desc, null, null);
        GeneratorAdapter overriddenMethodGenerator = new GeneratorAdapter(overridden, 1, methodElement.getName(), desc);
        overriddenMethodGenerator.loadThis();
        int i = 0;
        for (ParameterElement param : methodElement.getSuspendParameters()) {
            overriddenMethodGenerator.loadArg(i++);
            AopProxyWriter.pushCastToType((MethodVisitor)overriddenMethodGenerator, (TypedElement)param.getGenericType());
        }
        overriddenMethodGenerator.visitMethodInsn(183, this.proxyType.getInternalName(), overriddenBy.getName(), AopProxyWriter.getMethodDescriptor((TypedElement)overriddenBy.getReturnType().getType(), Arrays.asList(overriddenBy.getSuspendParameters())), this.isInterface && overriddenBy.isDefault());
        if (isVoidReturn) {
            overriddenMethodGenerator.returnValue();
        } else {
            ClassElement returnType = overriddenBy.getReturnType();
            AopProxyWriter.pushCastToType((MethodVisitor)overriddenMethodGenerator, (TypedElement)returnType);
            AopProxyWriter.pushReturnValue((MethodVisitor)overriddenMethodGenerator, (TypedElement)overriddenBy.getReturnType());
        }
        overriddenMethodGenerator.visitMaxs(13, 1);
        overriddenMethodGenerator.visitEnd();
    }

    public void visitBeanDefinitionEnd() {
        Object[] adviceInterfaces;
        if (this.declaredConstructor == null) {
            throw new IllegalStateException("The method visitBeanDefinitionConstructor(..) should be called at least once");
        }
        this.initConstructor(this.declaredConstructor);
        if (this.parentWriter != null && !this.isProxyTarget) {
            this.processAlreadyVisitedMethods(this.parentWriter);
        }
        this.interceptorParameter.annotate("io.micronaut.inject.qualifiers.InterceptorBindingQualifier", builder -> {
            AnnotationValue[] interceptorBinding = this.interceptorBinding.toArray(new AnnotationValue[0]);
            builder.values(interceptorBinding);
        });
        this.qualifierParameter.annotate("javax.annotation.Nullable");
        String constructorDescriptor = AopProxyWriter.getConstructorDescriptor(Arrays.asList(this.newConstructor.getParameters()));
        ClassWriter proxyClassWriter = this.classWriter;
        this.constructorWriter = proxyClassWriter.visitMethod(1, "<init>", constructorDescriptor, null, null);
        GeneratorAdapter proxyConstructorGenerator = this.constructorGenerator = new GeneratorAdapter(this.constructorWriter, 1, "<init>", constructorDescriptor);
        proxyConstructorGenerator.loadThis();
        if (this.isInterface) {
            proxyConstructorGenerator.invokeConstructor(TYPE_OBJECT, METHOD_DEFAULT_CONSTRUCTOR);
        } else {
            ParameterElement[] existingArguments = this.declaredConstructor.getParameters();
            for (int i = 0; i < existingArguments.length; ++i) {
                proxyConstructorGenerator.loadArg(i);
            }
            String superConstructorDescriptor = AopProxyWriter.getConstructorDescriptor(Arrays.asList(existingArguments));
            proxyConstructorGenerator.invokeConstructor(AopProxyWriter.getTypeReferenceForName((String)this.targetClassFullName, (String[])new String[0]), new Method("<init>", superConstructorDescriptor));
        }
        this.proxyBeanDefinitionWriter.visitBeanDefinitionConstructor(this.newConstructor, this.constructorRequiresReflection, this.visitorContext);
        GeneratorAdapter targetDefinitionGenerator = null;
        GeneratorAdapter targetTypeGenerator = null;
        if (this.parentWriter != null) {
            this.proxyBeanDefinitionWriter.visitBeanDefinitionInterface(ProxyBeanDefinition.class);
            ClassVisitor pcw = this.proxyBeanDefinitionWriter.getClassWriter();
            targetDefinitionGenerator = new GeneratorAdapter(pcw.visitMethod(1, METHOD_PROXY_TARGET_TYPE.getName(), METHOD_PROXY_TARGET_TYPE.getDescriptor(), null, null), 1, METHOD_PROXY_TARGET_TYPE.getName(), METHOD_PROXY_TARGET_TYPE.getDescriptor());
            targetDefinitionGenerator.loadThis();
            targetDefinitionGenerator.push(AopProxyWriter.getTypeReferenceForName((String)this.parentWriter.getBeanDefinitionName(), (String[])new String[0]));
            targetDefinitionGenerator.returnValue();
            targetTypeGenerator = new GeneratorAdapter(pcw.visitMethod(1, METHOD_PROXY_TARGET_CLASS.getName(), METHOD_PROXY_TARGET_CLASS.getDescriptor(), null, null), 1, METHOD_PROXY_TARGET_CLASS.getName(), METHOD_PROXY_TARGET_CLASS.getDescriptor());
            targetTypeGenerator.loadThis();
            targetTypeGenerator.push(AopProxyWriter.getTypeReferenceForName((String)this.parentWriter.getBeanTypeName(), (String[])new String[0]));
            targetTypeGenerator.returnValue();
        }
        Class interceptedInterface = this.isIntroduction ? Introduced.class : Intercepted.class;
        Type targetType = AopProxyWriter.getTypeReferenceForName((String)this.targetClassFullName, (String[])new String[0]);
        if (this.isProxyTarget) {
            proxyClassWriter.visitField(18, FIELD_BEAN_LOCATOR, TYPE_BEAN_LOCATOR.getDescriptor(), null, null);
            proxyClassWriter.visitField(2, FIELD_BEAN_QUALIFIER, Type.getType(Qualifier.class).getDescriptor(), null, null);
            this.writeWithQualifierMethod(proxyClassWriter);
            if (!this.lazy || this.cacheLazyTarget) {
                int modifiers = this.hotswap ? 2 : 18;
                proxyClassWriter.visitField(modifiers, FIELD_TARGET, targetType.getDescriptor(), null, null);
            }
            if (this.lazy) {
                interceptedInterface = InterceptedProxy.class;
                proxyClassWriter.visitField(2, FIELD_BEAN_RESOLUTION_CONTEXT, Type.getType(BeanResolutionContext.class).getDescriptor(), null, null);
            } else {
                Class clazz = interceptedInterface = this.hotswap ? HotSwappableInterceptedProxy.class : InterceptedProxy.class;
                if (this.hotswap) {
                    proxyClassWriter.visitField(18, FIELD_READ_WRITE_LOCK, TYPE_READ_WRITE_LOCK.getDescriptor(), null, null);
                    proxyConstructorGenerator.loadThis();
                    this.pushNewInstance(proxyConstructorGenerator, TYPE_READ_WRITE_LOCK);
                    proxyConstructorGenerator.putField(this.proxyType, FIELD_READ_WRITE_LOCK, TYPE_READ_WRITE_LOCK);
                    proxyClassWriter.visitField(18, FIELD_READ_LOCK, TYPE_LOCK.getDescriptor(), null, null);
                    proxyConstructorGenerator.loadThis();
                    proxyConstructorGenerator.loadThis();
                    proxyConstructorGenerator.getField(this.proxyType, FIELD_READ_WRITE_LOCK, TYPE_READ_WRITE_LOCK);
                    proxyConstructorGenerator.invokeInterface(Type.getType(ReadWriteLock.class), Method.getMethod((String)(Lock.class.getName() + " readLock()")));
                    proxyConstructorGenerator.putField(this.proxyType, FIELD_READ_LOCK, TYPE_LOCK);
                    proxyClassWriter.visitField(18, FIELD_WRITE_LOCK, Type.getDescriptor(Lock.class), null, null);
                    proxyConstructorGenerator.loadThis();
                    proxyConstructorGenerator.loadThis();
                    proxyConstructorGenerator.getField(this.proxyType, FIELD_READ_WRITE_LOCK, TYPE_READ_WRITE_LOCK);
                    proxyConstructorGenerator.invokeInterface(Type.getType(ReadWriteLock.class), Method.getMethod((String)(Lock.class.getName() + " writeLock()")));
                    proxyConstructorGenerator.putField(this.proxyType, FIELD_WRITE_LOCK, TYPE_LOCK);
                }
            }
            proxyConstructorGenerator.loadThis();
            proxyConstructorGenerator.loadArg(this.beanContextArgumentIndex);
            proxyConstructorGenerator.putField(this.proxyType, FIELD_BEAN_LOCATOR, TYPE_BEAN_LOCATOR);
            proxyConstructorGenerator.loadThis();
            proxyConstructorGenerator.loadArg(this.qualifierIndex);
            proxyConstructorGenerator.putField(this.proxyType, FIELD_BEAN_QUALIFIER, Type.getType(Qualifier.class));
            if (!this.lazy) {
                proxyConstructorGenerator.loadThis();
                this.pushResolveProxyTargetBean(proxyConstructorGenerator, targetType);
                proxyConstructorGenerator.putField(this.proxyType, FIELD_TARGET, targetType);
            } else {
                proxyConstructorGenerator.loadThis();
                proxyConstructorGenerator.loadArg(this.beanResolutionContextArgumentIndex);
                proxyConstructorGenerator.invokeInterface(Type.getType(BeanResolutionContext.class), Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(BeanResolutionContext.class, (String)"copy", (Class[])new Class[0])));
                proxyConstructorGenerator.putField(this.proxyType, FIELD_BEAN_RESOLUTION_CONTEXT, Type.getType(BeanResolutionContext.class));
            }
            this.writeInterceptedTargetMethod(proxyClassWriter, targetType);
            if (this.hotswap && !this.lazy) {
                this.writeSwapMethod(proxyClassWriter, targetType);
            }
        }
        Object[] interfaces = this.getImplementedInterfaceInternalNames();
        if (this.isInterface && this.implementInterface) {
            adviceInterfaces = new String[]{AopProxyWriter.getInternalName((String)this.targetClassFullName), Type.getInternalName(interceptedInterface)};
            interfaces = (String[])ArrayUtils.concat((Object[])interfaces, (Object[])adviceInterfaces);
        } else {
            adviceInterfaces = new String[]{Type.getInternalName(interceptedInterface)};
            interfaces = (String[])ArrayUtils.concat((Object[])interfaces, (Object[])adviceInterfaces);
        }
        proxyClassWriter.visit(52, 4096, this.proxyInternalName, null, this.isInterface ? TYPE_OBJECT.getInternalName() : AopProxyWriter.getTypeReferenceForName((String)this.targetClassFullName, (String[])new String[0]).getInternalName(), (String[])interfaces);
        proxyConstructorGenerator.loadThis();
        proxyConstructorGenerator.push(this.proxyMethodCount);
        proxyConstructorGenerator.newArray(EXECUTABLE_METHOD_TYPE);
        proxyConstructorGenerator.putField(this.proxyType, FIELD_PROXY_METHODS, FIELD_TYPE_PROXY_METHODS);
        proxyConstructorGenerator.loadThis();
        proxyConstructorGenerator.push(this.proxyMethodCount);
        proxyConstructorGenerator.newArray(INTERCEPTOR_ARRAY_TYPE);
        proxyConstructorGenerator.putField(this.proxyType, FIELD_INTERCEPTORS, FIELD_TYPE_INTERCEPTORS);
        if (this.isProxyTarget) {
            if (this.proxiedMethods.size() == this.proxyMethodCount) {
                Iterator<MethodRef> iterator = this.proxyTargetMethods.iterator();
                for (int i = 0; i < this.proxyMethodCount; ++i) {
                    MethodRef methodRef = iterator.next();
                    proxyConstructorGenerator.loadThis();
                    proxyConstructorGenerator.getField(this.proxyType, FIELD_PROXY_METHODS, FIELD_TYPE_PROXY_METHODS);
                    proxyConstructorGenerator.push(i);
                    proxyConstructorGenerator.loadArg(this.beanContextArgumentIndex);
                    this.buildProxyLookupArgument(proxyConstructorGenerator, targetType);
                    proxyConstructorGenerator.loadArg(this.qualifierIndex);
                    AopProxyWriter.pushMethodNameAndTypesArguments((GeneratorAdapter)proxyConstructorGenerator, (String)methodRef.name, methodRef.argumentTypes);
                    proxyConstructorGenerator.invokeInterface(Type.getType(ExecutionHandleLocator.class), METHOD_GET_PROXY_TARGET);
                    proxyConstructorGenerator.visitInsn(83);
                    this.pushResolveInterceptorsCall(proxyConstructorGenerator, i, this.isIntroduction);
                }
            }
        } else if (!this.proxiedMethods.isEmpty()) {
            BeanDefinitionWriter beanDefinitionWriter = this.parentWriter == null ? this.proxyBeanDefinitionWriter : this.parentWriter;
            ExecutableMethodsDefinitionWriter executableMethodsDefinitionWriter = beanDefinitionWriter.getExecutableMethodsWriter();
            Type executableMethodsDefinitionType = executableMethodsDefinitionWriter.getClassType();
            proxyConstructorGenerator.newInstance(executableMethodsDefinitionType);
            proxyConstructorGenerator.dup();
            if (executableMethodsDefinitionWriter.isSupportsInterceptedProxy()) {
                proxyConstructorGenerator.push(true);
                proxyConstructorGenerator.invokeConstructor(executableMethodsDefinitionType, new Method("<init>", AopProxyWriter.getConstructorDescriptor((Class[])new Class[]{Boolean.TYPE})));
            } else {
                proxyConstructorGenerator.invokeConstructor(executableMethodsDefinitionType, new Method("<init>", "()V"));
            }
            int executableMethodsDefinitionIndex = proxyConstructorGenerator.newLocal(executableMethodsDefinitionType);
            proxyConstructorGenerator.storeLocal(executableMethodsDefinitionIndex, executableMethodsDefinitionType);
            for (int i = 0; i < this.proxyMethodCount; ++i) {
                MethodRef methodRef = this.proxiedMethods.get(i);
                int methodIndex = methodRef.methodIndex;
                boolean introduction = this.isIntroduction && (executableMethodsDefinitionWriter.isAbstract(methodIndex) || executableMethodsDefinitionWriter.isInterface(methodIndex) && !executableMethodsDefinitionWriter.isDefault(methodIndex));
                proxyConstructorGenerator.loadThis();
                proxyConstructorGenerator.getField(this.proxyType, FIELD_PROXY_METHODS, FIELD_TYPE_PROXY_METHODS);
                proxyConstructorGenerator.push(i);
                proxyConstructorGenerator.loadLocal(executableMethodsDefinitionIndex);
                proxyConstructorGenerator.push(methodIndex);
                proxyConstructorGenerator.invokeVirtual(executableMethodsDefinitionType, ExecutableMethodsDefinitionWriter.GET_EXECUTABLE_AT_INDEX_METHOD);
                proxyConstructorGenerator.visitInsn(83);
                this.pushResolveInterceptorsCall(proxyConstructorGenerator, i, introduction);
            }
        }
        for (Runnable fieldInjectionPoint : this.deferredInjectionPoints) {
            fieldInjectionPoint.run();
        }
        this.constructorWriter.visitInsn(177);
        this.constructorWriter.visitMaxs(13, 1);
        this.constructorWriter.visitEnd();
        this.proxyBeanDefinitionWriter.visitBeanDefinitionEnd();
        if (targetDefinitionGenerator != null) {
            targetDefinitionGenerator.visitMaxs(1, 1);
            targetDefinitionGenerator.visitEnd();
        }
        if (targetTypeGenerator != null) {
            targetTypeGenerator.visitMaxs(1, 1);
            targetTypeGenerator.visitEnd();
        }
        proxyClassWriter.visitEnd();
    }

    private void pushResolveLazyProxyTargetBean(GeneratorAdapter generatorAdapter, Type targetType) {
        generatorAdapter.loadThis();
        generatorAdapter.getField(this.proxyType, FIELD_BEAN_LOCATOR, TYPE_BEAN_LOCATOR);
        AopProxyWriter.pushCastToType((MethodVisitor)generatorAdapter, (Type)TYPE_DEFAULT_BEAN_CONTEXT);
        generatorAdapter.loadThis();
        generatorAdapter.getField(this.proxyType, FIELD_BEAN_RESOLUTION_CONTEXT, Type.getType(BeanResolutionContext.class));
        this.buildProxyLookupArgument(generatorAdapter, targetType);
        generatorAdapter.loadThis();
        generatorAdapter.getField(this.proxyType, FIELD_BEAN_QUALIFIER, Type.getType(Qualifier.class));
        generatorAdapter.invokeVirtual(TYPE_DEFAULT_BEAN_CONTEXT, METHOD_GET_PROXY_TARGET_BEAN_WITH_CONTEXT);
        AopProxyWriter.pushCastToType((MethodVisitor)generatorAdapter, (Type)AopProxyWriter.getTypeReferenceForName((String)this.targetClassFullName, (String[])new String[0]));
    }

    private void pushResolveProxyTargetBean(GeneratorAdapter generatorAdapter, Type targetType) {
        generatorAdapter.loadThis();
        generatorAdapter.loadArg(this.beanContextArgumentIndex);
        AopProxyWriter.pushCastToType((MethodVisitor)generatorAdapter, (Type)TYPE_DEFAULT_BEAN_CONTEXT);
        generatorAdapter.loadArg(this.beanResolutionContextArgumentIndex);
        this.buildProxyLookupArgument(generatorAdapter, targetType);
        generatorAdapter.loadThis();
        generatorAdapter.getField(this.proxyType, FIELD_BEAN_QUALIFIER, Type.getType(Qualifier.class));
        generatorAdapter.invokeVirtual(TYPE_DEFAULT_BEAN_CONTEXT, METHOD_GET_PROXY_TARGET_BEAN_WITH_CONTEXT);
        AopProxyWriter.pushCastToType((MethodVisitor)generatorAdapter, (Type)AopProxyWriter.getTypeReferenceForName((String)this.targetClassFullName, (String[])new String[0]));
    }

    private void buildProxyLookupArgument(GeneratorAdapter proxyConstructorGenerator, Type targetType) {
        AopProxyWriter.buildArgumentWithGenerics((GeneratorAdapter)proxyConstructorGenerator, (Type)targetType, (AnnotationMetadataReference)new AnnotationMetadataReference(this.getBeanDefinitionReferenceClassName(), this.getAnnotationMetadata()), (ClassElement[])(this.parentWriter != null ? this.parentWriter.getTypeArguments() : this.proxyBeanDefinitionWriter.getTypeArguments()));
    }

    public void writeTo(File compilationDir) throws IOException {
        this.accept(this.newClassWriterOutputVisitor(compilationDir));
    }

    @NonNull
    public ClassElement[] getTypeArguments() {
        return this.proxyBeanDefinitionWriter.getTypeArguments();
    }

    public void accept(ClassWriterOutputVisitor visitor) throws IOException {
        this.proxyBeanDefinitionWriter.accept(visitor);
        try (OutputStream out = visitor.visitClass(this.proxyFullName, this.getOriginatingElements());){
            out.write(this.classWriter.toByteArray());
        }
    }

    public void visitSuperBeanDefinition(String name) {
        this.proxyBeanDefinitionWriter.visitSuperBeanDefinition(name);
    }

    public void visitSuperBeanDefinitionFactory(String beanName) {
        this.proxyBeanDefinitionWriter.visitSuperBeanDefinitionFactory(beanName);
    }

    public void visitSetterValue(TypedElement declaringType, MethodElement methodElement, boolean requiresReflection, boolean isOptional) {
        this.deferredInjectionPoints.add(() -> this.proxyBeanDefinitionWriter.visitSetterValue(declaringType, methodElement, requiresReflection, isOptional));
    }

    public void visitPostConstructMethod(TypedElement declaringType, MethodElement methodElement, boolean requiresReflection, VisitorContext visitorContext) {
        this.deferredInjectionPoints.add(() -> this.proxyBeanDefinitionWriter.visitPostConstructMethod(declaringType, methodElement, requiresReflection, visitorContext));
    }

    public void visitPreDestroyMethod(TypedElement declaringType, MethodElement methodElement, boolean requiresReflection, VisitorContext visitorContext) {
        this.deferredInjectionPoints.add(() -> this.proxyBeanDefinitionWriter.visitPreDestroyMethod(declaringType, methodElement, requiresReflection, visitorContext));
    }

    public void visitMethodInjectionPoint(TypedElement beanType, MethodElement methodElement, boolean requiresReflection, VisitorContext visitorContext) {
        this.deferredInjectionPoints.add(() -> this.proxyBeanDefinitionWriter.visitMethodInjectionPoint(beanType, methodElement, requiresReflection, visitorContext));
    }

    public int visitExecutableMethod(TypedElement declaringBean, MethodElement methodElement, VisitorContext visitorContext) {
        this.deferredInjectionPoints.add(() -> this.proxyBeanDefinitionWriter.visitExecutableMethod(declaringBean, methodElement, visitorContext));
        return -1;
    }

    public void visitFieldInjectionPoint(TypedElement declaringType, FieldElement fieldType, boolean requiresReflection) {
        this.deferredInjectionPoints.add(() -> this.proxyBeanDefinitionWriter.visitFieldInjectionPoint(declaringType, fieldType, requiresReflection));
    }

    public void visitFieldValue(TypedElement declaringType, FieldElement fieldType, boolean requiresReflection, boolean isOptional) {
        this.deferredInjectionPoints.add(() -> this.proxyBeanDefinitionWriter.visitFieldValue(declaringType, fieldType, requiresReflection, isOptional));
    }

    public String getPackageName() {
        return this.proxyBeanDefinitionWriter.getPackageName();
    }

    public String getBeanSimpleName() {
        return this.proxyBeanDefinitionWriter.getBeanSimpleName();
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.proxyBeanDefinitionWriter.getAnnotationMetadata();
    }

    public void visitConfigBuilderField(ClassElement type, String field, AnnotationMetadata annotationMetadata, ConfigurationMetadataBuilder metadataBuilder, boolean isInterface) {
        this.proxyBeanDefinitionWriter.visitConfigBuilderField(type, field, annotationMetadata, metadataBuilder, isInterface);
    }

    public void visitConfigBuilderMethod(ClassElement type, String methodName, AnnotationMetadata annotationMetadata, ConfigurationMetadataBuilder metadataBuilder, boolean isInterface) {
        this.proxyBeanDefinitionWriter.visitConfigBuilderMethod(type, methodName, annotationMetadata, metadataBuilder, isInterface);
    }

    public void visitConfigBuilderMethod(String prefix, ClassElement returnType, String methodName, ClassElement paramType, Map<String, ClassElement> generics, String propertyPath) {
        this.proxyBeanDefinitionWriter.visitConfigBuilderMethod(prefix, returnType, methodName, paramType, generics, propertyPath);
    }

    public void visitConfigBuilderDurationMethod(String prefix, ClassElement returnType, String methodName, String propertyPath) {
        this.proxyBeanDefinitionWriter.visitConfigBuilderDurationMethod(prefix, returnType, methodName, propertyPath);
    }

    public void visitConfigBuilderEnd() {
        this.proxyBeanDefinitionWriter.visitConfigBuilderEnd();
    }

    public void setRequiresMethodProcessing(boolean shouldPreProcess) {
        this.proxyBeanDefinitionWriter.setRequiresMethodProcessing(shouldPreProcess);
    }

    public void visitTypeArguments(Map<String, Map<String, ClassElement>> typeArguments) {
        this.proxyBeanDefinitionWriter.visitTypeArguments(typeArguments);
    }

    public boolean requiresMethodProcessing() {
        return this.proxyBeanDefinitionWriter.requiresMethodProcessing();
    }

    public String getProxiedTypeName() {
        return this.targetClassFullName;
    }

    public String getProxiedBeanDefinitionName() {
        return this.parentWriter != null ? this.parentWriter.getBeanDefinitionName() : null;
    }

    public void visitInterceptorBinding(AnnotationValue<?> ... interceptorBinding) {
        if (interceptorBinding != null) {
            for (AnnotationValue<?> annotationValue : interceptorBinding) {
                annotationValue.stringValue().ifPresent(annName -> this.interceptorBinding.add(annotationValue));
            }
        }
    }

    private Set<AnnotationValue<?>> toInterceptorBindingMap(AnnotationValue<?>[] interceptorBinding) {
        return new LinkedHashSet(Arrays.asList(interceptorBinding));
    }

    private void readUnlock(GeneratorAdapter interceptedTargetVisitor) {
        this.invokeMethodOnLock(interceptedTargetVisitor, FIELD_READ_LOCK, Method.getMethod((String)"void unlock()"));
    }

    private void readLock(GeneratorAdapter interceptedTargetVisitor) {
        this.invokeMethodOnLock(interceptedTargetVisitor, FIELD_READ_LOCK, Method.getMethod((String)"void lock()"));
    }

    private void writeUnlock(GeneratorAdapter interceptedTargetVisitor) {
        this.invokeMethodOnLock(interceptedTargetVisitor, FIELD_WRITE_LOCK, Method.getMethod((String)"void unlock()"));
    }

    private void writeLock(GeneratorAdapter interceptedTargetVisitor) {
        this.invokeMethodOnLock(interceptedTargetVisitor, FIELD_WRITE_LOCK, Method.getMethod((String)"void lock()"));
    }

    private void invokeMethodOnLock(GeneratorAdapter interceptedTargetVisitor, String field, Method method) {
        interceptedTargetVisitor.loadThis();
        interceptedTargetVisitor.getField(this.proxyType, field, TYPE_LOCK);
        interceptedTargetVisitor.invokeInterface(TYPE_LOCK, method);
    }

    private void writeWithQualifierMethod(ClassWriter proxyClassWriter) {
        GeneratorAdapter withQualifierMethod = this.startPublicMethod(proxyClassWriter, "$withBeanQualifier", Void.TYPE.getName(), new String[]{Qualifier.class.getName()});
        withQualifierMethod.loadThis();
        withQualifierMethod.loadArg(0);
        withQualifierMethod.putField(this.proxyType, FIELD_BEAN_QUALIFIER, Type.getType(Qualifier.class));
        withQualifierMethod.visitInsn(177);
        withQualifierMethod.visitEnd();
        withQualifierMethod.visitMaxs(1, 1);
    }

    private void writeSwapMethod(ClassWriter proxyClassWriter, Type targetType) {
        GeneratorAdapter swapGenerator = this.startPublicMethod(proxyClassWriter, "swap", targetType.getClassName(), new String[]{targetType.getClassName()});
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        swapGenerator.visitTryCatchBlock(l0, l1, l2, null);
        this.writeLock(swapGenerator);
        swapGenerator.visitLabel(l0);
        swapGenerator.loadThis();
        swapGenerator.getField(this.proxyType, FIELD_TARGET, targetType);
        int localRef = swapGenerator.newLocal(targetType);
        swapGenerator.storeLocal(localRef);
        swapGenerator.loadThis();
        swapGenerator.visitVarInsn(25, 1);
        swapGenerator.putField(this.proxyType, FIELD_TARGET, targetType);
        swapGenerator.visitLabel(l1);
        this.writeUnlock(swapGenerator);
        swapGenerator.loadLocal(localRef);
        swapGenerator.returnValue();
        swapGenerator.visitLabel(l2);
        int var = swapGenerator.newLocal(targetType);
        swapGenerator.storeLocal(var);
        this.writeUnlock(swapGenerator);
        swapGenerator.loadLocal(var);
        swapGenerator.throwException();
        swapGenerator.visitMaxs(2, 3);
        swapGenerator.visitEnd();
    }

    private void writeInterceptedTargetMethod(ClassWriter proxyClassWriter, Type targetType) {
        GeneratorAdapter interceptedTargetVisitor = this.startPublicMethod(proxyClassWriter, "interceptedTarget", Object.class.getName(), new String[0]);
        if (this.lazy) {
            if (this.cacheLazyTarget) {
                int targetLocal = interceptedTargetVisitor.newLocal(targetType);
                interceptedTargetVisitor.loadThis();
                interceptedTargetVisitor.getField(this.proxyType, FIELD_TARGET, targetType);
                interceptedTargetVisitor.storeLocal(targetLocal, targetType);
                interceptedTargetVisitor.loadLocal(targetLocal, targetType);
                Label returnLabel = new Label();
                interceptedTargetVisitor.ifNonNull(returnLabel);
                Label synchronizationEnd = new Label();
                interceptedTargetVisitor.loadThis();
                interceptedTargetVisitor.monitorEnter();
                Label tryLabel = new Label();
                Label catchLabel = new Label();
                interceptedTargetVisitor.visitTryCatchBlock(tryLabel, returnLabel, catchLabel, null);
                interceptedTargetVisitor.visitLabel(tryLabel);
                interceptedTargetVisitor.loadThis();
                interceptedTargetVisitor.getField(this.proxyType, FIELD_TARGET, targetType);
                interceptedTargetVisitor.storeLocal(targetLocal, targetType);
                interceptedTargetVisitor.loadLocal(targetLocal, targetType);
                interceptedTargetVisitor.ifNonNull(synchronizationEnd);
                interceptedTargetVisitor.loadThis();
                this.pushResolveLazyProxyTargetBean(interceptedTargetVisitor, targetType);
                interceptedTargetVisitor.putField(this.proxyType, FIELD_TARGET, targetType);
                interceptedTargetVisitor.loadThis();
                interceptedTargetVisitor.push((String)null);
                interceptedTargetVisitor.putField(this.proxyType, FIELD_BEAN_RESOLUTION_CONTEXT, Type.getType(BeanResolutionContext.class));
                interceptedTargetVisitor.goTo(synchronizationEnd);
                interceptedTargetVisitor.visitLabel(catchLabel);
                interceptedTargetVisitor.loadThis();
                interceptedTargetVisitor.monitorExit();
                interceptedTargetVisitor.throwException();
                interceptedTargetVisitor.visitLabel(synchronizationEnd);
                interceptedTargetVisitor.loadThis();
                interceptedTargetVisitor.monitorExit();
                interceptedTargetVisitor.goTo(returnLabel);
                interceptedTargetVisitor.visitLabel(returnLabel);
                interceptedTargetVisitor.loadThis();
                interceptedTargetVisitor.getField(this.proxyType, FIELD_TARGET, targetType);
                interceptedTargetVisitor.returnValue();
            } else {
                this.pushResolveLazyProxyTargetBean(interceptedTargetVisitor, targetType);
                interceptedTargetVisitor.returnValue();
            }
        } else {
            int localRef = -1;
            Label l1 = null;
            Label l2 = null;
            if (this.hotswap) {
                Label l0 = new Label();
                l1 = new Label();
                l2 = new Label();
                interceptedTargetVisitor.visitTryCatchBlock(l0, l1, l2, null);
                this.readLock(interceptedTargetVisitor);
                interceptedTargetVisitor.visitLabel(l0);
            }
            interceptedTargetVisitor.loadThis();
            interceptedTargetVisitor.getField(this.proxyType, FIELD_TARGET, targetType);
            if (this.hotswap) {
                localRef = interceptedTargetVisitor.newLocal(targetType);
                interceptedTargetVisitor.storeLocal(localRef);
                interceptedTargetVisitor.visitLabel(l1);
                this.readUnlock(interceptedTargetVisitor);
                interceptedTargetVisitor.loadLocal(localRef);
            }
            interceptedTargetVisitor.returnValue();
            if (localRef > -1) {
                interceptedTargetVisitor.visitLabel(l2);
                int var = interceptedTargetVisitor.newLocal(targetType);
                interceptedTargetVisitor.storeLocal(var);
                this.readUnlock(interceptedTargetVisitor);
                interceptedTargetVisitor.loadLocal(var);
                interceptedTargetVisitor.throwException();
            }
        }
        interceptedTargetVisitor.visitMaxs(1, 2);
        interceptedTargetVisitor.visitEnd();
    }

    private void pushResolveInterceptorsCall(GeneratorAdapter proxyConstructorGenerator, int i, boolean isIntroduction) {
        proxyConstructorGenerator.loadThis();
        proxyConstructorGenerator.getField(this.proxyType, FIELD_INTERCEPTORS, FIELD_TYPE_INTERCEPTORS);
        proxyConstructorGenerator.push(i);
        proxyConstructorGenerator.loadArg(this.beanContextArgumentIndex);
        proxyConstructorGenerator.loadThis();
        proxyConstructorGenerator.getField(this.proxyType, FIELD_PROXY_METHODS, FIELD_TYPE_PROXY_METHODS);
        proxyConstructorGenerator.push(i);
        proxyConstructorGenerator.visitInsn(50);
        proxyConstructorGenerator.loadArg(this.interceptorArgumentIndex);
        if (isIntroduction) {
            proxyConstructorGenerator.invokeStatic(TYPE_INTERCEPTOR_CHAIN, Method.getMethod((java.lang.reflect.Method)RESOLVE_INTRODUCTION_INTERCEPTORS_METHOD));
        } else {
            proxyConstructorGenerator.invokeStatic(TYPE_INTERCEPTOR_CHAIN, Method.getMethod((java.lang.reflect.Method)RESOLVE_AROUND_INTERCEPTORS_METHOD));
        }
        proxyConstructorGenerator.visitInsn(83);
    }

    private void processAlreadyVisitedMethods(BeanDefinitionWriter parent) {
        List postConstructMethodVisits = parent.getPostConstructMethodVisits();
        for (BeanDefinitionWriter.MethodVisitData methodVisit : postConstructMethodVisits) {
            this.visitPostConstructMethod(methodVisit.getBeanType(), methodVisit.getMethodElement(), methodVisit.isRequiresReflection(), this.visitorContext);
        }
    }

    private static final class MethodRef {
        protected final String name;
        protected final List<ClassElement> argumentTypes;
        protected final Type returnType;
        int methodIndex;
        private final List<String> rawTypes;

        public MethodRef(String name, List<ParameterElement> argumentTypes, Type returnType) {
            this.name = name;
            this.argumentTypes = argumentTypes.stream().map(ParameterElement::getType).collect(Collectors.toList());
            this.rawTypes = this.argumentTypes.stream().map(Element::getName).collect(Collectors.toList());
            this.returnType = returnType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodRef methodRef = (MethodRef)o;
            return Objects.equals(this.name, methodRef.name) && Objects.equals(this.rawTypes, methodRef.rawTypes) && Objects.equals(this.returnType, methodRef.returnType);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.rawTypes, this.returnType);
        }
    }
}

