@rem
@rem Copyright 2015 the original author or authors.
@rem
@rem Licensed under the Apache License, Version 2.0 (the "License");
@rem you may not use this file except in compliance with the License.
@rem You may obtain a copy of the License at
@rem
@rem      https://www.apache.org/licenses/LICENSE-2.0
@rem
@rem Unless required by applicable law or agreed to in writing, software
@rem distributed under the License is distributed on an "AS IS" BASIS,
@rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@rem See the License for the specific language governing permissions and
@rem limitations under the License.
@rem

@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  grails-shell startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Resolve any "." and ".." in APP_HOME to make it shorter.
for %%i in ("%APP_HOME%") do set APP_HOME=%%~fi

@rem Add default JVM options here. You can also use JAVA_OPTS and GRAILS_SHELL_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto execute

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto execute

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\grails-shell-5.2.2.jar;%APP_HOME%\lib\grails-bootstrap-5.2.2.jar;%APP_HOME%\lib\grails-gradle-model-5.2.2.jar;%APP_HOME%\lib\groovy-ant-3.0.11.jar;%APP_HOME%\lib\groovy-json-3.0.11.jar;%APP_HOME%\lib\groovy-jmx-3.0.11.jar;%APP_HOME%\lib\groovy-templates-3.0.11.jar;%APP_HOME%\lib\groovy-xml-3.0.11.jar;%APP_HOME%\lib\groovy-3.0.11.jar;%APP_HOME%\lib\jcl-over-slf4j-1.7.36.jar;%APP_HOME%\lib\gradle-tooling-api-6.9.jar;%APP_HOME%\lib\spring-boot-cli-2.7.0.jar;%APP_HOME%\lib\maven-resolver-connector-basic-1.8.0.jar;%APP_HOME%\lib\maven-resolver-provider-3.8.3.jar;%APP_HOME%\lib\maven-resolver-impl-1.8.0.jar;%APP_HOME%\lib\maven-resolver-transport-file-1.8.0.jar;%APP_HOME%\lib\maven-resolver-transport-http-1.8.0.jar;%APP_HOME%\lib\slf4j-simple-1.7.36.jar;%APP_HOME%\lib\micronaut-inject-3.5.4.jar;%APP_HOME%\lib\maven-resolver-named-locks-1.8.0.jar;%APP_HOME%\lib\micronaut-core-3.5.4.jar;%APP_HOME%\lib\slf4j-api-1.7.36.jar;%APP_HOME%\lib\ant-junit-1.10.12.jar;%APP_HOME%\lib\ant-1.10.12.jar;%APP_HOME%\lib\jansi-1.18.jar;%APP_HOME%\lib\jline-2.14.6.jar;%APP_HOME%\lib\httpclient-4.5.13.jar;%APP_HOME%\lib\commons-codec-1.15.jar;%APP_HOME%\lib\plexus-component-api-1.0-alpha-33.jar;%APP_HOME%\lib\snakeyaml-1.30.jar;%APP_HOME%\lib\ant-launcher-1.10.12.jar;%APP_HOME%\lib\ant-antlr-1.10.12.jar;%APP_HOME%\lib\groovy-groovydoc-3.0.11.jar;%APP_HOME%\lib\spring-boot-loader-tools-2.7.0.jar;%APP_HOME%\lib\android-json-0.0.20131108.vaadin1.jar;%APP_HOME%\lib\jopt-simple-5.0.4.jar;%APP_HOME%\lib\maven-model-builder-3.8.3.jar;%APP_HOME%\lib\maven-model-3.8.3.jar;%APP_HOME%\lib\maven-settings-builder-3.6.3.jar;%APP_HOME%\lib\plexus-sec-dispatcher-1.4.jar;%APP_HOME%\lib\sisu-inject-plexus-2.6.0.jar;%APP_HOME%\lib\spring-core-5.3.20.jar;%APP_HOME%\lib\spring-security-crypto-5.7.1.jar;%APP_HOME%\lib\maven-repository-metadata-3.8.3.jar;%APP_HOME%\lib\maven-resolver-spi-1.8.0.jar;%APP_HOME%\lib\maven-resolver-util-1.8.0.jar;%APP_HOME%\lib\maven-resolver-api-1.8.0.jar;%APP_HOME%\lib\maven-settings-3.6.3.jar;%APP_HOME%\lib\org.eclipse.sisu.plexus-0.3.0.jar;%APP_HOME%\lib\maven-artifact-3.8.3.jar;%APP_HOME%\lib\plexus-utils-3.3.0.jar;%APP_HOME%\lib\javax.inject-1.jar;%APP_HOME%\lib\commons-lang3-3.12.0.jar;%APP_HOME%\lib\javax.annotation-api-1.3.2.jar;%APP_HOME%\lib\httpcore-4.4.15.jar;%APP_HOME%\lib\plexus-classworlds-2.5.2.jar;%APP_HOME%\lib\junit-3.8.1.jar;%APP_HOME%\lib\jakarta.inject-api-2.0.1.jar;%APP_HOME%\lib\jakarta.annotation-api-2.0.0.jar;%APP_HOME%\lib\commons-compress-1.21.jar;%APP_HOME%\lib\maven-builder-support-3.8.3.jar;%APP_HOME%\lib\plexus-interpolation-1.26.jar;%APP_HOME%\lib\plexus-cipher-1.4.jar;%APP_HOME%\lib\plexus-component-annotations-1.5.5.jar;%APP_HOME%\lib\spring-jcl-5.3.20.jar;%APP_HOME%\lib\org.eclipse.sisu.inject-0.3.5.jar


@rem Execute grails-shell
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %GRAILS_SHELL_OPTS%  -classpath "%CLASSPATH%" org.grails.cli.GrailsCli %*

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable GRAILS_SHELL_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%GRAILS_SHELL_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
