/*
 * Decompiled with CFR 0.152.
 */
package org.grails.buffer;

import groovy.lang.Writable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.grails.buffer.GrailsPrintWriter;
import org.grails.buffer.GrailsPrintWriterAdapter;
import org.grails.buffer.StreamCharBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.objenesis.ObjenesisStd;
import org.springframework.objenesis.instantiator.ObjectInstantiator;

public class GrailsRoutablePrintWriter
extends GrailsPrintWriterAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(GrailsRoutablePrintWriter.class);
    private DestinationFactory factory;
    private boolean blockFlush = true;
    private boolean blockClose = true;
    private boolean destinationActivated = false;
    private static ObjectInstantiator instantiator = null;

    public GrailsRoutablePrintWriter(DestinationFactory factory) {
        super(new NullWriter());
        this.factory = factory;
    }

    public static GrailsRoutablePrintWriter newInstance(DestinationFactory factory) {
        if (instantiator != null) {
            GrailsRoutablePrintWriter instance = (GrailsRoutablePrintWriter)instantiator.newInstance();
            instance.out = new NullWriter();
            instance.factory = factory;
            instance.blockFlush = true;
            instance.blockClose = true;
            return instance;
        }
        return new GrailsRoutablePrintWriter(factory);
    }

    protected void activateDestination() {
        if (!this.destinationActivated && this.factory != null) {
            try {
                super.setTarget(this.factory.activateDestination());
            }
            catch (IOException e) {
                this.setError();
            }
            this.destinationActivated = true;
        }
    }

    @Override
    public boolean isAllowUnwrappingOut() {
        return this.destinationActivated ? super.isAllowUnwrappingOut() : false;
    }

    @Override
    public Writer unwrap() {
        return this.destinationActivated ? super.unwrap() : this;
    }

    public void updateDestination(DestinationFactory f) {
        this.setDestinationActivated(false);
        this.factory = f;
    }

    @Override
    public void close() {
        if (!this.isBlockClose() && this.isDestinationActivated()) {
            super.close();
        }
    }

    @Override
    public void println(Object x) {
        this.activateDestination();
        super.println(x);
    }

    @Override
    public void println(String x) {
        this.activateDestination();
        super.println(x);
    }

    @Override
    public void println(char[] x) {
        this.activateDestination();
        super.println(x);
    }

    @Override
    public void println(double x) {
        this.activateDestination();
        super.println(x);
    }

    @Override
    public void println(float x) {
        this.activateDestination();
        super.println(x);
    }

    @Override
    public void println(long x) {
        this.activateDestination();
        super.println(x);
    }

    @Override
    public void println(int x) {
        this.activateDestination();
        super.println(x);
    }

    @Override
    public void println(char x) {
        this.activateDestination();
        super.println(x);
    }

    @Override
    public void println(boolean x) {
        this.activateDestination();
        super.println(x);
    }

    @Override
    public void println() {
        this.activateDestination();
        super.println();
    }

    @Override
    public void print(Object obj) {
        this.activateDestination();
        super.print(obj);
    }

    @Override
    public void print(String s) {
        this.activateDestination();
        super.print(s);
    }

    @Override
    public void print(char[] s) {
        this.activateDestination();
        super.print(s);
    }

    @Override
    public void print(double d) {
        this.activateDestination();
        super.print(d);
    }

    @Override
    public void print(float f) {
        this.activateDestination();
        super.print(f);
    }

    @Override
    public void print(long l) {
        this.activateDestination();
        super.print(l);
    }

    @Override
    public void print(int i) {
        this.activateDestination();
        super.print(i);
    }

    @Override
    public void print(char c) {
        this.activateDestination();
        super.print(c);
    }

    @Override
    public void print(boolean b) {
        this.activateDestination();
        super.print(b);
    }

    @Override
    public void write(String s) {
        this.activateDestination();
        super.write(s);
    }

    @Override
    public void write(String s, int off, int len) {
        this.activateDestination();
        super.write(s, off, len);
    }

    @Override
    public void write(char[] buf) {
        this.activateDestination();
        super.write(buf);
    }

    @Override
    public void write(char[] buf, int off, int len) {
        this.activateDestination();
        super.write(buf, off, len);
    }

    @Override
    public void write(int c) {
        this.activateDestination();
        super.write(c);
    }

    @Override
    public boolean checkError() {
        this.activateDestination();
        return super.checkError();
    }

    @Override
    public void flush() {
        if (!this.isBlockFlush() && this.isDestinationActivated()) {
            super.flush();
        }
    }

    @Override
    public PrintWriter append(char c) {
        this.activateDestination();
        return super.append(c);
    }

    @Override
    public PrintWriter append(CharSequence csq, int start, int end) {
        this.activateDestination();
        return super.append(csq, start, end);
    }

    @Override
    public PrintWriter append(CharSequence csq) {
        this.activateDestination();
        return super.append(csq);
    }

    public boolean isBlockFlush() {
        return this.blockFlush;
    }

    public void setBlockFlush(boolean blockFlush) {
        this.blockFlush = blockFlush;
    }

    public boolean isBlockClose() {
        return this.blockClose;
    }

    public void setBlockClose(boolean blockClose) {
        this.blockClose = blockClose;
    }

    public void unBlockFlushAndClose() {
        this.blockClose = false;
        this.blockFlush = false;
    }

    public void blockFlushAndClose() {
        this.blockClose = true;
        this.blockFlush = true;
    }

    @Override
    public GrailsPrintWriter leftShift(Object value) throws IOException {
        this.activateDestination();
        return super.leftShift(value);
    }

    @Override
    public GrailsPrintWriter leftShift(StreamCharBuffer otherBuffer) {
        this.activateDestination();
        return super.leftShift(otherBuffer);
    }

    @Override
    public GrailsPrintWriter leftShift(Writable writable) {
        this.activateDestination();
        return super.leftShift(writable);
    }

    public boolean isDestinationActivated() {
        return this.destinationActivated;
    }

    public void setDestinationActivated(boolean destinationActivated) {
        this.destinationActivated = destinationActivated;
        if (!this.destinationActivated) {
            super.setTarget(new NullWriter());
        }
    }

    static {
        try {
            instantiator = new ObjenesisStd(false).getInstantiatorOf(GrailsRoutablePrintWriter.class);
        }
        catch (Exception e) {
            LOG.debug("Couldn't get direct performance optimized instantiator for GrailsRoutablePrintWriter. Using default instantiation.", (Throwable)e);
        }
    }

    private static class NullWriter
    extends Writer {
        protected NullWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void flush() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    public static interface DestinationFactory {
        public Writer activateDestination() throws IOException;
    }
}

