/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import groovy.transform.PackageScope;
import io.micronaut.ast.groovy.annotation.GroovyAnnotationMetadataBuilder;
import io.micronaut.ast.groovy.utils.AstAnnotationUtils;
import io.micronaut.ast.groovy.visitor.GroovyClassElement;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.MemberElement;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;

public abstract class AbstractGroovyElement
implements AnnotationMetadataDelegate,
Element {
    private static final Pattern JAVADOC_PATTERN = Pattern.compile("(/\\s*\\*\\*)|\\s*\\*|(\\s*[*/])");
    protected final SourceUnit sourceUnit;
    protected final CompilationUnit compilationUnit;
    protected final GroovyVisitorContext visitorContext;
    private final AnnotatedNode annotatedNode;
    private AnnotationMetadata annotationMetadata;

    protected AbstractGroovyElement(GroovyVisitorContext visitorContext, AnnotatedNode annotatedNode, AnnotationMetadata annotationMetadata) {
        this.visitorContext = visitorContext;
        this.compilationUnit = visitorContext.getCompilationUnit();
        this.annotatedNode = annotatedNode;
        this.annotationMetadata = annotationMetadata;
        this.sourceUnit = visitorContext.getSourceUnit();
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    public boolean isPackagePrivate() {
        return this.hasDeclaredAnnotation(PackageScope.class);
    }

    public <T extends Annotation> Element annotate(@NonNull String annotationType, @NonNull Consumer<AnnotationValueBuilder<T>> consumer) {
        ArgumentUtils.requireNonNull((String)"annotationType", (Object)annotationType);
        AnnotationValueBuilder builder = AnnotationValue.builder((String)annotationType);
        if (consumer != null) {
            consumer.accept(builder);
            AnnotationValue av = builder.build();
            this.annotationMetadata = new GroovyAnnotationMetadataBuilder(this.sourceUnit, this.compilationUnit).annotate(this.annotationMetadata, av);
            this.updateAnnotationCaches();
        }
        return this;
    }

    public <T extends Annotation> Element annotate(AnnotationValue<T> annotationValue) {
        ArgumentUtils.requireNonNull((String)"annotationValue", annotationValue);
        this.annotationMetadata = new GroovyAnnotationMetadataBuilder(this.sourceUnit, this.compilationUnit).annotate(this.annotationMetadata, annotationValue);
        this.updateAnnotationCaches();
        return this;
    }

    public Element removeAnnotation(@NonNull String annotationType) {
        ArgumentUtils.requireNonNull((String)"annotationType", (Object)annotationType);
        this.annotationMetadata = new GroovyAnnotationMetadataBuilder(this.sourceUnit, this.compilationUnit).removeAnnotation(this.annotationMetadata, annotationType);
        this.updateAnnotationCaches();
        return this;
    }

    public <T extends Annotation> Element removeAnnotationIf(@NonNull Predicate<AnnotationValue<T>> predicate) {
        ArgumentUtils.requireNonNull((String)"predicate", predicate);
        this.annotationMetadata = new GroovyAnnotationMetadataBuilder(this.sourceUnit, this.compilationUnit).removeAnnotationIf(this.annotationMetadata, predicate);
        this.updateAnnotationCaches();
        return this;
    }

    public Element removeStereotype(@NonNull String annotationType) {
        ArgumentUtils.requireNonNull((String)"annotationType", (Object)annotationType);
        this.annotationMetadata = new GroovyAnnotationMetadataBuilder(this.sourceUnit, this.compilationUnit).removeStereotype(this.annotationMetadata, annotationType);
        this.updateAnnotationCaches();
        return this;
    }

    private void updateAnnotationCaches() {
        String declaringTypeName = this instanceof MemberElement ? ((MemberElement)this).getOwningType().getName() : this.getName();
        AbstractAnnotationMetadataBuilder.addMutatedMetadata((String)declaringTypeName, (Object)this.annotatedNode, (AnnotationMetadata)this.annotationMetadata);
        AstAnnotationUtils.invalidateCache(this.annotatedNode);
    }

    protected Map<String, ClassNode> alignNewGenericsInfo(@NonNull GenericsType[] genericsTypes, @NonNull GenericsType[] redirectTypes, @NonNull Map<String, ClassNode> genericsSpec) {
        if (redirectTypes == null || redirectTypes.length != genericsTypes.length) {
            return Collections.emptyMap();
        }
        HashMap<String, ClassNode> newSpec = new HashMap<String, ClassNode>(genericsSpec.size());
        for (int i = 0; i < genericsTypes.length; ++i) {
            GenericsType genericsType = genericsTypes[i];
            GenericsType redirectType = redirectTypes[i];
            String name = genericsType.getName();
            if (genericsType.isWildcard()) {
                Object[] upperBounds = genericsType.getUpperBounds();
                if (ArrayUtils.isNotEmpty((Object[])upperBounds)) {
                    name = upperBounds[0].getUnresolvedName();
                } else {
                    ClassNode lowerBound = genericsType.getLowerBound();
                    if (lowerBound != null) {
                        name = lowerBound.getUnresolvedName();
                    }
                }
                ClassNode cn = this.resolveGenericPlaceholder(genericsSpec, name);
                this.toNewGenericSpec(genericsSpec, newSpec, redirectType.getName(), cn);
                continue;
            }
            ClassNode classNode = genericsType.getType();
            Object[] typeParameters = classNode.getGenericsTypes();
            if (ArrayUtils.isNotEmpty((Object[])typeParameters)) {
                GenericsType[] redirectParameters = classNode.redirect().getGenericsTypes();
                if (redirectParameters != null && typeParameters.length == redirectParameters.length) {
                    ArrayList<ClassNode> resolvedTypes = new ArrayList<ClassNode>(typeParameters.length);
                    for (int j = 0; j < redirectParameters.length; ++j) {
                        ClassNode type = typeParameters[j].getType();
                        if (type.isGenericsPlaceHolder()) {
                            String unresolvedName = type.getUnresolvedName();
                            ClassNode resolvedType = this.resolveGenericPlaceholder(genericsSpec, unresolvedName);
                            if (resolvedType != null) {
                                resolvedTypes.add(resolvedType);
                                continue;
                            }
                            resolvedTypes.add(type);
                            continue;
                        }
                        resolvedTypes.add(type);
                    }
                    ClassNode plainNodeReference = classNode.getPlainNodeReference();
                    plainNodeReference.setUsingGenerics(true);
                    plainNodeReference.setGenericsTypes((GenericsType[])resolvedTypes.stream().map(GenericsType::new).toArray(GenericsType[]::new));
                    newSpec.put(redirectType.getName(), plainNodeReference);
                    continue;
                }
                ClassNode cn = this.resolveGenericPlaceholder(genericsSpec, name);
                if (cn != null) {
                    newSpec.put(redirectType.getName(), cn);
                    continue;
                }
                newSpec.put(redirectType.getName(), classNode);
                continue;
            }
            ClassNode cn = this.resolveGenericPlaceholder(genericsSpec, name);
            this.toNewGenericSpec(genericsSpec, newSpec, redirectType.getName(), cn);
        }
        return newSpec;
    }

    @Nullable
    private ClassNode resolveGenericPlaceholder(@NonNull Map<String, ClassNode> genericsSpec, String name) {
        ClassNode cn;
        ClassNode classNode = genericsSpec.get(name);
        while (classNode != null && classNode.isGenericsPlaceHolder() && (cn = genericsSpec.get(classNode.getUnresolvedName())) != classNode && cn != null) {
            classNode = cn;
        }
        return classNode;
    }

    private void toNewGenericSpec(Map<String, ClassNode> genericsSpec, Map<String, ClassNode> newSpec, String name, ClassNode cn) {
        if (cn != null) {
            if (cn.isGenericsPlaceHolder()) {
                String n = cn.getUnresolvedName();
                ClassNode resolved = this.resolveGenericPlaceholder(genericsSpec, n);
                if (resolved == cn) {
                    newSpec.put(name, cn);
                } else {
                    this.toNewGenericSpec(genericsSpec, newSpec, name, resolved);
                }
            } else {
                newSpec.put(name, cn);
            }
        }
    }

    @NonNull
    protected ClassElement getGenericElement(@NonNull SourceUnit sourceUnit, @NonNull ClassNode type, @NonNull ClassElement rawElement, @NonNull Map<String, ClassNode> genericsSpec) {
        if (CollectionUtils.isNotEmpty(genericsSpec)) {
            ClassElement classNode = this.resolveGenericType(genericsSpec, type);
            if (classNode != null) {
                return classNode;
            }
            GenericsType[] genericsTypes = type.getGenericsTypes();
            GenericsType[] redirectTypes = type.redirect().getGenericsTypes();
            if (genericsTypes != null && redirectTypes != null) {
                genericsSpec = this.alignNewGenericsInfo(genericsTypes, redirectTypes, genericsSpec);
                return new GroovyClassElement(this.visitorContext, type, this.annotationMetadata, Collections.singletonMap(type.getName(), genericsSpec), 0);
            }
        }
        return rawElement;
    }

    private ClassElement resolveGenericType(Map<String, ClassNode> typeGenericInfo, ClassNode returnType) {
        String unresolvedName;
        ClassNode classNode;
        ClassNode componentType;
        if (returnType.isGenericsPlaceHolder()) {
            String unresolvedName2 = returnType.getUnresolvedName();
            ClassNode classNode2 = this.resolveGenericPlaceholder(typeGenericInfo, unresolvedName2);
            if (classNode2 != null) {
                if (classNode2.isGenericsPlaceHolder() && classNode2 != returnType) {
                    return this.resolveGenericType(typeGenericInfo, classNode2);
                }
                AnnotationMetadata annotationMetadata = this.resolveAnnotationMetadata(classNode2);
                return this.visitorContext.getElementFactory().newClassElement(classNode2, annotationMetadata);
            }
        } else if (returnType.isArray() && (componentType = returnType.getComponentType()).isGenericsPlaceHolder() && (classNode = this.resolveGenericPlaceholder(typeGenericInfo, unresolvedName = componentType.getUnresolvedName())) != null) {
            if (classNode.isGenericsPlaceHolder() && classNode != returnType) {
                return this.resolveGenericType(typeGenericInfo, classNode);
            }
            ClassNode cn = classNode.makeArray();
            AnnotationMetadata annotationMetadata = this.resolveAnnotationMetadata(cn);
            return this.visitorContext.getElementFactory().newClassElement(cn, annotationMetadata);
        }
        return null;
    }

    public Optional<String> getDocumentation() {
        if (this.annotatedNode.getGroovydoc() == null || this.annotatedNode.getGroovydoc().getContent() == null) {
            return Optional.empty();
        }
        return Optional.of(JAVADOC_PATTERN.matcher(this.annotatedNode.getGroovydoc().getContent()).replaceAll("").trim());
    }

    @NonNull
    protected AnnotationMetadata resolveAnnotationMetadata(@NonNull ClassNode type) {
        AnnotationMetadata annotationMetadata = this.visitorContext.getConfiguration().includeTypeLevelAnnotationsInGenericArguments() ? AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)type) : AnnotationMetadata.EMPTY_METADATA;
        return annotationMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractGroovyElement that = (AbstractGroovyElement)o;
        return this.annotatedNode.equals(that.annotatedNode);
    }

    public int hashCode() {
        return Objects.hash(this.annotatedNode);
    }

    protected Set<ElementModifier> resolveModifiers(MethodNode methodNode) {
        return this.resolveModifiers(methodNode.getModifiers());
    }

    protected Set<ElementModifier> resolveModifiers(FieldNode fieldNode) {
        return this.resolveModifiers(fieldNode.getModifiers());
    }

    protected Set<ElementModifier> resolveModifiers(ClassNode classNode) {
        return this.resolveModifiers(classNode.getModifiers());
    }

    private Set<ElementModifier> resolveModifiers(int mod) {
        HashSet<ElementModifier> modifiers = new HashSet<ElementModifier>(5);
        if (Modifier.isPrivate(mod)) {
            modifiers.add(ElementModifier.PRIVATE);
        } else if (Modifier.isProtected(mod)) {
            modifiers.add(ElementModifier.PROTECTED);
        } else if (Modifier.isPublic(mod)) {
            modifiers.add(ElementModifier.PUBLIC);
        }
        if (Modifier.isAbstract(mod)) {
            modifiers.add(ElementModifier.ABSTRACT);
        } else if (Modifier.isStatic(mod)) {
            modifiers.add(ElementModifier.STATIC);
        }
        if (Modifier.isFinal(mod)) {
            modifiers.add(ElementModifier.FINAL);
        }
        return modifiers;
    }
}

