/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugins;

import grails.core.ArtefactHandler;
import grails.core.GrailsApplication;
import grails.core.support.GrailsApplicationAware;
import grails.core.support.ParentApplicationContextAware;
import grails.plugins.GrailsPlugin;
import grails.plugins.GrailsPluginManager;
import grails.plugins.Plugin;
import grails.plugins.exceptions.PluginException;
import grails.spring.BeanBuilder;
import grails.util.CollectionUtils;
import grails.util.Environment;
import grails.util.GrailsArrayUtils;
import grails.util.GrailsClassUtils;
import grails.util.GrailsUtil;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.grails.core.io.CachingPathMatchingResourcePatternResolver;
import org.grails.core.io.SpringResource;
import org.grails.io.support.Resource;
import org.grails.plugins.AbstractGrailsPlugin;
import org.grails.plugins.support.WatchPattern;
import org.grails.plugins.support.WatchPatternParser;
import org.grails.spring.RuntimeSpringConfiguration;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.filter.TypeFilter;

public class DefaultGrailsPlugin
extends AbstractGrailsPlugin
implements ParentApplicationContextAware {
    private static final String PLUGIN_CHANGE_EVENT_CTX = "ctx";
    private static final String PLUGIN_CHANGE_EVENT_APPLICATION = "application";
    private static final String PLUGIN_CHANGE_EVENT_PLUGIN = "plugin";
    private static final String PLUGIN_CHANGE_EVENT_SOURCE = "source";
    private static final String PLUGIN_CHANGE_EVENT_MANAGER = "manager";
    protected static final Log LOG = LogFactory.getLog(DefaultGrailsPlugin.class);
    private static final String INCLUDES = "includes";
    private static final String EXCLUDES = "excludes";
    private AbstractGrailsPlugin.GrailsPluginClass pluginGrailsClass;
    private GroovyObject plugin;
    protected BeanWrapper pluginBean;
    private Closure onChangeListener;
    private org.springframework.core.io.Resource[] watchedResources = new org.springframework.core.io.Resource[0];
    private PathMatchingResourcePatternResolver resolver;
    private String[] watchedResourcePatternReferences;
    private String[] loadAfterNames = new String[0];
    private String[] loadBeforeNames = new String[0];
    private String status = "enabled";
    private String[] observedPlugins;
    private Closure onConfigChangeListener;
    private Closure onShutdownListener;
    private Class<?>[] providedArtefacts = new Class[0];
    private Collection profiles = null;
    private Map pluginEnvs;
    private List<String> pluginExcludes = new ArrayList<String>();
    private Collection<? extends TypeFilter> typeFilters = new ArrayList<TypeFilter>();
    private org.springframework.core.io.Resource pluginDescriptor;
    private List<WatchPattern> watchedResourcePatterns;

    public DefaultGrailsPlugin(Class<?> pluginClass, org.springframework.core.io.Resource resource, GrailsApplication application) {
        super(pluginClass, application);
        this.dependencies = Collections.emptyMap();
        this.pluginDescriptor = resource;
        this.resolver = CachingPathMatchingResourcePatternResolver.INSTANCE;
        try {
            this.initialisePlugin(pluginClass);
        }
        catch (Throwable e) {
            throw new PluginException("Error initialising plugin for class [" + pluginClass.getName() + "]:" + e.getMessage(), e);
        }
    }

    @Override
    public boolean isEnabled(String[] activeProfiles) {
        if (this.profiles == null) {
            return true;
        }
        for (String activeProfile : activeProfiles) {
            if (!this.profiles.contains(activeProfile)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        if (this.plugin instanceof ApplicationContextAware) {
            ((ApplicationContextAware)this.plugin).setApplicationContext(applicationContext);
        }
        if (this.plugin instanceof ApplicationListener) {
            ((ConfigurableApplicationContext)applicationContext).addApplicationListener((ApplicationListener)this.plugin);
        }
    }

    @Override
    public List<WatchPattern> getWatchedResourcePatterns() {
        return this.watchedResourcePatterns;
    }

    @Override
    public boolean hasInterestInChange(String path) {
        if (this.watchedResourcePatterns != null) {
            for (WatchPattern watchedResourcePattern : this.watchedResourcePatterns) {
                if (!watchedResourcePattern.matchesPath(path)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setManager(GrailsPluginManager manager) {
        super.setManager(manager);
        if (this.plugin instanceof Plugin) {
            ((Plugin)this.plugin).setPluginManager(manager);
        }
    }

    private void initialisePlugin(Class<?> clazz) {
        this.pluginGrailsClass = new AbstractGrailsPlugin.GrailsPluginClass(this, clazz);
        this.plugin = (GroovyObject)this.pluginGrailsClass.newInstance();
        if (this.plugin instanceof Plugin) {
            Plugin p = (Plugin)this.plugin;
            p.setApplicationContext(this.applicationContext);
            p.setPlugin(this);
            p.setGrailsApplication(this.grailsApplication);
            p.setPluginManager(this.manager);
        } else if (this.plugin instanceof GrailsApplicationAware) {
            ((GrailsApplicationAware)this.plugin).setGrailsApplication(this.grailsApplication);
        }
        this.pluginBean = new BeanWrapperImpl((Object)this.plugin);
        this.evaluatePluginVersion();
        this.evaluatePluginDependencies();
        this.evaluatePluginLoadAfters();
        this.evaluateProvidedArtefacts();
        this.evaluatePluginEvictionPolicy();
        this.evaluateOnChangeListener();
        this.evaluateObservedPlugins();
        this.evaluatePluginStatus();
        this.evaluatePluginScopes();
        this.evaluatePluginExcludes();
        this.evaluateTypeFilters();
    }

    private void evaluateTypeFilters() {
        Object result = GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.plugin, "typeFilters");
        if (result instanceof List) {
            this.typeFilters = (List)result;
        }
    }

    private void evaluatePluginExcludes() {
        Object result = GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.plugin, "pluginExcludes");
        if (result instanceof List) {
            this.pluginExcludes = (List)result;
        }
    }

    private void evaluatePluginScopes() {
        this.pluginEnvs = this.evaluateIncludeExcludeProperty("environments", new Closure(this){
            private static final long serialVersionUID = 1L;

            public Object call(Object arguments) {
                String envName = (String)arguments;
                Environment env = Environment.getEnvironment((String)envName);
                if (env != null) {
                    return env.getName();
                }
                return arguments;
            }
        });
    }

    private Map evaluateIncludeExcludeProperty(String name, Closure converter) {
        HashMap resultMap = new HashMap();
        Object propertyValue = GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.plugin, name);
        if (propertyValue instanceof Map) {
            Map containedMap = (Map)propertyValue;
            Object includes = containedMap.get(INCLUDES);
            this.evaluateAndAddIncludeExcludeObject(resultMap, includes, true, converter);
            Object excludes = containedMap.get(EXCLUDES);
            this.evaluateAndAddIncludeExcludeObject(resultMap, excludes, false, converter);
        } else {
            this.evaluateAndAddIncludeExcludeObject(resultMap, propertyValue, true, converter);
        }
        return resultMap;
    }

    private void evaluateAndAddIncludeExcludeObject(Map targetMap, Object includeExcludeObject, boolean include, Closure converter) {
        if (includeExcludeObject instanceof String) {
            String includeExcludeString = (String)includeExcludeObject;
            this.evaluateAndAddToIncludeExcludeSet(targetMap, includeExcludeString, include, converter);
        } else if (includeExcludeObject instanceof List) {
            List includeExcludeList = (List)includeExcludeObject;
            this.evaluateAndAddListOfValues(targetMap, includeExcludeList, include, converter);
        }
    }

    private void evaluateAndAddListOfValues(Map targetMap, List includeExcludeList, boolean include, Closure converter) {
        for (Object value : includeExcludeList) {
            if (!(value instanceof String)) continue;
            String scopeName = (String)value;
            this.evaluateAndAddToIncludeExcludeSet(targetMap, scopeName, include, converter);
        }
    }

    private void evaluateAndAddToIncludeExcludeSet(Map targetMap, String includeExcludeString, boolean include, Closure converter) {
        Set set = this.lazilyCreateIncludeOrExcludeSet(targetMap, include);
        set.add(converter.call((Object)includeExcludeString));
    }

    private Set lazilyCreateIncludeOrExcludeSet(Map targetMap, boolean include) {
        String key = include ? INCLUDES : EXCLUDES;
        HashSet set = (HashSet)targetMap.get(key);
        if (set == null) {
            set = new HashSet();
            targetMap.put(key, set);
        }
        return set;
    }

    private void evaluateProvidedArtefacts() {
        Object result = GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.pluginBean, this.plugin, "providedArtefacts");
        if (result instanceof Collection) {
            Collection artefactList = (Collection)result;
            this.providedArtefacts = artefactList.toArray(new Class[artefactList.size()]);
        }
    }

    private void evaluateProfiles() {
        Object result = GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.pluginBean, this.plugin, "profiles");
        if (result instanceof Collection) {
            this.profiles = (Collection)result;
        }
    }

    public DefaultGrailsPlugin(Class<?> pluginClass, GrailsApplication application) {
        this(pluginClass, null, application);
    }

    private void evaluateObservedPlugins() {
        Object observeProperty;
        if (this.pluginBean.isReadableProperty("observe") && (observeProperty = GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.pluginBean, this.plugin, "observe")) instanceof Collection) {
            Collection observeList = (Collection)observeProperty;
            this.observedPlugins = new String[observeList.size()];
            int j = 0;
            for (Object anObserveList : observeList) {
                String pluginName = anObserveList.toString();
                this.observedPlugins[j++] = pluginName;
            }
        }
        if (this.observedPlugins == null) {
            this.observedPlugins = new String[0];
        }
    }

    private void evaluatePluginStatus() {
        if (!this.pluginBean.isReadableProperty("status")) {
            return;
        }
        Object statusObj = GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.plugin, "status");
        if (statusObj != null) {
            this.status = statusObj.toString().toLowerCase();
        }
    }

    private void evaluateOnChangeListener() {
        block14: {
            if (this.pluginBean.isReadableProperty("onShutdown")) {
                this.onShutdownListener = (Closure)GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.plugin, "onShutdown");
            }
            if (this.pluginBean.isReadableProperty("onConfigChange")) {
                this.onConfigChangeListener = (Closure)GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.plugin, "onConfigChange");
            }
            if (this.pluginBean.isReadableProperty("onChange")) {
                this.onChangeListener = (Closure)GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.plugin, "onChange");
            }
            Environment env = Environment.getCurrent();
            boolean warDeployed = env.isWarDeployed();
            boolean reloadEnabled = env.isReloadEnabled();
            if (!reloadEnabled && warDeployed) {
                return;
            }
            Object referencedResources = GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.plugin, "watchedResources");
            try {
                List<String> resourceList = null;
                if (referencedResources instanceof String) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Configuring plugin " + this + " to watch resources with pattern: " + referencedResources));
                    }
                    resourceList = Collections.singletonList(referencedResources.toString());
                } else if (referencedResources instanceof List) {
                    resourceList = (List<String>)referencedResources;
                }
                if (resourceList == null) {
                    return;
                }
                ArrayList<String> resourceListTmp = new ArrayList<String>();
                String baseLocation = env.getReloadLocation();
                for (String ref : resourceList) {
                    String stringRef = ref.toString();
                    if (warDeployed) {
                        this.addBaseLocationPattern(resourceListTmp, baseLocation, stringRef);
                        continue;
                    }
                    this.addBaseLocationPattern(resourceListTmp, baseLocation, stringRef);
                }
                this.watchedResourcePatternReferences = new String[resourceListTmp.size()];
                for (int i = 0; i < this.watchedResourcePatternReferences.length; ++i) {
                    String resRef;
                    this.watchedResourcePatternReferences[i] = resRef = (String)resourceListTmp.get(i);
                }
                this.watchedResourcePatterns = new WatchPatternParser().getWatchPatterns(Arrays.asList(this.watchedResourcePatternReferences));
            }
            catch (IllegalArgumentException e) {
                if (!GrailsUtil.isDevelopmentEnv()) break block14;
                LOG.debug((Object)("Cannot load plug-in resource watch list from [" + GrailsArrayUtils.toString(this.watchedResourcePatternReferences) + "]. This means that the plugin " + this + ", will not be able to auto-reload changes effectively. Try running grails upgrade.: " + e.getMessage()));
            }
        }
    }

    private void addBaseLocationPattern(List<String> resourceList, String baseLocation, String pattern) {
        resourceList.add(baseLocation == null ? pattern : this.getResourcePatternForBaseLocation(baseLocation, pattern));
    }

    private String getResourcePatternForBaseLocation(String baseLocation, String resourcePath) {
        Object location = baseLocation;
        if (!((String)location).endsWith(File.separator)) {
            location = (String)location + File.separator;
        }
        if (resourcePath.startsWith("./")) {
            return "file:" + (String)location + resourcePath.substring(2);
        }
        if (resourcePath.startsWith("file:./")) {
            return "file:" + (String)location + resourcePath.substring(7);
        }
        return resourcePath;
    }

    private void evaluatePluginVersion() {
        if (!this.pluginBean.isReadableProperty("version")) {
            throw new PluginException("Plugin [" + this.getName() + "] must specify a version!");
        }
        Object vobj = this.plugin.getProperty("version");
        if (vobj == null) {
            throw new PluginException("Plugin " + this + " must specify a version. eg: def version = 0.1");
        }
        this.version = vobj.toString();
    }

    private void evaluatePluginEvictionPolicy() {
        if (!this.pluginBean.isReadableProperty("evict")) {
            return;
        }
        List pluginsToEvict = (List)GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.pluginBean, this.plugin, "evict");
        if (pluginsToEvict == null) {
            return;
        }
        this.evictionList = new String[pluginsToEvict.size()];
        int index = 0;
        for (Object o : pluginsToEvict) {
            this.evictionList[index++] = o == null ? "" : o.toString();
        }
    }

    private void evaluatePluginLoadAfters() {
        List loadBeforeNamesList;
        List loadAfterNamesList;
        if (this.pluginBean.isReadableProperty("loadAfter") && (loadAfterNamesList = (List)GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.pluginBean, this.plugin, "loadAfter")) != null) {
            this.loadAfterNames = loadAfterNamesList.toArray(new String[loadAfterNamesList.size()]);
        }
        if (this.pluginBean.isReadableProperty("loadBefore") && (loadBeforeNamesList = (List)GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.pluginBean, this.plugin, "loadBefore")) != null) {
            this.loadBeforeNames = loadBeforeNamesList.toArray(new String[loadBeforeNamesList.size()]);
        }
    }

    private void evaluatePluginDependencies() {
        if (!this.pluginBean.isReadableProperty("dependsOn")) {
            return;
        }
        this.dependencies = (Map)GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(this.pluginBean, this.plugin, "dependsOn");
        this.dependencyNames = this.dependencies.keySet().toArray(new String[this.dependencies.size()]);
    }

    @Override
    public String[] getLoadAfterNames() {
        return this.loadAfterNames;
    }

    @Override
    public String[] getLoadBeforeNames() {
        return this.loadBeforeNames;
    }

    public PathMatchingResourcePatternResolver getResolver() {
        return this.resolver;
    }

    public ApplicationContext getParentCtx() {
        return this.grailsApplication.getParentContext();
    }

    public BeanBuilder beans(Closure closure) {
        BeanBuilder bb = new BeanBuilder(this.getParentCtx(), (ClassLoader)new GroovyClassLoader(this.grailsApplication.getClassLoader()));
        bb.invokeMethod("beans", (Object)new Object[]{closure});
        return bb;
    }

    @Override
    public void doWithApplicationContext(ApplicationContext ctx) {
        if (this.plugin instanceof Plugin) {
            Plugin pluginObject = (Plugin)this.plugin;
            pluginObject.setApplicationContext(ctx);
            pluginObject.doWithApplicationContext();
        } else {
            Object[] args = new Object[]{ctx};
            this.invokePluginHook("doWithApplicationContext", args, ctx);
        }
    }

    private void invokePluginHook(String methodName, Object[] args, ApplicationContext ctx) {
        if (this.pluginBean.isReadableProperty(methodName)) {
            Closure c = (Closure)this.plugin.getProperty(methodName);
            c.setDelegate((Object)this);
            c.call(args);
        } else {
            MetaClass pluginMetaClass = this.pluginGrailsClass.getMetaClass();
            if (!pluginMetaClass.respondsTo((Object)this.plugin, methodName, args).isEmpty()) {
                pluginMetaClass.invokeMethod((Object)this.plugin, methodName, (Object)ctx);
            }
        }
    }

    @Override
    public void doWithRuntimeConfiguration(RuntimeSpringConfiguration springConfig) {
        Binding b = new Binding();
        b.setVariable(PLUGIN_CHANGE_EVENT_APPLICATION, (Object)this.grailsApplication);
        b.setVariable("grailsApplication", (Object)this.grailsApplication);
        b.setVariable(PLUGIN_CHANGE_EVENT_MANAGER, (Object)this.getManager());
        b.setVariable(PLUGIN_CHANGE_EVENT_PLUGIN, (Object)this);
        b.setVariable("parentCtx", (Object)this.getParentCtx());
        b.setVariable("resolver", (Object)this.getResolver());
        if (this.plugin instanceof Plugin) {
            Closure c = ((Plugin)this.plugin).doWithSpring();
            if (c != null) {
                BeanBuilder bb = new BeanBuilder(this.getParentCtx(), springConfig, this.grailsApplication.getClassLoader());
                bb.setBinding(b);
                c.setDelegate((Object)bb);
                c.setResolveStrategy(0);
                bb.invokeMethod("beans", (Object)new Object[]{c});
            }
        } else {
            if (!this.pluginBean.isReadableProperty("doWithSpring")) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Plugin " + this + " is participating in Spring configuration..."));
            }
            Closure c = (Closure)this.plugin.getProperty("doWithSpring");
            BeanBuilder bb = new BeanBuilder(this.getParentCtx(), springConfig, this.grailsApplication.getClassLoader());
            bb.setBinding(b);
            c.setDelegate((Object)bb);
            c.setResolveStrategy(1);
            bb.invokeMethod("beans", (Object)new Object[]{c});
        }
    }

    @Override
    public String getName() {
        return this.pluginGrailsClass.getLogicalPropertyName();
    }

    private void addExcludeRuleInternal(Map map, Object o) {
        Collection includes;
        ArrayList<Object> excludes = (ArrayList<Object>)map.get(EXCLUDES);
        if (excludes == null) {
            excludes = new ArrayList<Object>();
            map.put(EXCLUDES, excludes);
        }
        if ((includes = (Collection)map.get(INCLUDES)) != null) {
            includes.remove(o);
        }
        excludes.add(o);
    }

    @Override
    public void addExclude(Environment env) {
        this.addExcludeRuleInternal(this.pluginEnvs, env);
    }

    @Override
    public boolean supportsEnvironment(Environment environment) {
        return this.supportsValueInIncludeExcludeMap(this.pluginEnvs, environment.getName());
    }

    @Override
    public boolean supportsCurrentScopeAndEnvironment() {
        Environment e = Environment.getCurrent();
        return this.supportsEnvironment(e);
    }

    private boolean supportsValueInIncludeExcludeMap(Map includeExcludeMap, Object value) {
        if (includeExcludeMap.isEmpty()) {
            return true;
        }
        Set includes = (Set)includeExcludeMap.get(INCLUDES);
        if (includes != null) {
            return includes.contains(value);
        }
        Set excludes = (Set)includeExcludeMap.get(EXCLUDES);
        return excludes == null || !excludes.contains(value);
    }

    @Override
    @Deprecated
    public void doc(String text) {
    }

    @Override
    public String[] getDependencyNames() {
        return this.dependencyNames;
    }

    public org.springframework.core.io.Resource[] getWatchedResources() {
        if (this.watchedResources.length == 0 && this.watchedResourcePatternReferences != null) {
            for (String resourcesReference : this.watchedResourcePatternReferences) {
                try {
                    org.springframework.core.io.Resource[] resources = this.resolver.getResources(resourcesReference);
                    if (resources.length <= 0) continue;
                    this.watchedResources = (org.springframework.core.io.Resource[])GrailsArrayUtils.addAll(this.watchedResources, resources);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.watchedResources;
    }

    @Override
    public String getDependentVersion(String name) {
        Object dependentVersion = this.dependencies.get(name);
        if (dependentVersion == null) {
            throw new PluginException("Plugin [" + this.getName() + "] referenced dependency [" + name + "] with no version!");
        }
        return dependentVersion.toString();
    }

    public String toString() {
        return "[" + this.getName() + ":" + this.getVersion() + "]";
    }

    public void setWatchedResources(org.springframework.core.io.Resource[] watchedResources) throws IOException {
        this.watchedResources = watchedResources;
    }

    public Log getLog() {
        return LOG;
    }

    public GrailsPlugin getPlugin() {
        return this;
    }

    @Override
    public void setParentApplicationContext(ApplicationContext parent) {
    }

    @Override
    public void refresh() {
        Resource descriptor = this.getDescriptor();
        if (this.grailsApplication == null || descriptor == null) {
            return;
        }
        ClassLoader parent = this.grailsApplication.getClassLoader();
        GroovyClassLoader gcl = new GroovyClassLoader(parent);
        try {
            this.initialisePlugin(gcl.parseClass(descriptor.getFile()));
        }
        catch (Exception e) {
            LOG.error((Object)("Error refreshing plugin: " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public GroovyObject getInstance() {
        return this.plugin;
    }

    @Override
    public void doWithDynamicMethods(ApplicationContext ctx) {
        if (this.plugin instanceof Plugin) {
            ((Plugin)this.plugin).doWithDynamicMethods();
        } else {
            Object[] args = new Object[]{ctx};
            this.invokePluginHook("doWithDynamicMethods", args, ctx);
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.plugin instanceof Plugin) {
            return ((Plugin)this.plugin).isEnabled();
        }
        return "enabled".equals(this.status);
    }

    @Override
    public String[] getObservedPluginNames() {
        return this.observedPlugins;
    }

    @Override
    public void notifyOfEvent(Map event) {
        if (this.plugin instanceof Plugin) {
            ((Plugin)this.plugin).onChange(event);
        } else if (this.onChangeListener != null) {
            this.invokeOnChangeListener(event);
        }
    }

    @Override
    public Map notifyOfEvent(int eventKind, Object source) {
        Map event = CollectionUtils.newMap((Object[])new Object[]{PLUGIN_CHANGE_EVENT_SOURCE, source, PLUGIN_CHANGE_EVENT_PLUGIN, this.plugin, PLUGIN_CHANGE_EVENT_APPLICATION, this.grailsApplication, PLUGIN_CHANGE_EVENT_MANAGER, this.getManager(), PLUGIN_CHANGE_EVENT_CTX, this.applicationContext});
        switch (eventKind) {
            case 0: {
                if (this.plugin instanceof Plugin) {
                    ((Plugin)this.plugin).onChange(event);
                } else {
                    this.notifyOfEvent(event);
                }
                this.getManager().informObservers(this.getName(), event);
                break;
            }
            case 2: {
                if (this.plugin instanceof Plugin) {
                    ((Plugin)this.plugin).onShutdown(event);
                    break;
                }
                this.invokeOnShutdownEventListener(event);
                break;
            }
            case 1: {
                if (this.plugin instanceof Plugin) {
                    ((Plugin)this.plugin).onConfigChange(event);
                    break;
                }
                this.invokeOnConfigChangeListener(event);
                break;
            }
            default: {
                this.notifyOfEvent(event);
            }
        }
        return event;
    }

    private void invokeOnShutdownEventListener(Map event) {
        this.callEvent(this.onShutdownListener, event);
    }

    private void invokeOnConfigChangeListener(Map event) {
        this.callEvent(this.onConfigChangeListener, event);
    }

    private void callEvent(Closure closureHook, Map event) {
        if (closureHook == null) {
            return;
        }
        closureHook.setDelegate((Object)this);
        closureHook.call(new Object[]{event});
    }

    private void invokeOnChangeListener(Map event) {
        this.onChangeListener.setDelegate((Object)this);
        this.onChangeListener.call(new Object[]{event});
        if (!(this.applicationContext instanceof GenericApplicationContext)) {
            return;
        }
        GenericApplicationContext ctx = (GenericApplicationContext)this.applicationContext;
        ConfigurableListableBeanFactory beanFactory = ctx.getBeanFactory();
        for (BeanFactoryPostProcessor postProcessor : ctx.getBeanFactoryPostProcessors()) {
            try {
                postProcessor.postProcessBeanFactory(beanFactory);
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    @Override
    public void doArtefactConfiguration() {
        if (!this.pluginBean.isReadableProperty("artefacts")) {
            return;
        }
        List l = this.plugin instanceof Plugin ? ((Plugin)this.plugin).getArtefacts() : (List)this.plugin.getProperty("artefacts");
        for (Object artefact : l) {
            if (artefact instanceof Class) {
                Class artefactClass = (Class)artefact;
                if (ArtefactHandler.class.isAssignableFrom(artefactClass)) {
                    try {
                        this.grailsApplication.registerArtefactHandler((ArtefactHandler)artefactClass.newInstance());
                    }
                    catch (InstantiationException e) {
                        LOG.error((Object)("Cannot instantiate an Artefact Handler:" + e.getMessage()), (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        LOG.error((Object)("The constructor of the Artefact Handler is not accessible:" + e.getMessage()), (Throwable)e);
                    }
                    continue;
                }
                LOG.error((Object)("This class is not an ArtefactHandler:" + artefactClass.getName()));
                continue;
            }
            if (artefact instanceof ArtefactHandler) {
                this.grailsApplication.registerArtefactHandler((ArtefactHandler)artefact);
                continue;
            }
            LOG.error((Object)("This object is not an ArtefactHandler:" + artefact + "[" + artefact.getClass().getName() + "]"));
        }
    }

    @Override
    public Class<?>[] getProvidedArtefacts() {
        return this.providedArtefacts;
    }

    @Override
    public List<String> getPluginExcludes() {
        return this.pluginExcludes;
    }

    @Override
    public Collection<? extends TypeFilter> getTypeFilters() {
        return this.typeFilters;
    }

    public String getFullName() {
        return this.getName() + "-" + this.getVersion();
    }

    public Resource getDescriptor() {
        return new SpringResource(this.pluginDescriptor);
    }

    @Override
    public void setDescriptor(org.springframework.core.io.Resource descriptor) {
        this.pluginDescriptor = descriptor;
    }

    public Resource getPluginDir() {
        try {
            return new SpringResource(this.pluginDescriptor.createRelative("."));
        }
        catch (IOException e) {
            return null;
        }
    }

    public Map getProperties() {
        return DefaultGroovyMethods.getProperties((Object)this.plugin);
    }
}

