/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjaropenbeans;

import groovyjarjarharmonybeans.BeansUtils;
import groovyjarjarharmonybeans.internal.nls.Messages;
import groovyjarjaropenbeans.FeatureDescriptor;
import groovyjarjaropenbeans.IntrospectionException;
import groovyjarjaropenbeans.PropertyEditor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class PropertyDescriptor
extends FeatureDescriptor {
    private Method getter;
    private Method setter;
    private Class<?> propertyEditorClass;
    boolean constrained;
    boolean bound;

    public PropertyDescriptor(String propertyName, Class<?> beanClass, String getterName, String setterName) throws IntrospectionException {
        if (beanClass == null) {
            throw new IntrospectionException(Messages.getString("beans.03"));
        }
        if (propertyName == null || propertyName.length() == 0) {
            throw new IntrospectionException(Messages.getString("beans.04"));
        }
        this.setName(propertyName);
        if (getterName != null) {
            if (getterName.length() == 0) {
                throw new IntrospectionException("read or write method cannot be empty.");
            }
            try {
                this.setReadMethod(beanClass, getterName);
            }
            catch (IntrospectionException e) {
                this.setReadMethod(beanClass, this.createDefaultMethodName(propertyName, "get"));
            }
        }
        if (setterName != null) {
            if (setterName.length() == 0) {
                throw new IntrospectionException("read or write method cannot be empty.");
            }
            this.setWriteMethod(beanClass, setterName);
        }
    }

    public PropertyDescriptor(String propertyName, Method getter, Method setter) throws IntrospectionException {
        if (propertyName == null || propertyName.length() == 0) {
            throw new IntrospectionException(Messages.getString("beans.04"));
        }
        this.setName(propertyName);
        this.setReadMethod(getter);
        this.setWriteMethod(setter);
    }

    public PropertyDescriptor(String propertyName, Class<?> beanClass) throws IntrospectionException {
        if (beanClass == null) {
            throw new IntrospectionException(Messages.getString("beans.03"));
        }
        if (propertyName == null || propertyName.length() == 0) {
            throw new IntrospectionException(Messages.getString("beans.04"));
        }
        this.setName(propertyName);
        try {
            this.setReadMethod(beanClass, this.createDefaultMethodName(propertyName, "is"));
        }
        catch (Exception e) {
            this.setReadMethod(beanClass, this.createDefaultMethodName(propertyName, "get"));
        }
        this.setWriteMethod(beanClass, this.createDefaultMethodName(propertyName, "set"));
    }

    public void setWriteMethod(Method setter) throws IntrospectionException {
        if (setter != null) {
            int modifiers = setter.getModifiers();
            if (!Modifier.isPublic(modifiers)) {
                throw new IntrospectionException(Messages.getString("beans.05"));
            }
            Class<?>[] parameterTypes = setter.getParameterTypes();
            if (parameterTypes.length != 1) {
                throw new IntrospectionException(Messages.getString("beans.06"));
            }
            Class<?> parameterType = parameterTypes[0];
            Class<?> propertyType = this.getPropertyType();
            if (propertyType != null && !propertyType.equals(parameterType)) {
                throw new IntrospectionException(Messages.getString("beans.07"));
            }
        }
        this.setter = setter;
    }

    public void setReadMethod(Method getter) throws IntrospectionException {
        if (getter != null) {
            int modifiers = getter.getModifiers();
            if (!Modifier.isPublic(modifiers)) {
                throw new IntrospectionException(Messages.getString("beans.0A"));
            }
            Class<?>[] parameterTypes = getter.getParameterTypes();
            if (parameterTypes.length != 0) {
                throw new IntrospectionException(Messages.getString("beans.08"));
            }
            Class<?> returnType = getter.getReturnType();
            if (returnType.equals(Void.TYPE)) {
                throw new IntrospectionException(Messages.getString("beans.33"));
            }
            Class<?> propertyType = this.getPropertyType();
            if (propertyType != null && !returnType.equals(propertyType)) {
                throw new IntrospectionException(Messages.getString("beans.09"));
            }
        }
        this.getter = getter;
    }

    public Method getWriteMethod() {
        return this.setter;
    }

    public Method getReadMethod() {
        return this.getter;
    }

    public boolean equals(Object object) {
        boolean result = object instanceof PropertyDescriptor;
        if (result) {
            PropertyDescriptor pd = (PropertyDescriptor)object;
            boolean gettersAreEqual = this.getter == null && pd.getReadMethod() == null || this.getter != null && this.getter.equals(pd.getReadMethod());
            boolean settersAreEqual = this.setter == null && pd.getWriteMethod() == null || this.setter != null && this.setter.equals(pd.getWriteMethod());
            boolean propertyTypesAreEqual = this.getPropertyType() == pd.getPropertyType();
            boolean propertyEditorClassesAreEqual = this.getPropertyEditorClass() == pd.getPropertyEditorClass();
            boolean boundPropertyAreEqual = this.isBound() == pd.isBound();
            boolean constrainedPropertyAreEqual = this.isConstrained() == pd.isConstrained();
            result = gettersAreEqual && settersAreEqual && propertyTypesAreEqual && propertyEditorClassesAreEqual && boundPropertyAreEqual && constrainedPropertyAreEqual;
        }
        return result;
    }

    public int hashCode() {
        return BeansUtils.getHashCode(this.getter) + BeansUtils.getHashCode(this.setter) + BeansUtils.getHashCode(this.getPropertyType()) + BeansUtils.getHashCode(this.getPropertyEditorClass()) + BeansUtils.getHashCode(this.isBound()) + BeansUtils.getHashCode(this.isConstrained());
    }

    public void setPropertyEditorClass(Class<?> propertyEditorClass) {
        this.propertyEditorClass = propertyEditorClass;
    }

    public Class<?> getPropertyType() {
        Class<?> result = null;
        if (this.getter != null) {
            result = this.getter.getReturnType();
        } else if (this.setter != null) {
            Class<?>[] parameterTypes = this.setter.getParameterTypes();
            result = parameterTypes[0];
        }
        return result;
    }

    public Class<?> getPropertyEditorClass() {
        return this.propertyEditorClass;
    }

    public void setConstrained(boolean constrained) {
        this.constrained = constrained;
    }

    public void setBound(boolean bound) {
        this.bound = bound;
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public boolean isBound() {
        return this.bound;
    }

    String createDefaultMethodName(String propertyName, String prefix) {
        String result = null;
        if (propertyName != null) {
            String bos = BeansUtils.toASCIIUpperCase(propertyName.substring(0, 1));
            String eos = propertyName.substring(1, propertyName.length());
            result = String.valueOf(prefix) + bos + eos;
        }
        return result;
    }

    void setReadMethod(Class<?> beanClass, String getterName) throws IntrospectionException {
        try {
            Method readMethod = beanClass.getMethod(getterName, new Class[0]);
            this.setReadMethod(readMethod);
        }
        catch (Exception e) {
            throw new IntrospectionException(e.getLocalizedMessage());
        }
    }

    void setWriteMethod(Class<?> beanClass, String setterName) throws IntrospectionException {
        Method writeMethod = null;
        try {
            if (this.getter != null) {
                writeMethod = beanClass.getMethod(setterName, this.getter.getReturnType());
            } else {
                Class<?> clazz = beanClass;
                Method[] methods = null;
                while (clazz != null && writeMethod == null) {
                    Method[] methodArray = methods = clazz.getDeclaredMethods();
                    int n = methods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Method method = methodArray[n2];
                        if (setterName.equals(method.getName()) && method.getParameterTypes().length == 1) {
                            writeMethod = method;
                            break;
                        }
                        ++n2;
                    }
                    clazz = clazz.getSuperclass();
                }
            }
        }
        catch (Exception e) {
            throw new IntrospectionException(e.getLocalizedMessage());
        }
        if (writeMethod == null) {
            throw new IntrospectionException(Messages.getString("beans.64", setterName));
        }
        this.setWriteMethod(writeMethod);
    }

    public PropertyEditor createPropertyEditor(Object bean) {
        PropertyEditor editor;
        if (this.propertyEditorClass == null) {
            return null;
        }
        if (!PropertyEditor.class.isAssignableFrom(this.propertyEditorClass)) {
            throw new ClassCastException(Messages.getString("beans.48"));
        }
        try {
            try {
                Constructor<?> constr = this.propertyEditorClass.getConstructor(Object.class);
                editor = (PropertyEditor)constr.newInstance(bean);
            }
            catch (NoSuchMethodException e) {
                Constructor<?> constr = this.propertyEditorClass.getConstructor(new Class[0]);
                editor = (PropertyEditor)constr.newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            RuntimeException re = new RuntimeException(Messages.getString("beans.47"), e);
            throw re;
        }
        return editor;
    }
}

