/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjaropenbeans;

import groovyjarjaropenbeans.Encoder;
import groovyjarjaropenbeans.Expression;
import groovyjarjaropenbeans.PersistenceDelegate;
import groovyjarjaropenbeans.Statement;
import java.lang.reflect.Array;

class ArrayPersistenceDelegate
extends PersistenceDelegate {
    private static PersistenceDelegate pd = null;

    ArrayPersistenceDelegate() {
    }

    public static PersistenceDelegate getInstance() {
        if (pd == null) {
            pd = new ArrayPersistenceDelegate();
        }
        return pd;
    }

    @Override
    protected Expression instantiate(Object oldInstance, Encoder out) {
        assert (oldInstance != null && oldInstance.getClass().isArray()) : oldInstance;
        int length = Array.getLength(oldInstance);
        Class<?> componentType = oldInstance.getClass().getComponentType();
        return new Expression(oldInstance, Array.class, "newInstance", new Object[]{componentType, length});
    }

    @Override
    protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
        assert (oldInstance != null && oldInstance.getClass().isArray()) : oldInstance;
        assert (newInstance != null && newInstance.getClass().isArray()) : newInstance;
        int length = Array.getLength(oldInstance);
        int i = 0;
        while (i < length) {
            Object newValue;
            Object oldValue = Array.get(oldInstance, i);
            if (!this.deepEquals(oldValue, newValue = Array.get(newInstance, i))) {
                Statement s = new Statement(oldInstance, "set", new Object[]{i, oldValue});
                out.writeStatement(s);
            }
            ++i;
        }
    }

    private boolean deepEquals(Object oldInstance, Object newInstance) {
        if (oldInstance == newInstance) {
            return true;
        }
        if (oldInstance == null || newInstance == null) {
            return false;
        }
        if (oldInstance.getClass().isAssignableFrom(newInstance.getClass()) && oldInstance.equals(newInstance)) {
            return true;
        }
        if (oldInstance.getClass().isArray() && newInstance.getClass().isArray()) {
            int length2;
            int length1 = Array.getLength(oldInstance);
            if (length1 != (length2 = Array.getLength(newInstance))) {
                return false;
            }
            int i = 0;
            while (i < length1) {
                Object newValue;
                Object oldValue = Array.get(oldInstance, i);
                if (!this.deepEquals(oldValue, newValue = Array.get(newInstance, i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean mutatesTo(Object oldInstance, Object newInstance) {
        if (oldInstance == null || newInstance == null) {
            return false;
        }
        if (!oldInstance.getClass().isArray() || !newInstance.getClass().isArray()) {
            return false;
        }
        int l1 = Array.getLength(oldInstance);
        int l2 = Array.getLength(newInstance);
        Class<?> cType1 = oldInstance.getClass().getComponentType();
        Class<?> cType2 = newInstance.getClass().getComponentType();
        return l1 == l2 && cType1.equals(cType2);
    }
}

