/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.gamma.transactions.fat;

import org.multiverse.api.lifecycle.TxnEvent;
import org.multiverse.stms.gamma.GammaStm;
import org.multiverse.stms.gamma.Listeners;
import org.multiverse.stms.gamma.transactionalobjects.BaseGammaTxnRef;
import org.multiverse.stms.gamma.transactionalobjects.Tranlocal;
import org.multiverse.stms.gamma.transactions.GammaTxn;
import org.multiverse.stms.gamma.transactions.GammaTxnConfig;

public final class FatMonoGammaTxn
extends GammaTxn {
    public final Tranlocal tranlocal = new Tranlocal();

    public FatMonoGammaTxn(GammaStm stm) {
        this(new GammaTxnConfig(stm));
    }

    public FatMonoGammaTxn(GammaTxnConfig config) {
        super(config, 3);
        this.richmansMansConflictScan = false;
    }

    @Override
    public final Tranlocal locate(BaseGammaTxnRef o) {
        if (this.status != 1) {
            throw this.abortLocateOnBadStatus(o);
        }
        if (o == null) {
            throw this.abortLocateOnNullArgument();
        }
        return this.getRefTranlocal(o);
    }

    @Override
    public final void commit() {
        BaseGammaTxnRef owner;
        if (this.status == 4) {
            return;
        }
        if (this.status != 1 && this.status != 2) {
            throw this.abortCommitOnBadStatus();
        }
        if (this.abortOnly) {
            throw this.abortCommitOnAbortOnly();
        }
        if (this.status == 1) {
            this.notifyListeners(TxnEvent.PrePrepare);
        }
        if ((owner = this.tranlocal.owner) != null) {
            if (this.hasWrites) {
                Listeners listeners;
                if (this.status == 1 && !this.skipPrepare() && !owner.prepare(this, this.tranlocal)) {
                    throw this.abortOnReadWriteConflict(owner);
                }
                if (this.commitConflict) {
                    this.config.globalConflictCounter.signalConflict();
                }
                if ((listeners = owner.commit(this.tranlocal, this.pool)) != null) {
                    listeners.openAll(this.pool);
                }
            } else {
                owner.releaseAfterReading(this.tranlocal, this.pool);
            }
        }
        this.tranlocal.owner = null;
        this.status = 4;
        this.notifyListeners(TxnEvent.PostCommit);
    }

    @Override
    public final void abort() {
        if (this.status == 3) {
            return;
        }
        if (this.status == 4) {
            throw this.failAbortOnAlreadyCommitted();
        }
        this.status = 3;
        BaseGammaTxnRef owner = this.tranlocal.owner;
        if (owner != null) {
            owner.releaseAfterFailure(this.tranlocal, this.pool);
        }
        this.notifyListeners(TxnEvent.PostAbort);
    }

    @Override
    public final void prepare() {
        if (this.status == 2) {
            return;
        }
        if (this.status != 1) {
            throw this.abortPrepareOnBadStatus();
        }
        if (this.abortOnly) {
            throw this.abortPrepareOnAbortOnly();
        }
        this.notifyListeners(TxnEvent.PrePrepare);
        BaseGammaTxnRef owner = this.tranlocal.owner;
        if (owner != null && !owner.prepare(this, this.tranlocal)) {
            throw this.abortOnReadWriteConflict(owner);
        }
        this.status = 2;
    }

    @Override
    public final Tranlocal getRefTranlocal(BaseGammaTxnRef ref) {
        return this.tranlocal.owner == ref ? this.tranlocal : null;
    }

    @Override
    public final void retry() {
        if (this.status != 1) {
            throw this.abortRetryOnBadStatus();
        }
        if (!this.config.isBlockingAllowed()) {
            throw this.abortRetryOnNoBlockingAllowed();
        }
        if (this.tranlocal == null) {
            throw this.abortRetryOnNoRetryPossible();
        }
        BaseGammaTxnRef owner = this.tranlocal.owner;
        if (owner == null) {
            throw this.abortRetryOnNoRetryPossible();
        }
        this.retryListener.reset();
        long listenerEra = this.retryListener.getEra();
        boolean atLeastOneRegistration = false;
        switch (this.tranlocal.owner.registerChangeListener(this.retryListener, this.tranlocal, this.pool, listenerEra)) {
            case 0: {
                atLeastOneRegistration = true;
                break;
            }
            case 1: {
                atLeastOneRegistration = true;
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        owner.releaseAfterFailure(this.tranlocal, this.pool);
        this.status = 3;
        if (!atLeastOneRegistration) {
            throw this.abortRetryOnNoRetryPossible();
        }
        throw this.newRetryError();
    }

    @Override
    public final boolean softReset() {
        if (this.attempt >= this.config.getMaxRetries()) {
            return false;
        }
        if (this.listeners != null) {
            this.listeners.clear();
            this.pool.putArrayList(this.listeners);
            this.listeners = null;
        }
        this.status = 1;
        this.hasWrites = false;
        ++this.attempt;
        this.abortOnly = false;
        this.commitConflict = false;
        this.evaluatingCommute = false;
        return true;
    }

    @Override
    public final void hardReset() {
        if (this.listeners != null) {
            this.listeners.clear();
            this.pool.putArrayList(this.listeners);
            this.listeners = null;
        }
        this.status = 1;
        this.hasWrites = false;
        this.remainingTimeoutNs = this.config.timeoutNs;
        this.attempt = 1;
        this.abortOnly = false;
        this.commitConflict = false;
        this.evaluatingCommute = false;
    }

    @Override
    public final boolean isReadConsistent(Tranlocal justAdded) {
        return true;
    }

    @Override
    public void initLocalConflictCounter() {
    }
}

