/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.kordamp.jarviz.bundle.RB;
import org.kordamp.jarviz.core.JarvizException;
import org.kordamp.jarviz.util.Algorithm;

public class ChecksumUtils {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private ChecksumUtils() {
    }

    public static String checksum(Algorithm algorithm, Path path) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm.formatted());
            return ChecksumUtils.encodeHex(digest.digest(Files.readAllBytes(path)));
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new JarvizException(RB.$("ERROR_UNEXPECTED", new Object[0]), e);
        }
    }

    private static String encodeHex(byte[] data) {
        char[] out = new char[data.length << 1];
        int j = 0;
        for (int i = 0; i < data.length; ++i) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
        }
        return new String(out);
    }
}

