/*
 * Decompiled with CFR 0.152.
 */
package ccl.servlet;

import ccl.servlet.HTML;
import ccl.util.DBUtil;
import ccl.util.Util;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class TableHelpServlet
extends HttpServlet {
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            String sTable;
            HTML html = new HTML(response);
            this.printTitle(html);
            this.printTOC(html);
            Connection connection = this.createConnection();
            Vector vTables = DBUtil.getUserTables(connection);
            Enumeration eTables = vTables.elements();
            while (eTables.hasMoreElements()) {
                sTable = (String)eTables.nextElement();
                html.printBR("<a href=\"" + ((Object)((Object)this)).getClass().getName() + "?table=" + sTable + "\">" + sTable + "</a>");
            }
            sTable = request.getParameter("table");
            if (!Util.isEmpty(sTable)) {
                DatabaseMetaData metaData = connection.getMetaData();
                ResultSet result = metaData.getColumns(null, null, sTable, null);
                html.println("<h2>Table '" + sTable + "'</h2>");
                html.printDataTableStart("#ffc000", "#c8c8c8");
                html.printDataTableHeader("Nr.", "right");
                html.printDataTableHeader("Name");
                html.printDataTableHeader("Type");
                html.printDataTableHeader("Null");
                html.endDataTableLine();
                int row = 1;
                while (result.next()) {
                    String sColumn = result.getString("COLUMN_NAME");
                    html.printDataTableValue(Util.itoa(row), "right");
                    html.printDataTableValue(sColumn);
                    html.printDataTableValue(result.getString("TYPE_NAME"));
                    html.printDataTableValue(result.getString("IS_NULLABLE"));
                    html.endDataTableLine();
                    ++row;
                }
                html.printTableEnd();
                result.close();
            }
            connection.close();
            this.close(html);
        }
        catch (Exception exception) {
            new ServletException(Util.getStackTrace(exception));
        }
    }

    public abstract void printTitle(HTML var1);

    public abstract void printTOC(HTML var1) throws Exception;

    public abstract void close(HTML var1);

    public abstract Connection createConnection() throws SQLException;
}

