/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm.jta.jeremie;

import org.objectweb.jeremie.services.handler.api.Service;
import org.objectweb.jonathan.apis.kernel.Context;
import org.objectweb.jonathan.apis.kernel.JonathanException;
import org.objectweb.jonathan.helpers.MessageHelpers;
import org.objectweb.jonathan.presentation.api.Marshaller;
import org.objectweb.jonathan.presentation.api.MarshallerFactory;
import org.objectweb.jonathan.presentation.api.UnMarshaller;
import org.objectweb.jonathan.resources.api.Chunk;
import org.objectweb.jotm.TransactionContext;
import org.objectweb.jotm.jta.jeremie.JotmTransactionReceiver;
import org.objectweb.jotm.jta.jeremie.JotmTransactionSender;
import org.omg.IOP.ServiceContext;

public class TSHandler
implements Service {
    private JotmTransactionSender sender = null;
    private JotmTransactionReceiver receiver = null;
    private MarshallerFactory mf;
    private int service_id = 0;

    public TSHandler(Context c, Object[] used_components) throws JonathanException {
        int sid = (Integer)used_components[0];
        if (sid != Integer.MAX_VALUE) {
            this.service_id = sid;
        }
        try {
            this.sender = (JotmTransactionSender)used_components[1];
            this.receiver = (JotmTransactionReceiver)used_components[2];
            this.mf = (MarshallerFactory)used_components[3];
        }
        catch (Exception e) {
            throw new JonathanException(e);
        }
    }

    public ServiceContext getRequestContext(int id, boolean r, byte[] key, Context k) {
        if (this.sender == null) {
            return null;
        }
        TransactionContext ctx = this.sender.sending_request();
        return this.encodeContext(ctx);
    }

    public ServiceContext getReplyContext(int id, Context k) {
        if (this.receiver == null) {
            return null;
        }
        TransactionContext ctx = this.receiver.sending_reply();
        return this.encodeContext(ctx);
    }

    public void handleRequestContext(ServiceContext context, int id, boolean r, byte[] key, Context k) {
        if (this.receiver == null || context == null) {
            return;
        }
        TransactionContext ctx = this.decodeContext(context);
        if (ctx != null) {
            this.receiver.received_request(ctx);
        }
    }

    public void handleReplyContext(ServiceContext context, int id, Context k) {
        if (this.sender == null || context == null) {
            return;
        }
        TransactionContext ctx = this.decodeContext(context);
        if (ctx != null) {
            this.sender.received_reply(ctx);
        }
    }

    private ServiceContext encodeContext(TransactionContext ctx) {
        if (ctx == null) {
            return null;
        }
        Marshaller marshaller = this.mf.newMarshaller();
        byte[] byteArray = null;
        try {
            marshaller.writeValue((Object)ctx);
            byteArray = MessageHelpers.copy((Marshaller)marshaller);
            marshaller.close();
        }
        catch (Exception e) {
            System.err.println("TSHandler.encodeContext: exception");
        }
        return new ServiceContext(this.service_id, byteArray);
    }

    private TransactionContext decodeContext(ServiceContext sc) {
        if (sc == null || sc.context_data == null || sc.context_data.length == 0) {
            return null;
        }
        TransactionContext ctx = null;
        byte[] byteArray = sc.context_data;
        UnMarshaller unmarshaller = this.mf.newUnMarshaller(new Chunk(byteArray, 0, byteArray.length), 0);
        try {
            ctx = (TransactionContext)unmarshaller.readValue();
            unmarshaller.close();
        }
        catch (Exception e) {
            System.err.println("TSHandler.decodeContext: exception");
            System.err.println(e.toString() + "\n");
        }
        return ctx;
    }
}

