/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.builder;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.internal.StringLocalizer;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class I15dPanelBuilder
extends PanelBuilder {
    private static final String DEBUG_TOOL_TIPS_ENABLED_KEY = "I15dPanelBuilder.debugToolTipsEnabled";
    private static boolean debugToolTipsEnabled = I15dPanelBuilder.getDebugToolTipSystemProperty();
    private final StringLocalizer localizer;

    public I15dPanelBuilder(FormLayout layout, ResourceBundle bundle) {
        this(layout, bundle, new JPanel(null));
    }

    public I15dPanelBuilder(FormLayout layout, ResourceBundle bundle, JPanel container) {
        this(layout, new ResourceBundleLocalizer(bundle), container);
    }

    public I15dPanelBuilder(FormLayout layout, StringLocalizer localizer) {
        this(layout, localizer, new JPanel(null));
    }

    public I15dPanelBuilder(FormLayout layout, StringLocalizer localizer, JPanel container) {
        super(layout, container);
        this.localizer = localizer;
    }

    public static boolean isDebugToolTipsEnabled() {
        return debugToolTipsEnabled;
    }

    public static void setDebugToolTipsEnabled(boolean b) {
        debugToolTipsEnabled = b;
    }

    @Override
    public I15dPanelBuilder background(Color background) {
        super.background(background);
        return this;
    }

    @Override
    public I15dPanelBuilder border(Border border) {
        super.border(border);
        return this;
    }

    @Override
    public I15dPanelBuilder border(String emptyBorderSpec) {
        super.border(emptyBorderSpec);
        return this;
    }

    @Override
    public I15dPanelBuilder opaque(boolean b) {
        super.opaque(b);
        return this;
    }

    public final JLabel addI15dLabel(String resourceKey, CellConstraints constraints) {
        JLabel label = this.addLabel(this.getI15dString(resourceKey), constraints);
        if (I15dPanelBuilder.isDebugToolTipsEnabled()) {
            label.setToolTipText(resourceKey);
        }
        return label;
    }

    public final JLabel addI15dLabel(String resourceKey, String encodedConstraints) {
        return this.addI15dLabel(resourceKey, new CellConstraints(encodedConstraints));
    }

    public final JLabel addI15dLabel(String resourceKey, CellConstraints labelConstraints, Component component, CellConstraints componentConstraints) {
        JLabel label = this.addLabel(this.getI15dString(resourceKey), labelConstraints, component, componentConstraints);
        if (I15dPanelBuilder.isDebugToolTipsEnabled()) {
            label.setToolTipText(resourceKey);
        }
        return label;
    }

    public final JLabel addI15dROLabel(String resourceKey, CellConstraints constraints) {
        JLabel label = this.addROLabel(this.getI15dString(resourceKey), constraints);
        if (I15dPanelBuilder.isDebugToolTipsEnabled()) {
            label.setToolTipText(resourceKey);
        }
        return label;
    }

    public final JLabel addI15dROLabel(String resourceKey, String encodedConstraints) {
        return this.addI15dROLabel(resourceKey, new CellConstraints(encodedConstraints));
    }

    public final JLabel addI15dROLabel(String resourceKey, CellConstraints labelConstraints, Component component, CellConstraints componentConstraints) {
        JLabel label = this.addROLabel(this.getI15dString(resourceKey), labelConstraints, component, componentConstraints);
        if (I15dPanelBuilder.isDebugToolTipsEnabled()) {
            label.setToolTipText(resourceKey);
        }
        return label;
    }

    public final JComponent addI15dSeparator(String resourceKey, CellConstraints constraints) {
        JComponent component = this.addSeparator(this.getI15dString(resourceKey), constraints);
        if (I15dPanelBuilder.isDebugToolTipsEnabled()) {
            component.setToolTipText(resourceKey);
        }
        return component;
    }

    public final JComponent addI15dSeparator(String resourceKey, String encodedConstraints) {
        return this.addI15dSeparator(resourceKey, new CellConstraints(encodedConstraints));
    }

    public final JLabel addI15dTitle(String resourceKey, CellConstraints constraints) {
        JLabel label = this.addTitle(this.getI15dString(resourceKey), constraints);
        if (I15dPanelBuilder.isDebugToolTipsEnabled()) {
            label.setToolTipText(resourceKey);
        }
        return label;
    }

    public final JLabel addI15dTitle(String resourceKey, String encodedConstraints) {
        return this.addI15dTitle(resourceKey, new CellConstraints(encodedConstraints));
    }

    protected final String getI15dString(String resourceKey) {
        Preconditions.checkState((this.localizer != null ? 1 : 0) != 0, (String)"To use the internationalization support a ResourceBundle or StringLocalizer must be provided during the builder construction.");
        try {
            return this.localizer.getString(resourceKey);
        }
        catch (MissingResourceException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Missing internationalized label", ex);
            return resourceKey;
        }
    }

    private static boolean getDebugToolTipSystemProperty() {
        try {
            String value = System.getProperty(DEBUG_TOOL_TIPS_ENABLED_KEY);
            return "true".equalsIgnoreCase(value);
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private static final class ResourceBundleLocalizer
    implements StringLocalizer {
        private final ResourceBundle bundle;

        private ResourceBundleLocalizer(ResourceBundle bundle) {
            this.bundle = (ResourceBundle)Preconditions.checkNotNull((Object)bundle, (String)"The resource bundle must not be null.");
        }

        public String getString(String resourceKey) {
            try {
                return this.bundle.getString(resourceKey);
            }
            catch (MissingResourceException mre) {
                return resourceKey;
            }
        }
    }
}

