/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl.module;

import com.fasterxml.classmate.ResolvedType;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class FlattenedOptionalModule
implements Module {
    private static boolean isOptional(ResolvedType type) {
        return type.getErasedType() == Optional.class;
    }

    private List<ResolvedType> resolveOptionalComponentType(MemberScope<?, ?> fieldOrMethod) {
        return FlattenedOptionalModule.isOptional(fieldOrMethod.getType()) ? Collections.singletonList(fieldOrMethod.getTypeParameterFor(Optional.class, 0)) : null;
    }

    @Override
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        builder.forFields().withTargetTypeOverridesResolver(this::resolveOptionalComponentType).withNullableCheck(field -> FlattenedOptionalModule.isOptional(field.getDeclaredType()) ? Boolean.TRUE : null);
        builder.forMethods().withTargetTypeOverridesResolver(this::resolveOptionalComponentType).withNullableCheck(method -> FlattenedOptionalModule.isOptional(method.getDeclaredType()) ? Boolean.TRUE : null);
    }
}

