/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jreleaser.model.AbstractAssembler;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Glob;
import org.jreleaser.model.Java;
import org.jreleaser.model.JavaAssembler;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Version;

abstract class AbstractJavaAssembler
extends AbstractAssembler
implements JavaAssembler {
    protected final Artifact mainJar = new Artifact();
    protected final List<Glob> jars = new ArrayList<Glob>();
    protected final List<Glob> files = new ArrayList<Glob>();
    protected final Java java = new Java();
    protected String executable;
    protected String templateDirectory;

    protected AbstractJavaAssembler(String type) {
        super(type);
    }

    void setAll(AbstractJavaAssembler assembler) {
        super.setAll(assembler);
        this.executable = assembler.executable;
        this.templateDirectory = assembler.templateDirectory;
        this.setJava(assembler.java);
        this.setMainJar(assembler.mainJar);
        this.setJars(assembler.jars);
        this.setFiles(assembler.files);
    }

    @Override
    public Map<String, Object> props() {
        Map<String, Object> props = super.props();
        props.put("distributionExecutable", this.executable);
        props.putAll(this.java.getResolvedExtraProperties());
        CollectionUtils.safePut((String)"distributionJavaGroupId", (Object)this.java.getGroupId(), props, (boolean)true);
        CollectionUtils.safePut((String)"distributionJavaArtifactId", (Object)this.java.getArtifactId(), props, (boolean)true);
        CollectionUtils.safePut((String)"distributionJavaMainClass", (Object)this.java.getMainClass(), props, (boolean)true);
        if (StringUtils.isNotBlank((String)this.java.getVersion())) {
            props.put("distributionJavaVersion", this.java.getVersion());
            Version jv = Version.of((String)this.java.getVersion());
            CollectionUtils.safePut((String)"distributionJavaVersionMajor", (Object)jv.getMajor(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionMinor", (Object)jv.getMinor(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionPatch", (Object)jv.getPatch(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionTag", (Object)jv.getTag(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionBuild", (Object)jv.getBuild(), props, (boolean)true);
        } else {
            props.put("distributionJavaVersion", "");
            props.put("distributionJavaVersionMajor", "");
            props.put("distributionJavaVersionMinor", "");
            props.put("distributionJavaVersionPatch", "");
            props.put("distributionJavaVersionTag", "");
            props.put("distributionJavaVersionBuild", "");
        }
        return props;
    }

    @Override
    public String getExecutable() {
        return this.executable;
    }

    @Override
    public void setExecutable(String executable) {
        this.executable = executable;
    }

    @Override
    public String getTemplateDirectory() {
        return this.templateDirectory;
    }

    @Override
    public void setTemplateDirectory(String templateDirectory) {
        this.templateDirectory = templateDirectory;
    }

    @Override
    public Java getJava() {
        return this.java;
    }

    @Override
    public void setJava(Java java) {
        this.java.setAll(java);
    }

    @Override
    public Artifact getMainJar() {
        return this.mainJar;
    }

    @Override
    public void setMainJar(Artifact mainJar) {
        this.mainJar.setAll(mainJar);
    }

    @Override
    public List<Glob> getJars() {
        return this.jars;
    }

    @Override
    public void setJars(List<Glob> jars) {
        this.jars.clear();
        this.jars.addAll(jars);
    }

    @Override
    public void addJars(List<Glob> jars) {
        this.jars.addAll(jars);
    }

    @Override
    public void addJar(Glob jar) {
        if (null != jar) {
            this.jars.add(jar);
        }
    }

    @Override
    public List<Glob> getFiles() {
        return this.files;
    }

    @Override
    public void setFiles(List<Glob> files) {
        this.files.clear();
        this.files.addAll(files);
    }

    @Override
    public void addFiles(List<Glob> files) {
        this.files.addAll(files);
    }

    @Override
    public void addFile(Glob file) {
        if (null != file) {
            this.files.add(file);
        }
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("executable", this.executable);
        props.put("templateDirectory", this.templateDirectory);
        props.put("mainJar", this.mainJar.asMap(full));
        LinkedHashMap<String, Map<String, Object>> mappedJars = new LinkedHashMap<String, Map<String, Object>>();
        for (int i = 0; i < this.jars.size(); ++i) {
            mappedJars.put("glob " + i, this.jars.get(i).asMap(full));
        }
        props.put("jars", mappedJars);
        LinkedHashMap<String, Map<String, Object>> mappedFiles = new LinkedHashMap<String, Map<String, Object>>();
        for (int i = 0; i < this.files.size(); ++i) {
            mappedFiles.put("glob " + i, this.files.get(i).asMap(full));
        }
        props.put("files", mappedFiles);
        props.put("extraProperties", this.getResolvedExtraProperties());
        if (this.java.isEnabled()) {
            props.put("java", this.java.asMap(full));
        }
    }
}

