/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractRepositoryTap;
import org.jreleaser.model.AbstractRepositoryTool;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.RepositoryTap;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class Gofish
extends AbstractRepositoryTool {
    public static final String NAME = "gofish";
    public static final String SKIP_GOFISH = "skipGofish";
    private final GofishRepository repository = new GofishRepository();

    public Gofish() {
        super(NAME);
    }

    void setAll(Gofish spec) {
        super.setAll(spec);
        this.setRepository(spec.repository);
    }

    public GofishRepository getRepository() {
        return this.repository;
    }

    public void setRepository(GofishRepository repository) {
        this.repository.setAll(repository);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("repository", this.repository.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.repository;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isMac((String)platform) || PlatformUtils.isWindows((String)platform) || PlatformUtils.isLinux((String)platform) && !PlatformUtils.isAlpineLinux((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution distribution) {
        return distribution.getType() == Distribution.DistributionType.JAVA_BINARY || distribution.getType() == Distribution.DistributionType.JLINK || distribution.getType() == Distribution.DistributionType.NATIVE_IMAGE || distribution.getType() == Distribution.DistributionType.BINARY;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add(FileType.TAR_GZ.extension());
        set.add(FileType.TAR_XZ.extension());
        set.add(FileType.TGZ.extension());
        set.add(FileType.TXZ.extension());
        set.add(FileType.TAR.extension());
        set.add(FileType.ZIP.extension());
        return set;
    }

    public static class GofishRepository
    extends AbstractRepositoryTap {
        public GofishRepository() {
            super(Gofish.NAME, "fish-food");
        }
    }
}

