/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.AbstractUploader;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Artifactory;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Domain;
import org.jreleaser.model.EnabledAware;
import org.jreleaser.model.ExtraProperties;
import org.jreleaser.model.Http;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.S3;
import org.jreleaser.model.Uploader;
import org.jreleaser.util.StringUtils;

public class Upload
implements Domain,
EnabledAware {
    private final Map<String, Artifactory> artifactory = new LinkedHashMap<String, Artifactory>();
    private final Map<String, Http> http = new LinkedHashMap<String, Http>();
    private final Map<String, S3> s3 = new LinkedHashMap<String, S3>();
    private Boolean enabled;

    void setAll(Upload assemble) {
        this.enabled = assemble.enabled;
        this.setArtifactory(assemble.artifactory);
        this.setHttp(assemble.http);
        this.setS3(assemble.s3);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabledSet() {
        return this.enabled != null;
    }

    public List<Artifactory> getActiveArtifactories() {
        return this.artifactory.values().stream().filter(AbstractUploader::isEnabled).collect(Collectors.toList());
    }

    public Map<String, Artifactory> getArtifactory() {
        return this.artifactory;
    }

    public void setArtifactory(Map<String, Artifactory> artifactory) {
        this.artifactory.clear();
        this.artifactory.putAll(artifactory);
    }

    public void addArtifactory(Artifactory artifactory) {
        this.artifactory.put(artifactory.getType(), artifactory);
    }

    public List<Http> getActiveHttps() {
        return this.http.values().stream().filter(AbstractUploader::isEnabled).collect(Collectors.toList());
    }

    public Map<String, Http> getHttp() {
        return this.http;
    }

    public void setHttp(Map<String, Http> http) {
        this.http.clear();
        this.http.putAll(http);
    }

    public void addHttp(Http http) {
        this.http.put(http.getType(), http);
    }

    public List<S3> getActiveS3s() {
        return this.s3.values().stream().filter(AbstractUploader::isEnabled).collect(Collectors.toList());
    }

    public Map<String, S3> getS3() {
        return this.s3;
    }

    public void setS3(Map<String, S3> s3) {
        this.s3.clear();
        this.s3.putAll(s3);
    }

    public void addS3(S3 s3) {
        this.s3.put(s3.getType(), s3);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        List s3;
        List http;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        List artifactory = this.artifactory.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList());
        if (!artifactory.isEmpty()) {
            map.put("artifactory", artifactory);
        }
        if (!(http = this.http.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("http", http);
        }
        if (!(s3 = this.s3.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("s3", s3);
        }
        return map;
    }

    public <A extends Uploader> Map<String, A> findUploadersByType(String uploaderType) {
        switch (uploaderType) {
            case "artifactory": {
                return this.artifactory;
            }
            case "http": {
                return this.http;
            }
            case "s3": {
                return this.s3;
            }
        }
        return Collections.emptyMap();
    }

    public <A extends Uploader> List<A> findAllActiveUploaders() {
        ArrayList<AbstractUploader> uploaders = new ArrayList<AbstractUploader>();
        uploaders.addAll(this.getActiveArtifactories());
        uploaders.addAll(this.getActiveHttps());
        uploaders.addAll(this.getActiveS3s());
        return uploaders;
    }

    public Map<String, String> resolveDownloadUrls(JReleaserContext context, Distribution distribution, Artifact artifact, String prefix) {
        Uploader uploader;
        List<String> keys;
        LinkedHashMap<String, String> urls = new LinkedHashMap<String, String>();
        List uploaders = this.findAllActiveUploaders();
        for (Uploader uploader2 : uploaders) {
            List<String> keys2 = uploader2.resolveSkipKeys();
            if (this.isSkip(distribution, keys2) || this.isSkip(artifact, keys2)) continue;
            String key = prefix + "Download" + StringUtils.capitalize((String)uploader2.getType()) + StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)uploader2.getName()) + "Url";
            String url = uploader2.getResolvedDownloadUrl(context, artifact);
            urls.put(key, url);
            if (this.findUploadersByType(uploader2.getType()).size() != 1 || this.isSkip(distribution, keys2) || this.isSkip(artifact, keys2)) continue;
            key = prefix + "Download" + StringUtils.capitalize((String)uploader2.getType()) + "Url";
            url = uploader2.getResolvedDownloadUrl(context, artifact);
            urls.put(key, url);
        }
        if (uploaders.size() == 1 && !this.isSkip(distribution, keys = (uploader = (Uploader)uploaders.get(0)).resolveSkipKeys()) && !this.isSkip(artifact, keys)) {
            String key = prefix + "DownloadUrl";
            String url = uploader.getResolvedDownloadUrl(context, artifact);
            urls.put(key, url);
        }
        return urls;
    }

    private boolean isSkip(ExtraProperties props, List<String> keys) {
        for (String key : keys) {
            if (!props.extraPropertyIsTrue(key)) continue;
            return true;
        }
        return false;
    }

    public static Set<String> supportedUploaders() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add("artifactory");
        set.add("http");
        set.add("s3");
        return Collections.unmodifiableSet(set);
    }
}

