/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.List;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.Gofish;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.validation.DistributionsValidator;
import org.jreleaser.model.validation.ExtraPropertiesValidator;
import org.jreleaser.model.validation.TemplateValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class GofishValidator
extends Validator {
    public static void validateGofish(JReleaserContext context, Distribution distribution, Gofish tool, Errors errors) {
        JReleaserModel model = context.getModel();
        Gofish parentTool = model.getPackagers().getGofish();
        if (!tool.isActiveSet() && parentTool.isActiveSet()) {
            tool.setActive(parentTool.getActive());
        }
        if (!tool.resolveEnabled(context.getModel().getProject(), distribution)) {
            tool.disable();
            return;
        }
        GitService service = model.getRelease().getGitService();
        if (!service.isReleaseSupported()) {
            tool.disable();
            return;
        }
        context.getLogger().debug("distribution.{}.gofish", new Object[]{distribution.getName()});
        GofishValidator.validateCommitAuthor(tool, parentTool);
        Gofish.GofishRepository repository = tool.getRepository();
        repository.resolveEnabled(model.getProject());
        GofishValidator.validateTap(context, distribution, repository, parentTool.getRepository(), "gofish.repository");
        TemplateValidator.validateTemplate(context, distribution, tool, parentTool, errors);
        ExtraPropertiesValidator.mergeExtraProperties(tool, parentTool);
        GofishValidator.validateContinueOnError(tool, parentTool);
        DistributionsValidator.validateArtifactPlatforms(context, distribution, tool, errors);
        List candidateArtifacts = distribution.getArtifacts().stream().filter(Artifact::isActive).filter(artifact -> tool.getSupportedExtensions().stream().anyMatch(ext -> artifact.getPath().endsWith((String)ext))).filter(artifact -> tool.supportsPlatform(artifact.getPlatform())).filter(artifact -> !StringUtils.isTrue((Object)artifact.getExtraProperties().get("skipGofish"))).collect(Collectors.toList());
        if (candidateArtifacts.size() == 0) {
            tool.setActive(Active.NEVER);
            tool.disable();
        } else if (candidateArtifacts.stream().filter(artifact -> StringUtils.isBlank((String)artifact.getPlatform())).count() > 1L) {
            errors.configuration(RB.$((String)"validation_tool_multiple_artifacts", (Object[])new Object[]{"distribution." + distribution.getName() + ".gofish"}));
            tool.disable();
        }
    }
}

