/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.gitlab;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormData;
import feign.form.FormEncoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.tika.Tika;
import org.apache.tika.mime.MediaType;
import org.jreleaser.bundle.RB;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.gitlab.api.FileUpload;
import org.jreleaser.sdk.gitlab.api.GitlabAPI;
import org.jreleaser.sdk.gitlab.api.Milestone;
import org.jreleaser.sdk.gitlab.api.Project;
import org.jreleaser.sdk.gitlab.api.Release;
import org.jreleaser.sdk.gitlab.api.User;
import org.jreleaser.sdk.gitlab.internal.UrlEncoder;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.StringUtils;

class Gitlab {
    static final String ENDPOINT = "https://gitlab.com/api/v4";
    private static final String API_V4 = "/api/v4";
    private final Tika tika = new Tika();
    private final JReleaserLogger logger;
    private final GitlabAPI api;
    private final String apiHost;
    private User user;
    private Project project;

    Gitlab(JReleaserLogger logger, String endpoint, String token, int connectTimeout, int readTimeout) throws IOException {
        Objects.requireNonNull(logger, "'logger' must not be null");
        StringUtils.requireNonBlank((String)token, (String)"'token' must not be blank");
        if (StringUtils.isBlank((String)endpoint)) {
            endpoint = ENDPOINT;
        }
        if (!endpoint.endsWith(API_V4)) {
            if (endpoint.endsWith("/")) {
                endpoint = endpoint.substring(0, endpoint.length() - 1);
            }
            endpoint = endpoint + API_V4;
        }
        this.apiHost = endpoint.substring(0, endpoint.length() - API_V4.length());
        ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.INDENT_OUTPUT, true);
        this.logger = logger;
        this.api = (GitlabAPI)ClientUtils.builder((JReleaserLogger)logger, (int)connectTimeout, (int)readTimeout).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder(objectMapper))).decoder((Decoder)new JacksonDecoder(objectMapper)).requestInterceptor(template -> template.header("Authorization", new String[]{String.format("Bearer %s", token)})).target(GitlabAPI.class, endpoint);
    }

    Project findProject(String projectName, String identifier) throws RestAPIException {
        return this.getProject(projectName, identifier);
    }

    Optional<Milestone> findMilestoneByName(String owner, String repo, String identifier, String milestoneName) throws IOException {
        this.logger.debug(RB.$((String)"git.milestone.lookup", (Object[])new Object[0]), new Object[]{milestoneName, owner, repo});
        Project project = this.getProject(repo, identifier);
        try {
            List<Milestone> milestones = this.api.findMilestoneByTitle(project.getId(), (Map<String, Object>)CollectionUtils.map().e((Object)"title", (Object)milestoneName));
            if (milestones == null || milestones.isEmpty()) {
                return Optional.empty();
            }
            Milestone milestone = milestones.get(0);
            return "active".equals(milestone.getState()) ? Optional.of(milestone) : Optional.empty();
        }
        catch (RestAPIException e) {
            if (e.isNotFound() || e.isForbidden()) {
                return Optional.empty();
            }
            throw e;
        }
    }

    void closeMilestone(String owner, String repo, String identifier, Milestone milestone) throws IOException {
        this.logger.debug(RB.$((String)"git.milestone.close", (Object[])new Object[0]), new Object[]{milestone.getTitle(), owner, repo});
        Project project = this.getProject(repo, identifier);
        this.api.updateMilestone((Map<String, Object>)CollectionUtils.map().e((Object)"state_event", (Object)"close"), project.getId(), milestone.getId());
    }

    Project createProject(String owner, String repo) throws IOException {
        this.logger.debug(RB.$((String)"git.project.create", (Object[])new Object[0]), new Object[]{owner, repo});
        return this.api.createProject(repo, "public");
    }

    User getCurrentUser() throws RestAPIException {
        if (null == this.user) {
            this.logger.debug(RB.$((String)"git.fetch.current.user", (Object[])new Object[0]));
            this.user = this.api.getCurrentUser();
        }
        return this.user;
    }

    Project getProject(String projectName, String identifier) throws RestAPIException {
        if (null == this.project) {
            if (StringUtils.isNotBlank((String)identifier)) {
                this.logger.debug(RB.$((String)"git.fetch.gitlab.project_by_id", (Object[])new Object[0]), new Object[]{identifier});
                this.project = this.api.getProject(identifier.trim());
            } else {
                User u = this.getCurrentUser();
                this.logger.debug(RB.$((String)"git.fetch.gitlab.project.by.user", (Object[])new Object[0]), new Object[]{projectName, u.getUsername(), u.getId()});
                List<Project> projects = this.api.getProject(u.getId(), (Map<String, Object>)CollectionUtils.map().e((Object)"search", (Object)projectName));
                if (projects == null || projects.isEmpty()) {
                    throw new RestAPIException(404, RB.$((String)"ERROR_project_not_exist", (Object[])new Object[]{projectName}));
                }
                this.project = projects.get(0);
            }
            this.logger.debug(RB.$((String)"git.gitlab.project.found", (Object[])new Object[0]), new Object[]{this.project.getNameWithNamespace(), this.project.getId()});
        }
        return this.project;
    }

    Release findReleaseByTag(String owner, String repoName, String identifier, String tagName) throws RestAPIException {
        this.logger.debug(RB.$((String)"git.fetch.release.by.tag", (Object[])new Object[0]), new Object[]{owner, repoName, tagName});
        Project project = this.getProject(repoName, identifier);
        try {
            return this.api.getRelease(project.getId(), UrlEncoder.urlEncode(tagName));
        }
        catch (RestAPIException e) {
            if (e.isNotFound() || e.isForbidden()) {
                return null;
            }
            throw e;
        }
    }

    void deleteTag(String owner, String repoName, String identifier, String tagName) throws RestAPIException {
        this.logger.debug(RB.$((String)"git.delete.tag.from", (Object[])new Object[0]), new Object[]{tagName, owner, repoName});
        Project project = this.getProject(repoName, identifier);
        this.api.deleteTag(project.getId(), UrlEncoder.urlEncode(tagName));
    }

    void deleteRelease(String owner, String repoName, String identifier, String tagName) throws RestAPIException {
        this.logger.debug(RB.$((String)"git.delete.release.from", (Object[])new Object[0]), new Object[]{tagName, owner, repoName});
        Project project = this.getProject(repoName, identifier);
        this.api.deleteRelease(project.getId(), UrlEncoder.urlEncode(tagName));
    }

    void createRelease(String owner, String repoName, String identifier, Release release) throws RestAPIException {
        this.logger.debug(RB.$((String)"git.create.release", (Object[])new Object[0]), new Object[]{owner, repoName, release.getTagName()});
        Project project = this.getProject(repoName, identifier);
        this.api.createRelease(release, project.getId());
    }

    void updateRelease(String owner, String repoName, String identifier, Release release) throws RestAPIException {
        this.logger.debug(RB.$((String)"git.update.release", (Object[])new Object[0]), new Object[]{owner, repoName, release.getTagName()});
        Project project = this.getProject(repoName, identifier);
        this.api.updateRelease(release, project.getId());
    }

    List<FileUpload> uploadAssets(String owner, String repoName, String identifier, List<Path> assets) throws IOException, RestAPIException {
        this.logger.debug(RB.$((String)"git.upload.assets", (Object[])new Object[0]), new Object[]{owner, repoName});
        ArrayList<FileUpload> uploads = new ArrayList<FileUpload>();
        Project project = this.getProject(repoName, identifier);
        for (Path asset : assets) {
            if (0L == asset.toFile().length() || !Files.exists(asset, new LinkOption[0])) continue;
            this.logger.info(" " + RB.$((String)"git.upload.asset", (Object[])new Object[0]), new Object[]{asset.getFileName().toString()});
            try {
                FileUpload upload = this.api.uploadFile(project.getId(), this.toFormData(asset));
                upload.setName(asset.getFileName().toString());
                uploads.add(upload);
            }
            catch (IOException | RestAPIException e) {
                this.logger.error(" " + RB.$((String)"git.upload.asset.failure", (Object[])new Object[0]), new Object[]{asset.getFileName()});
                throw e;
            }
        }
        return uploads;
    }

    void linkAssets(String owner, String repoName, Release release, String identifier, List<FileUpload> uploads) throws IOException, RestAPIException {
        this.logger.debug(RB.$((String)"git.upload.asset.links", (Object[])new Object[0]), new Object[]{owner, repoName, release.getTagName()});
        Project project = this.getProject(repoName, identifier);
        for (FileUpload upload : uploads) {
            this.logger.debug(" " + RB.$((String)"git.upload.asset.link", (Object[])new Object[0]), new Object[]{upload.getName()});
            try {
                this.api.linkAsset(upload.toLinkRequest(this.apiHost), project.getId(), release.getTagName());
            }
            catch (RestAPIException e) {
                this.logger.error(" " + RB.$((String)"git.upload.asset.link.failure", (Object[])new Object[0]), new Object[]{upload.getName()});
                throw e;
            }
        }
    }

    Optional<org.jreleaser.model.releaser.spi.User> findUser(String email, String name) throws RestAPIException {
        User user;
        this.logger.debug(RB.$((String)"git.user.lookup", (Object[])new Object[0]), new Object[]{name, email});
        List<User> users = this.api.searchUser(CollectionUtils.newMap((Object[])new Object[]{"scope", "users", "search", email}));
        if (users != null && !users.isEmpty()) {
            User user2 = users.get(0);
            return Optional.of(new org.jreleaser.model.releaser.spi.User(user2.getUsername(), email, user2.getWebUrl()));
        }
        users = this.api.searchUser(CollectionUtils.newMap((Object[])new Object[]{"scope", "users", "search", name}));
        if (users != null && !users.isEmpty() && name.equals((user = users.get(0)).getName())) {
            return Optional.of(new org.jreleaser.model.releaser.spi.User(user.getUsername(), email, user.getWebUrl()));
        }
        return Optional.empty();
    }

    private FormData toFormData(Path asset) throws IOException {
        return FormData.builder().fileName(asset.getFileName().toString()).contentType(MediaType.parse((String)this.tika.detect(asset)).toString()).data(Files.readAllBytes(asset)).build();
    }
}

