/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.function.Predicate;
import org.jreleaser.model.Project;
import org.jreleaser.util.StringUtils;

public enum Active {
    ALWAYS(project -> true),
    NEVER(project -> false),
    RELEASE(Project::isRelease),
    SNAPSHOT(Project::isSnapshot);

    private final Predicate<Project> test;

    private Active(Predicate<Project> test) {
        this.test = test;
    }

    boolean check(Project project) {
        return this.test.test(project);
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public static Active of(String str) {
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        return Active.valueOf(str.toUpperCase().trim());
    }
}

