/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractAssembler;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.FileSet;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class Archive
extends AbstractAssembler {
    public static final String NAME = "archive";
    private final Set<Format> formats = new LinkedHashSet<Format>();
    private final List<FileSet> fileSets = new ArrayList<FileSet>();
    private String archiveName;
    private Boolean attachPlatform;
    private Distribution.DistributionType distributionType;

    public Archive() {
        super(NAME);
    }

    @Override
    public Distribution.DistributionType getDistributionType() {
        return this.distributionType;
    }

    public void setDistributionType(Distribution.DistributionType distributionType) {
        this.distributionType = distributionType;
    }

    public void setDistributionType(String distributionType) {
        this.distributionType = Distribution.DistributionType.of(distributionType);
    }

    void setAll(Archive archive) {
        super.setAll(archive);
        this.archiveName = archive.archiveName;
        this.distributionType = archive.distributionType;
        this.attachPlatform = archive.attachPlatform;
        this.setFormats(archive.formats);
        this.setFileSets(archive.fileSets);
    }

    public String getResolvedArchiveName(JReleaserContext context) {
        Map<String, Object> props = context.props();
        props.putAll(this.props());
        String result = MustacheUtils.applyTemplate((String)this.archiveName, props);
        if (this.isAttachPlatform()) {
            result = result + "-" + PlatformUtils.getCurrentFull();
        }
        return result;
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public void setArchiveName(String archiveName) {
        this.archiveName = archiveName;
    }

    public boolean isAttachPlatformSet() {
        return this.attachPlatform;
    }

    public boolean isAttachPlatform() {
        return this.attachPlatform != null && this.attachPlatform != false;
    }

    public void setAttachPlatform(Boolean attachPlatform) {
        this.attachPlatform = attachPlatform;
    }

    public Set<Format> getFormats() {
        return this.formats;
    }

    public void setFormats(Set<Format> formats) {
        this.formats.clear();
        this.formats.addAll(formats);
    }

    public void addFormat(Format format) {
        this.formats.add(format);
    }

    public void addFormat(String str) {
        this.formats.add(Format.of(str));
    }

    public List<FileSet> getFileSets() {
        return this.fileSets;
    }

    public void setFileSets(List<FileSet> fileSets) {
        this.fileSets.clear();
        this.fileSets.addAll(fileSets);
    }

    public void addFileSets(List<FileSet> files) {
        this.fileSets.addAll(files);
    }

    public void addFileSet(FileSet file) {
        if (null != file) {
            this.fileSets.add(file);
        }
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("archiveName", this.archiveName);
        props.put("distributionType", (Object)this.distributionType);
        props.put("attachPlatform", this.isAttachPlatform());
        props.put("formats", this.formats);
        LinkedHashMap<String, Map<String, Object>> mappedFileSets = new LinkedHashMap<String, Map<String, Object>>();
        for (int i = 0; i < this.fileSets.size(); ++i) {
            mappedFileSets.put("fileSet " + i, this.fileSets.get(i).asMap(full));
        }
        props.put("fileSets", mappedFileSets);
    }

    public static enum Format {
        ZIP("zip"),
        TAR("tar"),
        TGZ("tgz"),
        TAR_GZ("tar.gz");

        private final String extension;

        private Format(String extension) {
            this.extension = extension;
        }

        public String extension() {
            return this.extension;
        }

        public String toString() {
            return this.extension();
        }

        public static Format of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            return Format.valueOf(str.toUpperCase().trim().replace(".", "_"));
        }
    }
}

