/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jreleaser.model.Domain;
import org.jreleaser.util.StringUtils;

public class CaskItem
implements Domain {
    private final List<String> items = new ArrayList<String>();
    private String name;

    public CaskItem(String name, List<String> items) {
        this.name = name;
        this.items.addAll(items);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getItems() {
        return this.items;
    }

    public void setItems(List<String> items) {
        this.items.clear();
        this.items.addAll(items);
    }

    public void addItems(List<String> item) {
        this.items.addAll(item);
    }

    public void addItem(String item) {
        if (StringUtils.isNotBlank((String)item)) {
            this.items.add(item.trim());
        }
    }

    public void removeItem(String item) {
        if (StringUtils.isNotBlank((String)item)) {
            this.items.remove(item.trim());
        }
    }

    public boolean getHasItems() {
        return !this.items.isEmpty();
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        return this.asMap();
    }

    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.name, this.items);
        return map;
    }
}

