/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.assemblers;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jreleaser.assemblers.AbstractAssemblerProcessor;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Archive;
import org.jreleaser.model.FileSet;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.assembler.spi.AssemblerProcessingException;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.StringUtils;

public class ArchiveAssemblerProcessor
extends AbstractAssemblerProcessor<Archive> {
    public ArchiveAssemblerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doAssemble(Map<String, Object> props) throws AssemblerProcessingException {
        Path assembleDirectory = (Path)props.get("distributionAssembleDirectory");
        String archiveName = ((Archive)this.assembler).getResolvedArchiveName(this.context);
        Path workDirectory = assembleDirectory.resolve("work");
        Path archiveDirectory = workDirectory.resolve(archiveName);
        try {
            FileUtils.deleteFiles((Path)workDirectory);
            Files.createDirectories(archiveDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_delete_archive", (Object[])new Object[]{archiveName}), (Throwable)e);
        }
        this.context.getLogger().debug(RB.$((String)"assembler.copy.files", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(archiveDirectory)});
        this.copyFiles(this.context, archiveDirectory);
        for (Archive.Format format : ((Archive)this.assembler).getFormats()) {
            this.archive(workDirectory, assembleDirectory, archiveName, format);
        }
    }

    private void archive(Path workDirectory, Path assembleDirectory, String archiveName, Archive.Format format) throws AssemblerProcessingException {
        String finalArchiveName = archiveName + "." + format.extension();
        this.context.getLogger().info("- {}", new Object[]{finalArchiveName});
        try {
            Path archiveFile = assembleDirectory.resolve(finalArchiveName);
            switch (format) {
                case ZIP: {
                    FileUtils.zip((Path)workDirectory, (Path)archiveFile);
                    break;
                }
                case TAR: {
                    FileUtils.tar((Path)workDirectory, (Path)archiveFile);
                    break;
                }
                case TGZ: 
                case TAR_GZ: {
                    FileUtils.tgz((Path)workDirectory, (Path)archiveFile);
                }
            }
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private void copyFiles(JReleaserContext context, Path destination) throws AssemblerProcessingException {
        try {
            for (FileSet fileSet : ((Archive)this.assembler).getFileSets()) {
                Path src = context.getBasedir().resolve(fileSet.getInput());
                Path dest = destination;
                if (StringUtils.isNotBlank((String)fileSet.getOutput())) {
                    dest = destination.resolve(fileSet.getOutput());
                }
                if (FileUtils.copyFilesRecursive((JReleaserLogger)context.getLogger(), (Path)src, (Path)dest, this.filter(fileSet))) continue;
                throw new IOException(RB.$((String)"ERROR_repository_copy_files", (Object[])new Object[]{context.relativizeToBasedir(src)}));
            }
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_copying_files", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private Predicate<Path> filter(final FileSet fileSet) {
        return new Predicate<Path>(){
            private final Set<Pattern> includes;
            private final Set<Pattern> excludes;
            {
                this.includes = fileSet.getIncludes().stream().map(StringUtils::toSafePattern).collect(Collectors.toSet());
                this.excludes = fileSet.getExcludes().stream().map(StringUtils::toSafePattern).collect(Collectors.toSet());
            }

            @Override
            public boolean test(Path path) {
                if (!this.includes.isEmpty()) {
                    for (Pattern pattern : this.includes) {
                        if (pattern.matcher(path.getFileName().toString()).matches()) continue;
                        return true;
                    }
                }
                if (!this.excludes.isEmpty()) {
                    for (Pattern pattern : this.excludes) {
                        if (!pattern.matcher(path.getFileName().toString()).matches()) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }
}

