/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.tools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Tool;
import org.jreleaser.model.tool.spi.ToolProcessingException;
import org.jreleaser.model.tool.spi.ToolProcessor;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.command.Command;
import org.jreleaser.util.command.CommandException;
import org.jreleaser.util.command.CommandExecutor;

abstract class AbstractToolProcessor<T extends Tool>
implements ToolProcessor<T> {
    protected final JReleaserContext context;
    protected T tool;

    protected AbstractToolProcessor(JReleaserContext context) {
        this.context = context;
    }

    public T getTool() {
        return this.tool;
    }

    public void setTool(T tool) {
        this.tool = tool;
    }

    public String getToolName() {
        return this.tool.getName();
    }

    public boolean supportsDistribution(Distribution distribution) {
        return true;
    }

    public void prepareDistribution(Distribution distribution, Map<String, Object> props) throws ToolProcessingException {
        try {
            String distributionName = distribution.getName();
            this.context.getLogger().debug(RB.$((String)"tool.create.properties", (Object[])new Object[0]), new Object[]{distributionName, this.getToolName()});
            Map<String, Object> newProps = this.fillProps(distribution, props);
            if (newProps.isEmpty()) {
                this.context.getLogger().warn(RB.$((String)"tool.skip.distribution", (Object[])new Object[0]), new Object[]{distributionName});
                return;
            }
            this.doPrepareDistribution(distribution, newProps);
        }
        catch (RuntimeException e) {
            throw new ToolProcessingException((Throwable)e);
        }
    }

    protected abstract void doPrepareDistribution(Distribution var1, Map<String, Object> var2) throws ToolProcessingException;

    public void packageDistribution(Distribution distribution, Map<String, Object> props) throws ToolProcessingException {
        try {
            String distributionName = distribution.getName();
            this.context.getLogger().debug(RB.$((String)"tool.create.properties", (Object[])new Object[0]), new Object[]{distributionName, this.getToolName()});
            Map<String, Object> newProps = this.fillProps(distribution, props);
            if (newProps.isEmpty()) {
                this.context.getLogger().warn(RB.$((String)"tool.skip.distribution", (Object[])new Object[0]), new Object[]{distributionName});
                return;
            }
            this.doPackageDistribution(distribution, newProps);
        }
        catch (IllegalArgumentException e) {
            throw new ToolProcessingException((Throwable)e);
        }
    }

    public void publishDistribution(Distribution distribution, Map<String, Object> props) throws ToolProcessingException {
        if (this.context.getModel().getProject().isSnapshot() && !this.tool.isSnapshotSupported()) {
            this.context.getLogger().info(RB.$((String)"tool.publish.snapshot.not.supported", (Object[])new Object[0]));
            return;
        }
        try {
            String distributionName = distribution.getName();
            this.context.getLogger().debug(RB.$((String)"tool.create.properties", (Object[])new Object[0]), new Object[]{distributionName, this.getToolName()});
            Map<String, Object> newProps = this.fillProps(distribution, props);
            if (newProps.isEmpty()) {
                this.context.getLogger().warn(RB.$((String)"tool.skip.distribution", (Object[])new Object[0]), new Object[]{distributionName});
                return;
            }
            this.doPublishDistribution(distribution, newProps);
        }
        catch (IllegalArgumentException e) {
            throw new ToolProcessingException((Throwable)e);
        }
    }

    protected abstract void doPackageDistribution(Distribution var1, Map<String, Object> var2) throws ToolProcessingException;

    protected abstract void doPublishDistribution(Distribution var1, Map<String, Object> var2) throws ToolProcessingException;

    protected Map<String, Object> fillProps(Distribution distribution, Map<String, Object> props) throws ToolProcessingException {
        LinkedHashMap<String, Object> newProps = new LinkedHashMap<String, Object>(props);
        this.context.getLogger().debug(RB.$((String)"tool.fill.distribution.properties", (Object[])new Object[0]));
        this.fillDistributionProperties(newProps, distribution);
        this.context.getLogger().debug(RB.$((String)"tool.fill.git.properties", (Object[])new Object[0]));
        this.context.getModel().getRelease().getGitService().fillProps(newProps, this.context.getModel());
        this.context.getLogger().debug(RB.$((String)"tool.fill.artifact.properties", (Object[])new Object[0]));
        if (!this.verifyAndAddArtifacts(newProps, distribution)) {
            return Collections.emptyMap();
        }
        this.context.getLogger().debug(RB.$((String)"tool.fill.tool.properties", (Object[])new Object[0]));
        this.fillToolProperties(newProps, distribution);
        MustacheUtils.applyTemplates(newProps, (Map)this.tool.getResolvedExtraProperties());
        if (StringUtils.isBlank((String)this.context.getModel().getRelease().getGitService().getReverseRepoHost())) {
            newProps.put("reverseRepoHost", this.tool.getExtraProperties().get("reverseRepoHost"));
        }
        return newProps;
    }

    protected void fillDistributionProperties(Map<String, Object> props, Distribution distribution) {
        props.putAll(distribution.props());
    }

    protected abstract void fillToolProperties(Map<String, Object> var1, Distribution var2) throws ToolProcessingException;

    protected void executeCommand(Path directory, Command command) throws ToolProcessingException {
        try {
            int exitValue = new CommandExecutor(this.context.getLogger()).executeCommand(directory, command);
            if (exitValue != 0) {
                throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{exitValue}));
            }
        }
        catch (CommandException e) {
            throw new ToolProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void executeCommand(Command command) throws ToolProcessingException {
        try {
            int exitValue = new CommandExecutor(this.context.getLogger()).executeCommand(command);
            if (exitValue != 0) {
                throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{exitValue}));
            }
        }
        catch (CommandException e) {
            throw new ToolProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void executeCommandCapturing(Command command, OutputStream out) throws ToolProcessingException {
        try {
            int exitValue = new CommandExecutor(this.context.getLogger()).executeCommandCapturing(command, out);
            if (exitValue != 0) {
                this.context.getLogger().error(out.toString().trim());
                throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{exitValue}));
            }
        }
        catch (CommandException e) {
            throw new ToolProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void executeCommandWithInput(Command command, InputStream in) throws ToolProcessingException {
        try {
            int exitValue = new CommandExecutor(this.context.getLogger()).executeCommandWithInput(command, in);
            if (exitValue != 0) {
                throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{exitValue}));
            }
        }
        catch (CommandException e) {
            throw new ToolProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void copyPreparedFiles(Distribution distribution, Map<String, Object> props) throws ToolProcessingException {
        Path packageDirectory = this.getPackageDirectory(props);
        this.copyPreparedFiles(distribution, props, packageDirectory);
    }

    protected void copyPreparedFiles(Distribution distribution, Map<String, Object> props, Path outputDirectory) throws ToolProcessingException {
        Path prepareDirectory = this.getPrepareDirectory(props);
        try {
            if (!FileUtils.copyFilesRecursive((JReleaserLogger)this.context.getLogger(), (Path)prepareDirectory, (Path)outputDirectory)) {
                throw new ToolProcessingException(RB.$((String)"ERROR_copy_files_from_to", (Object[])new Object[]{this.context.relativizeToBasedir(prepareDirectory), this.context.relativizeToBasedir(outputDirectory)}));
            }
        }
        catch (IOException e) {
            throw new ToolProcessingException(RB.$((String)"ERROR_unexpected_copy_files_from_to", (Object[])new Object[]{this.context.relativizeToBasedir(prepareDirectory), this.context.relativizeToBasedir(outputDirectory)}), (Throwable)e);
        }
    }

    protected boolean verifyAndAddArtifacts(Map<String, Object> props, Distribution distribution) throws ToolProcessingException {
        return this.verifyAndAddArtifacts(props, distribution, this.collectArtifacts(distribution));
    }

    protected boolean verifyAndAddArtifacts(Map<String, Object> props, Distribution distribution, List<Artifact> artifacts) throws ToolProcessingException {
        List activeArtifacts = artifacts.stream().filter(Artifact::isActive).collect(Collectors.toList());
        if (activeArtifacts.size() == 0) {
            this.context.getLogger().warn(RB.$((String)"tool.no.matching.artifacts", (Object[])new Object[0]), new Object[]{distribution.getName(), StringUtils.capitalize((String)this.tool.getName())});
            return false;
        }
        for (int i = 0; i < activeArtifacts.size(); ++i) {
            Artifact artifact = (Artifact)activeArtifacts.get(i);
            String platform = StringUtils.isNotBlank((String)artifact.getPlatform()) ? StringUtils.capitalize((String)artifact.getPlatform()) : "";
            Map artifactProps = artifact.getResolvedExtraProperties("artifact" + platform);
            artifactProps.keySet().stream().filter(k -> !props.containsKey(k)).forEach(k -> props.put((String)k, artifactProps.get(k)));
            Path artifactPath = artifact.getEffectivePath(this.context);
            long artifactSize = 0L;
            try {
                artifactSize = Files.size(artifactPath);
            }
            catch (IOException ignored) {
                this.context.getLogger().trace((Throwable)ignored);
            }
            String artifactFileName = artifactPath.getFileName().toString();
            String artifactName = StringUtils.getFilename((String)artifactFileName, (Collection)this.tool.getSupportedExtensions());
            props.put("artifact" + platform + "Size", artifactSize);
            props.put("artifact" + platform + "Name", artifactName);
            props.put("artifact" + platform + "FileName", artifactFileName);
            for (Algorithm algorithm : this.context.getModel().getChecksum().getAlgorithms()) {
                props.put("artifact" + platform + "Checksum" + StringUtils.capitalize((String)algorithm.formatted()), artifact.getHash(algorithm));
            }
            LinkedHashMap<String, Object> newProps = new LinkedHashMap<String, Object>(props);
            newProps.put("artifactFileName", artifactFileName);
            String artifactUrl = MustacheUtils.applyTemplate((String)this.context.getModel().getRelease().getGitService().getDownloadUrl(), newProps);
            props.put("artifact" + platform + "Url", artifactUrl);
            props.putAll(this.context.getModel().getUpload().resolveDownloadUrls(this.context, distribution, artifact, "artifact" + platform));
            if (0 != i) continue;
            props.putAll(this.context.getModel().getUpload().resolveDownloadUrls(this.context, distribution, artifact, "distribution"));
            props.put("distributionArtifact", artifact);
            props.put("distributionUrl", artifactUrl);
            props.put("distributionSize", artifactSize);
            props.put("distributionSha256", artifact.getHash(Algorithm.SHA_256));
            for (Algorithm algorithm : this.context.getModel().getChecksum().getAlgorithms()) {
                props.put("distributionChecksum" + StringUtils.capitalize((String)algorithm.formatted()), artifact.getHash(algorithm));
            }
            props.put("distributionArtifactFileName", artifactFileName);
            props.put("distributionArtifactName", artifactName);
            props.put("distributionArtifactSize", artifactSize);
            props.put("distributionArtifactPlatform", artifact.getPlatform());
            props.put("artifactFileName", artifactFileName);
            props.put("artifactName", artifactName);
            props.put("artifactSize", artifactSize);
            Map aprops = artifact.getResolvedExtraProperties();
            MustacheUtils.applyTemplates((Map)aprops, (Map)aprops);
            aprops.keySet().stream().filter(k -> !props.containsKey(k)).forEach(k -> props.put((String)k, aprops.get(k)));
        }
        return true;
    }

    protected List<Artifact> collectArtifacts(Distribution distribution) {
        ArrayList fileExtensions = new ArrayList(this.tool.getSupportedExtensions());
        return distribution.getArtifacts().stream().filter(Artifact::isActive).filter(artifact -> fileExtensions.stream().anyMatch(ext -> artifact.getPath().endsWith((String)ext))).filter(artifact -> this.tool.supportsPlatform(artifact.getPlatform())).sorted(Artifact.comparatorByPlatform().thenComparingInt(artifact -> {
            String ext = "." + StringUtils.getFilenameExtension((String)artifact.getPath());
            return fileExtensions.indexOf(ext);
        })).collect(Collectors.toList());
    }

    protected void info(ByteArrayOutputStream out) {
        this.log(out, arg_0 -> ((JReleaserLogger)this.context.getLogger()).info(arg_0));
    }

    protected void error(ByteArrayOutputStream err) {
        this.log(err, arg_0 -> ((JReleaserLogger)this.context.getLogger()).error(arg_0));
    }

    private void log(ByteArrayOutputStream stream, Consumer<? super String> consumer) {
        String str = stream.toString();
        if (StringUtils.isBlank((String)str)) {
            return;
        }
        Arrays.stream(str.split(System.lineSeparator())).forEach(consumer);
    }

    protected Path getPrepareDirectory(Map<String, Object> props) {
        return (Path)props.get("distributionPrepareDirectory");
    }

    protected Path getPackageDirectory(Map<String, Object> props) {
        return (Path)props.get("distributionPackageDirectory");
    }
}

