/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Announce;
import org.jreleaser.model.Assemble;
import org.jreleaser.model.Checksum;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Domain;
import org.jreleaser.model.Environment;
import org.jreleaser.model.Files;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.Packagers;
import org.jreleaser.model.Project;
import org.jreleaser.model.Release;
import org.jreleaser.model.Signing;
import org.jreleaser.model.Upload;
import org.jreleaser.model.releaser.spi.Commit;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Version;

public class JReleaserModel
implements Domain {
    private final Environment environment = new Environment();
    private final Project project = new Project();
    private final Release release = new Release();
    private final Packagers packagers = new Packagers();
    private final Announce announce = new Announce();
    private final Assemble assemble = new Assemble();
    private final Upload upload = new Upload();
    private final Checksum checksum = new Checksum();
    private final Signing signing = new Signing();
    private final Files files = new Files();
    private final Map<String, Distribution> distributions = new LinkedHashMap<String, Distribution>();
    private final ZonedDateTime now = ZonedDateTime.now();
    private final String timestamp = this.now.format(new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).optionalStart().appendOffset("+HH:MM", "Z").optionalEnd().toFormatter());
    private Commit commit;

    public ZonedDateTime getNow() {
        return this.now;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public Commit getCommit() {
        return this.commit;
    }

    public void setCommit(Commit commit) {
        this.commit = commit;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment.setAll(environment);
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project.setAll(project);
    }

    public Release getRelease() {
        return this.release;
    }

    public void setRelease(Release release) {
        this.release.setAll(release);
    }

    public Packagers getPackagers() {
        return this.packagers;
    }

    public void setPackagers(Packagers packagers) {
        this.packagers.setAll(packagers);
    }

    public Announce getAnnounce() {
        return this.announce;
    }

    public void setAnnounce(Announce announce) {
        this.announce.setAll(announce);
    }

    public Assemble getAssemble() {
        return this.assemble;
    }

    public void setAssemble(Assemble assemble) {
        this.assemble.setAll(assemble);
    }

    public Upload getUpload() {
        return this.upload;
    }

    public void setUpload(Upload upload) {
        this.upload.setAll(upload);
    }

    public Checksum getChecksum() {
        return this.checksum;
    }

    public void setChecksum(Checksum checksum) {
        this.checksum.setAll(checksum);
    }

    public Signing getSigning() {
        return this.signing;
    }

    public void setSigning(Signing signing) {
        this.signing.setAll(signing);
    }

    public Files getFiles() {
        return this.files;
    }

    public void setFiles(Files files) {
        this.files.setAll(files);
    }

    public List<Distribution> getActiveDistributions() {
        return this.distributions.values().stream().filter(Distribution::isEnabled).collect(Collectors.toList());
    }

    public Map<String, Distribution> getDistributions() {
        return this.distributions;
    }

    public void setDistributions(Map<String, Distribution> distributions) {
        this.distributions.clear();
        this.distributions.putAll(distributions);
    }

    public void addDistributions(Map<String, Distribution> distributions) {
        this.distributions.putAll(distributions);
    }

    public void addDistribution(Distribution distribution) {
        this.distributions.put(distribution.getName(), distribution);
    }

    public Distribution findDistribution(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new JReleaserException(RB.$((String)"ERROR_distribution_name_is_blank", (Object[])new Object[0]));
        }
        if (this.distributions.containsKey(name)) {
            return this.distributions.get(name);
        }
        throw new JReleaserException(RB.$((String)"ERROR_distribution_not_found", (Object[])new Object[]{name}));
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        List distributions;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.environment.isSet()) {
            map.put("environment", this.environment.asMap(full));
        }
        map.put("project", this.project.asMap(full));
        map.put("release", this.release.asMap(full));
        map.put("checksum", this.checksum.asMap(full));
        if (full || this.signing.isEnabled()) {
            map.put("signing", this.signing.asMap(full));
        }
        if (full || this.announce.isEnabled()) {
            map.put("announce", this.announce.asMap(full));
        }
        if (!this.files.isEmpty()) {
            map.put("files", this.files.asMap(full));
        }
        if (full || this.packagers.hasEnabledPackagers()) {
            map.put("packagers", this.packagers.asMap(full));
        }
        if (full || this.assemble.isEnabled()) {
            map.put("assemble", this.assemble.asMap(full));
        }
        if (full || this.upload.isEnabled()) {
            map.put("upload", this.upload.asMap(full));
        }
        if (!(distributions = this.distributions.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("distributions", distributions);
        }
        return map;
    }

    public Map<String, Object> props() {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        this.fillProjectProperties(props, this.project);
        this.fillReleaseProperties(props, this.release);
        String osName = PlatformUtils.getDetectedOs();
        String osArch = PlatformUtils.getDetectedArch();
        props.put("osName", osName);
        props.put("osArch", osArch);
        props.put("osPlatform", osName + "-" + osArch);
        props.put("osVersion", PlatformUtils.getDetectedVersion());
        MustacheUtils.applyTemplates(props, this.project.getResolvedExtraProperties());
        props.put("__ZonedDateTime_now__", this.now);
        MustacheUtils.applyFunctions(props);
        return props;
    }

    private void fillProjectProperties(Map<String, Object> props, Project project) {
        props.putAll(this.environment.getProperties());
        props.put("timestamp", this.timestamp);
        props.put("commitShortHash", this.commit.getShortHash());
        props.put("commitFullHash", this.commit.getFullHash());
        props.put("projectName", project.getName());
        props.put("projectNameCapitalized", StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)project.getName()));
        props.put("projectVersion", project.getVersion());
        props.put("projectEffectiveVersion", project.getEffectiveVersion());
        props.put("projectSnapshot", String.valueOf(project.isSnapshot()));
        if (StringUtils.isNotBlank((String)project.getDescription())) {
            props.put("projectDescription", MustacheUtils.passThrough((String)project.getDescription()));
        }
        if (StringUtils.isNotBlank((String)project.getLongDescription())) {
            props.put("projectLongDescription", MustacheUtils.passThrough((String)project.getLongDescription()));
        }
        if (StringUtils.isNotBlank((String)project.getWebsite())) {
            props.put("projectWebsite", project.getWebsite());
        }
        if (StringUtils.isNotBlank((String)project.getLicense())) {
            props.put("projectLicense", project.getLicense());
        }
        if (StringUtils.isNotBlank((String)project.getLicense())) {
            props.put("projectLicenseUrl", project.getLicenseUrl());
        }
        if (StringUtils.isNotBlank((String)project.getDocsUrl())) {
            props.put("projectDocsUrl", project.getDocsUrl());
        }
        if (StringUtils.isNotBlank((String)project.getCopyright())) {
            props.put("projectCopyright", project.getCopyright());
        }
        if (StringUtils.isNotBlank((String)project.getVendor())) {
            props.put("projectVendor", project.getVendor());
        }
        props.put("projectAuthorsBySpace", String.join((CharSequence)" ", project.getAuthors()));
        props.put("projectAuthorsByComma", String.join((CharSequence)",", project.getAuthors()));
        props.put("projectTagsBySpace", String.join((CharSequence)" ", project.getTags()));
        props.put("projectTagsByComma", String.join((CharSequence)",", project.getTags()));
        if (project.getJava().isEnabled()) {
            props.putAll(project.getJava().getResolvedExtraProperties());
            props.put("projectJavaGroupId", project.getJava().getGroupId());
            props.put("projectJavaArtifactId", project.getJava().getArtifactId());
            props.put("projectJavaVersion", project.getJava().getVersion());
            props.put("projectJavaMainClass", project.getJava().getMainClass());
            Version jv = Version.of((String)project.getJava().getVersion());
            props.put("projectJavaVersionMajor", jv.getMajor());
            if (jv.hasMinor()) {
                props.put("projectJavaVersionMinor", jv.getMinor());
            }
            if (jv.hasPatch()) {
                props.put("projectJavaVersionPatch", jv.getPatch());
            }
            if (jv.hasTag()) {
                props.put("projectJavaVersionTag", jv.getTag());
            }
            if (jv.hasBuild()) {
                props.put("projectJavaVersionBuild", jv.getBuild());
            }
        }
        project.parseVersion();
        props.putAll(project.getResolvedExtraProperties());
    }

    private void fillReleaseProperties(Map<String, Object> props, Release release) {
        GitService service = release.getGitService();
        props.put("repoHost", service.getHost());
        props.put("repoOwner", service.getOwner());
        props.put("repoName", service.getName());
        props.put("repoBranch", service.getBranch());
        props.put("tagName", service.getEffectiveTagName(this));
        props.put("releaseName", service.getEffectiveReleaseName());
        props.put("milestoneName", service.getMilestone().getEffectiveName());
        props.put("reverseRepoHost", service.getReverseRepoHost());
        props.put("repoCanonicalName", service.getCanonicalRepoName());
        props.put("repoUrl", service.getResolvedRepoUrl(this));
        props.put("repoCloneUrl", service.getResolvedRepoCloneUrl(this));
        props.put("commitsUrl", service.getResolvedCommitUrl(this));
        props.put("srcUrl", service.getResolvedSrcUrl(this));
        props.put("releaseNotesUrl", service.getResolvedReleaseNotesUrl(this));
        props.put("latestReleaseUrl", service.getResolvedLatestReleaseUrl(this));
        props.put("issueTrackerUrl", service.getResolvedIssueTrackerUrl(this));
    }
}

