/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import org.jreleaser.model.Codeberg;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.validation.GitServiceValidator;
import org.jreleaser.util.Errors;

public abstract class CodebergValidator
extends GitServiceValidator {
    public static boolean validateCodeberg(JReleaserContext context, JReleaserContext.Mode mode, Codeberg codeberg, Errors errors) {
        if (null == codeberg) {
            return false;
        }
        context.getLogger().debug("release.codeberg");
        CodebergValidator.validateGitService(context, mode, codeberg, errors);
        if (context.getModel().getProject().isSnapshot()) {
            codeberg.getPrerelease().setEnabled(true);
        }
        codeberg.getPrerelease().setPattern(CodebergValidator.checkProperty(context, "PRERELEASE_PATTERN", "codeberg.github.prerelease.pattern", codeberg.getPrerelease().getPattern(), ""));
        codeberg.getPrerelease().isPrerelease(context.getModel().getProject().getResolvedVersion());
        if (!codeberg.isDraftSet()) {
            codeberg.setDraft(CodebergValidator.checkProperty(context, "DRAFT", "codeberg.draft", null, false));
        }
        if (codeberg.isDraft()) {
            codeberg.getMilestone().setClose(false);
        }
        return codeberg.isEnabled();
    }
}

