/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.pipes.PipesConfigBase;

public class PipesConfig
extends PipesConfigBase {
    private long maxWaitForClientMillis = 60000L;

    public static PipesConfig load(Path tikaConfig) throws IOException, TikaConfigException {
        PipesConfig pipesConfig = new PipesConfig();
        try (InputStream is = Files.newInputStream(tikaConfig, new OpenOption[0]);){
            Set<String> set = pipesConfig.configure("pipes", is);
        }
        if (pipesConfig.getTikaConfig() == null) {
            throw new TikaConfigException("must specify at least a <tikaConfig> element in the <params> of <pipes>");
        }
        return pipesConfig;
    }

    private PipesConfig() {
    }

    public long getMaxWaitForClientMillis() {
        return this.maxWaitForClientMillis;
    }

    public void setMaxWaitForClientMillis(long maxWaitForClientMillis) {
        this.maxWaitForClientMillis = maxWaitForClientMillis;
    }
}

